/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CalItemGroupServiceHelper {
    public static DynamicObject[] getDataByFids(QFilter[] filters) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        String selectFields = "id,name,number,salaryitemtype,struinstag,ispayoutitem,uniquecode,taxtag,iscostallot";
        String orderBys = "number asc";
        DynamicObject[] collection = serviceHelper.query(selectFields, filters, orderBys);
        return collection;
    }

    public static DynamicObject[] getFormulaDatas(List<Long> fIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_formula");
        String selectFields = "id,number,salaryitem.id,salaryitem.uniquecode,salaryitem.salaryitemtype,salaryitem.iscostallot";
        QFilter fIdFilter = new QFilter("id", "in", fIds);
        QFilter[] filters = new QFilter[]{fIdFilter};
        String orderBys = "number asc";
        DynamicObject[] collection = serviceHelper.query(selectFields, filters, orderBys);
        return collection;
    }

    public static Map<String, DynamicObject> getSelectFormulaMap(ListSelectedRowCollection data, List<String> errorMsgList) {
        DynamicObject salaryItem = null;
        String salaryItemId = null;
        DynamicObject tempObj = null;
        ArrayList<String> existIdList = new ArrayList<String>(data.size());
        List<Long> fIds = data.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] collection = CalItemGroupServiceHelper.getFormulaDatas(fIds);
        LinkedHashMap<String, DynamicObject> dataMap = new LinkedHashMap<String, DynamicObject>(collection.length);
        for (DynamicObject selectedRow : collection) {
            salaryItem = selectedRow.getDynamicObject("salaryitem");
            if (salaryItem == null) {
                errorMsgList.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u516c\u5f0f\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u85aa\u916c\u9879\u76ee\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u6dfb\u52a0\u3002", (String)"CalRuleEdit_43", (String)"swc-hsas-formplugin", (Object[])new Object[0]), selectedRow.getString("name")));
                continue;
            }
            salaryItemId = String.valueOf(salaryItem.getLong("id"));
            tempObj = (DynamicObject)dataMap.get(salaryItemId);
            if (tempObj != null) {
                errorMsgList.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6dfb\u52a0\u85aa\u916c\u9879\u76ee\uff0c\u56e0\u4e3a\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u7684\u516c\u5f0f\u3002", (String)"CalRuleEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]), tempObj.getString("name")));
                existIdList.add(salaryItemId);
                dataMap.remove(salaryItemId);
                continue;
            }
            if (existIdList.contains(salaryItemId)) {
                errorMsgList.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6dfb\u52a0\u85aa\u916c\u9879\u76ee\uff0c\u56e0\u4e3a\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u7684\u516c\u5f0f\u3002", (String)"CalRuleEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]), selectedRow.getString("name")));
                continue;
            }
            dataMap.put(salaryItemId, selectedRow);
        }
        return dataMap;
    }

    public List<Long> checkOrGetMultiEntityFirstBsed(Date bsed, List<Long> ids, String entity) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entity);
        String selectFields = "id,bsed";
        QFilter fIdFilter = new QFilter("bsed", "<=", (Object)bsed);
        if (!SWCListUtils.isEmpty(ids)) {
            fIdFilter.and(new QFilter("id", "in", ids));
        }
        fIdFilter.and(new QFilter("status", "=", (Object)"C"));
        fIdFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        QFilter[] filters = new QFilter[]{fIdFilter};
        String orderBys = "number asc";
        DynamicObject[] collection = serviceHelper.query(selectFields, filters, orderBys);
        return Arrays.stream(collection).map(param -> param.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getSalaryItemTypeIndex(Set<Long> ids) {
        DynamicObjectCollection salaryItemTypeList = this.getSalaryItemTypeList(ids);
        return salaryItemTypeList.stream().distinct().map(data -> data.getLong("id")).collect(Collectors.toList());
    }

    public Map<Long, Long> getSalaryItemTypeIndexMap(Set<Long> ids) {
        DynamicObjectCollection salaryItemTypeList = this.getSalaryItemTypeList(ids);
        return salaryItemTypeList.stream().collect(Collectors.toMap(param -> param.getLong("id"), param -> param.getLong("index")));
    }

    private DynamicObjectCollection getSalaryItemTypeList(Set<Long> ids) {
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitemtype");
        String selectFields = "id,index";
        QFilter fIdFilter = new QFilter("id", "in", ids);
        String orderBys = "index asc";
        return salaryItemHelper.queryOriginalCollection(selectFields, fIdFilter.toArray(), orderBys);
    }

    public List<DynamicObject> selectSalaryItem(QFilter qFilter) {
        SWCDataServiceHelper formulaHelper = new SWCDataServiceHelper("hsas_formula");
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObjectCollection formulaList = formulaHelper.queryOriginalCollection("id,salaryitem.id", filters, "firstbsed asc ");
        HashSet<Long> salaryItemSet = new HashSet<Long>(formulaList.size());
        ArrayList<DynamicObject> formulaInfoList = new ArrayList<DynamicObject>(formulaList.size());
        for (DynamicObject formula : formulaList) {
            long salaryItemId = formula.getLong("salaryitem.id");
            if (salaryItemSet.contains(salaryItemId)) continue;
            formulaInfoList.add(formula);
            salaryItemSet.add(salaryItemId);
        }
        return formulaInfoList;
    }
}

