/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class AcctModifyBillPerContactUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AcctModifyBillPerContactUpdateTask.class);
    private static final int batchSize = 5000;
    private static final String tableName = "t_hsas_acctmodifybillent";
    private static final String sql = "select fentryid, fsalaryfilevid from t_hsas_acctmodifybillent where fpercontactid = 0 or fpercontactid is null";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updatePayDetailPerContactId();
            }
        }
        catch (Exception e) {
            LOG.error("AcctModifyBillPerContactUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOG.info("AcctModifyBillPerContactUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updatePayDetailPerContactId() {
        LOG.info("start to deal t_hsas_acctmodifybillent \uff1a{}", (Object)tableName);
        long startTimeMillis = System.currentTimeMillis();
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryAcctModifyBillEntSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryAcctModifyBillEntSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
            this.queryBatch = 0;
            LOG.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashSet<Long> salaryFileSet = new HashSet<Long>(5000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long salaryFileId2 = row.getLong("fsalaryfilevid");
            salaryFileSet.add(salaryFileId2);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        long endTimeMillis = System.currentTimeMillis();
        LOG.info(" execute query t_hsas_acctmodifybillent used : {}", (Object)(endTimeMillis - startTimeMillis));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsas_salaryfile");
        String selectProperties = "id,person.id";
        DynamicObject[] salaryFileCol = helper.queryOriginalArray(selectProperties, new QFilter[]{new QFilter("id", "in", salaryFileSet)});
        HashMap<Long, Long> salaryFileToPersonMap = new HashMap<Long, Long>(16);
        for (DynamicObject salaryFile : salaryFileCol) {
            salaryFileToPersonMap.put(salaryFile.getLong("id"), salaryFile.getLong("person.id"));
        }
        Map<Long, Long> perContactMap = BankAccountModifyHelper.getPerContactMapByPersonIds(new ArrayList<Long>(salaryFileToPersonMap.values()));
        HashMap salaryFileToPerContactMap = Maps.newHashMapWithExpectedSize((int)5000);
        salaryFileToPersonMap.forEach((salaryFileId, personId) -> {
            Long perContactId = perContactMap.getOrDefault(personId, -1L);
            salaryFileToPerContactMap.put(salaryFileId, perContactId);
        });
        this.updatePayDetailPerContactId(salaryFileToPerContactMap);
        return true;
    }

    private void updatePayDetailPerContactId(Map<Long, Long> salaryFileToPerContactMap) {
        String updateSql = "update t_hsas_acctmodifybillent set fpercontactid = ? where fsalaryfilevid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, Long> entry : salaryFileToPerContactMap.entrySet()) {
            Long salaryFileId = entry.getKey();
            Long perContactId = entry.getValue();
            Object[] obj = new Object[]{perContactId, salaryFileId};
            updateList.add(obj);
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, updateList);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

