/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class ApproveBillPrgpUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ApproveBillPrgpUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_approvebill");
        Object[] approveBills = swcDataServiceHelper.query("id,caltasks.fbasedataid,payrollgroups", new QFilter[0]);
        if (ArrayUtils.isEmpty((Object[])approveBills)) {
            this.disableTask();
            return;
        }
        ArrayList<Long> calTaskIds = new ArrayList<Long>(approveBills.length);
        for (Object approveBill : approveBills) {
            DynamicObjectCollection caltasks = approveBill.getDynamicObjectCollection("caltasks");
            for (DynamicObject caltask : caltasks) {
                if (caltask.getLong("fbasedataid_id") != 0L) {
                    calTaskIds.add(caltask.getLong("fbasedataid_id"));
                    continue;
                }
                LOGGER.error("approveBill\uff1a{}\uff0ccaltaskid is zero", (Object)approveBill.getLong("id"));
            }
        }
        swcDataServiceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject[] calPayRollTasks = swcDataServiceHelper.queryOriginalArray("id,payrollgroup.id", new QFilter[]{new QFilter("id", "in", calTaskIds)});
        HashMap<Long, Long> payRollGroupByCalTaskIdMap = new HashMap<Long, Long>(calPayRollTasks.length);
        for (DynamicObject calPayRollTask : calPayRollTasks) {
            payRollGroupByCalTaskIdMap.put(calPayRollTask.getLong("id"), calPayRollTask.getLong("payrollgroup.id"));
        }
        ArrayList<Object> updateApproveBills = new ArrayList<Object>(approveBills.length);
        for (Object approveBill : approveBills) {
            DynamicObjectCollection payrollgroups = approveBill.getDynamicObjectCollection("payrollgroups");
            if (payrollgroups.size() > 0) continue;
            DynamicObjectCollection caltasks = approveBill.getDynamicObjectCollection("caltasks");
            HashSet<Long> payRollGroups = new HashSet<Long>(16);
            for (DynamicObject caltask : caltasks) {
                if (caltask.getLong("fbasedataid_id") == 0L || payRollGroupByCalTaskIdMap.get(caltask.getLong("fbasedataid_id")) == null) continue;
                payRollGroups.add((Long)payRollGroupByCalTaskIdMap.get(caltask.getLong("fbasedataid_id")));
            }
            if (payRollGroups.size() <= 0) continue;
            HSASCalApproveBillHelper.setPayRollGroups((DynamicObject)approveBill, payRollGroups);
            updateApproveBills.add(approveBill);
        }
        if (updateApproveBills.size() > 0) {
            swcDataServiceHelper = new SWCDataServiceHelper("hsas_approvebill");
            swcDataServiceHelper.update(updateApproveBills.toArray(new DynamicObject[0]));
            LOGGER.info("ApproveBillPrgpUpdateTask is success ,upgrades nums is {}", (Object)approveBills.length);
        }
        this.disableTask();
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

