/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.DataStatusEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class ApproveBillTplToBuUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ApproveBillTplToBuUpdateTask.class);
    public static final String ORG = "org";
    public static final String CREATE_ORG_ID = "createorg.id";
    public static final String USE_ORG = "useorg";
    public static final String VERSION_SOURCE = "versionsource";
    private static final Long FLAG_OF_NO_BU = -1L;
    private static final long ORG_VIEW_TYPE_SALARY = 29L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter filter = new QFilter(CREATE_ORG_ID, "=", (Object)0L);
        filter.or(new QFilter(CREATE_ORG_ID, "is null", null));
        HRBaseServiceHelper calRuleHelper = new HRBaseServiceHelper("hsas_approvebilltpl");
        Object[] dyArr = calRuleHelper.query("id,boid,org,useorg,createorg,ctrlstrategy,versionsource,creator,issharescheme,iscurrentversion,datastatus,status", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])dyArr)) {
            this.disableTask();
            return;
        }
        List<Long> rootOrgId = Collections.singletonList(this.getRootOrgId());
        HashMap orgOfUsers = Maps.newHashMapWithExpectedSize((int)dyArr.length);
        HashMap topBuOfUser = Maps.newHashMapWithExpectedSize((int)dyArr.length);
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)dyArr.length);
        Map<Long, DynamicObject> dys = Arrays.stream(dyArr).collect(Collectors.toMap(ele -> ele.getLong("id"), ele -> ele));
        this.collectOrgIds(dys, rootOrgId, orgOfUsers, topBuOfUser);
        this.assignValuesFormMainTable(dys, topBuOfUser, updateList, rootOrgId.get(0));
        String querySql = "select fdataid from t_hsas_approvebilltpl_u";
        Set calRuleIdSet = (Set)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, (Object[])new Object[0], rs -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (rs.next()) {
                long id = rs.getLong(1);
                idSet.add(id);
            }
            return idSet;
        });
        String queryUseRegSql = "select fdataid from t_hsas_approvebilltplusereg";
        Set userRegCalRuleIdSet = (Set)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)queryUseRegSql, (Object[])new Object[0], rs -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (rs.next()) {
                long id = rs.getLong(1);
                idSet.add(id);
            }
            return idSet;
        });
        ArrayList<Object[]> saveUList = new ArrayList<Object[]>(dyArr.length);
        ArrayList<Object[]> saveUseRegList = new ArrayList<Object[]>(dyArr.length);
        this.assignValuesForUtable(dys, orgOfUsers, topBuOfUser, calRuleIdSet, userRegCalRuleIdSet, saveUList, saveUseRegList);
        try (TXHandle tx = TX.requiresNew();){
            if (!updateList.isEmpty()) {
                calRuleHelper.update(updateList.toArray(new DynamicObject[0]));
            }
            if (!saveUList.isEmpty()) {
                String insertSql = "insert into t_hsas_approvebilltpl_u(fdataid, fuseorgid) values(?,?)";
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, saveUList);
            }
            if (!saveUseRegList.isEmpty()) {
                String saveUserRegInsertSql = "insert into t_hsas_approvebilltplusereg(fdataid, fuseorgid, fcreateorgid, fctrlstrategy, fisassign, fadminorgid, fassignorgid) values(?,?,?,?,?,?,?)";
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)saveUserRegInsertSql, saveUseRegList);
            }
        }
        this.disableTask();
    }

    private void assignValuesForUtable(Map<Long, DynamicObject> dys, Map<Long, List<Long>> orgOfUsers, Map<Long, Long> topBuOfUser, Set<Long> calRuleIdSet, Set<Long> userRegCalRuleIdSet, List<Object[]> saveUList, List<Object[]> saveUseRegList) {
        for (Map.Entry<Long, DynamicObject> entry : dys.entrySet()) {
            DynamicObject dy = entry.getValue();
            Long createUserId = dy.getLong("creator.id");
            List<Long> orgList = orgOfUsers.get(createUserId);
            Long createOrgId = topBuOfUser.get(createUserId);
            if (CollectionUtils.isEmpty(orgList) || !dy.getBoolean("iscurrentversion")) continue;
            long dataId = dy.getLong("id");
            String ctrStrategy = dy.getString("ctrlstrategy");
            for (Long orgId : Sets.newHashSet(orgList)) {
                Long assignOrgId;
                boolean notAssign;
                boolean bl = notAssign = FLAG_OF_NO_BU.equals(createOrgId) || orgId.equals(createOrgId);
                if (!notAssign && !"C".equals(dy.getString("status"))) continue;
                if (!calRuleIdSet.contains(dataId)) {
                    Object[] saveObj = new Object[]{dataId, orgId};
                    saveUList.add(saveObj);
                }
                String isAssign = notAssign ? "0" : "1";
                long adminOrgId = notAssign ? 0L : createOrgId;
                Long l = assignOrgId = notAssign ? null : createOrgId;
                if (userRegCalRuleIdSet.contains(dataId)) continue;
                Object[] saveObj = new Object[]{dataId, orgId, createOrgId, ctrStrategy, isAssign, adminOrgId, assignOrgId};
                saveUseRegList.add(saveObj);
            }
        }
    }

    private void assignValuesFormMainTable(Map<Long, DynamicObject> dys, Map<Long, Long> topBuOfUser, List<DynamicObject> updateList, Long rootOrgId) {
        for (Map.Entry<Long, DynamicObject> entry : dys.entrySet()) {
            boolean hasNoBu;
            Long createOrdId;
            DynamicObject dy = entry.getValue();
            DynamicObject dyBo = dys.get(dy.getLong("boid"));
            dyBo = dyBo == null ? dy : dyBo;
            Long createOrdIdOri = topBuOfUser.get(dyBo.getLong("creator.id"));
            if (createOrdIdOri == null || createOrdIdOri == 0L) continue;
            if (StringUtils.isEmpty((String)dy.getString("datastatus"))) {
                dy.set("datastatus", (Object)DataStatusEnum.DELETE.getCode());
            }
            Long l = createOrdId = (hasNoBu = FLAG_OF_NO_BU.equals(createOrdIdOri)) ? rootOrgId : createOrdIdOri;
            if (dy.get("createorg") == null) {
                dy.set("createorg", (Object)createOrdId);
                if (hasNoBu || dyBo.getBoolean("issharescheme")) {
                    dy.set("ctrlstrategy", (Object)"5");
                } else {
                    dy.set("ctrlstrategy", (Object)"2");
                }
            }
            if (null == dy.get(ORG)) {
                dy.set(ORG, (Object)createOrdId);
            }
            if (null == dy.get(USE_ORG)) {
                dy.set(USE_ORG, (Object)createOrdId);
            }
            if (StringUtils.isEmpty((String)dy.getString(VERSION_SOURCE))) {
                dy.set(VERSION_SOURCE, (Object)EnumHisVersionSource.CHANGE.getType());
            }
            updateList.add(dy);
        }
    }

    private void collectOrgIds(Map<Long, DynamicObject> dys, List<Long> rootOrgId, Map<Long, List<Long>> orgOfUsers, Map<Long, Long> topBuOfUser) {
        for (Map.Entry<Long, DynamicObject> entry : dys.entrySet()) {
            DynamicObject dy = entry.getValue();
            long creatorId = dy.getLong("creator.id");
            if (orgOfUsers.containsKey(creatorId)) continue;
            if (SuperUserCache.isSuperUser((long)creatorId)) {
                orgOfUsers.put(creatorId, rootOrgId);
                topBuOfUser.put(creatorId, rootOrgId.get(0));
                continue;
            }
            HasPermOrgResult dimObjs = SWCPermissionServiceHelper.getPermOrgs((Long)creatorId, (String)"/UHMBBGZQ65X", (String)"hsas_approvebilltpl");
            LOGGER.info("By Quinn collectOrgIds 1: {}", (Object)dimObjs.hasAllOrgPerm());
            if (dimObjs.hasAllOrgPerm()) {
                orgOfUsers.put(creatorId, rootOrgId);
                topBuOfUser.put(creatorId, rootOrgId.get(0));
                continue;
            }
            List hasPermDimObjs = dimObjs.getHasPermOrgs();
            LOGGER.info("By Quinn collectOrgIds 2: {}", (Object)hasPermDimObjs);
            if (CollectionUtils.isEmpty((Collection)hasPermDimObjs)) {
                orgOfUsers.put(creatorId, rootOrgId);
                topBuOfUser.put(creatorId, FLAG_OF_NO_BU);
                continue;
            }
            LOGGER.info("By Quinn collectOrgIds 3: {}", (Object)hasPermDimObjs);
            orgOfUsers.put(creatorId, hasPermDimObjs);
            if (hasPermDimObjs.size() == 1) {
                topBuOfUser.put(creatorId, (Long)hasPermDimObjs.get(0));
                continue;
            }
            topBuOfUser.put(creatorId, this.matchTopBu(hasPermDimObjs));
        }
    }

    private Long matchTopBu(List<Long> orgIds) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgRangeList(orgIds);
        param.setOrgViewNumber("11");
        param.setTreeBuildType(OrgTreeBuildType.SKIP_HIDDEN_PARENT_ALL);
        param.setIncludeDisable(true);
        param.setIncludeFreeze(true);
        List nodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        return (Long)ObjectConverter.convert((Object)((TreeNode)nodes.get(0)).getId(), Long.class, (boolean)false);
    }

    private long getRootOrgId() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        Map map = orgService.getRootOrgId(Collections.singletonList(29L));
        return (Long)map.get(29L);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

