/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class BankOfferStatusUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(BankOfferStatusUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            DynamicObject[] query;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankofferrrec");
            String selectProperties = "id,reportstatus,entryentity.paydetail";
            QFilter filter = new QFilter("reportstatus", "=", (Object)BankOfferEnum.EXPORTING.getCode());
            filter.and(new QFilter("createtime", "<=", (Object)SWCDateTimeUtils.getBeforeDay((Date)new Date())));
            DynamicObject[] dynamicObjects = helper.query(selectProperties, new QFilter[]{filter});
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return;
            }
            HashSet<Long> payDetailSet = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("reportstatus", (Object)BankOfferEnum.EXPORTED.getCode());
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject paydetail : dynamicObjectCollection) {
                    payDetailSet.add(paydetail.getLong("paydetail.id"));
                }
            }
            helper.update(dynamicObjects);
            if (payDetailSet.isEmpty()) {
                return;
            }
            SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
            QFilter pFilter = new QFilter("bankofferstatus", "=", (Object)BankOfferEnum.EXPORTING.getCode());
            pFilter.and(new QFilter("id", "in", payDetailSet));
            for (DynamicObject dynamicObject : query = payDetailHelper.query("id,bankofferstatus,bankofferlog", new QFilter[]{pFilter})) {
                long bankOfferLogId = dynamicObject.getLong("bankofferlog.id");
                if (bankOfferLogId == 0L) {
                    dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.UNDEXPORT.getCode());
                    continue;
                }
                dynamicObject.set("bankofferstatus", (Object)BankOfferEnum.INVALIDED.getCode());
            }
            payDetailHelper.update(query);
        }
        catch (Exception e) {
            logger.error("update bankofferstatus failed!");
        }
    }
}

