/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class BizDataCalTaskRelTransTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataCalTaskRelTransTask.class);
    private static final int batchSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        Long startTime = System.currentTimeMillis();
        try {
            this.updateCalBizDataRel();
        }
        catch (Exception e) {
            logger.error("BizDataCalTaskRelTransTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        logger.info("BizDataCalTaskRelTransTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCalBizDataRel() {
        HashMap<Long, java.util.Date> calTaskInfoMap = new HashMap<Long, java.util.Date>(16);
        long beforeFid = 0L;
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("select top ").append(1000).append(" fid,fbizdataid,fcaltasknumber,fcalperiodid,fcalpersonid,fbizitemid,fcaltaskid,fcreatorid,fcreatetime,fmodifierid,fmodifytime from ").append("t_hsas_calbizdatarel").append(" where fisrecur = '0' and fid > ");
        int currentCount = 1;
        while (true) {
            QFilter filter;
            SWCDataServiceHelper helper;
            DynamicObjectCollection calTaskColl;
            logger.info("current page is:{}", (Object)currentCount);
            StringBuilder querysb = new StringBuilder();
            querysb.append((CharSequence)sbSql).append(beforeFid).append(" order by fid asc ");
            List<Map<String, Object>> queryList = this.queryData(querysb);
            HashSet<Long> calTaskIdSet = new HashSet<Long>(queryList.size());
            for (Map<String, Object> queryMap : queryList) {
                Long calTaskId = (Long)queryMap.get("fcaltaskid");
                if (calTaskInfoMap.get(calTaskId) != null) continue;
                calTaskIdSet.add(calTaskId);
            }
            if (calTaskIdSet.size() > 0 && (calTaskColl = (helper = new SWCDataServiceHelper("hsas_calpayrolltask")).queryOriginalCollection("id,payrolldate", new QFilter[]{filter = new QFilter("id", "in", calTaskIdSet)})) != null && calTaskColl.size() > 0) {
                for (DynamicObject dynamicObject : calTaskColl) {
                    calTaskInfoMap.put(dynamicObject.getLong("id"), dynamicObject.getDate("payrolldate"));
                }
            }
            try (TXHandle txHandle = TX.requiresNew();){
                if (queryList.size() > 0) {
                    this.insertCalBizData(queryList, calTaskInfoMap);
                    this.delCalBizData(queryList);
                }
            }
            if (queryList == null || queryList.size() <= 0 || queryList.size() < 1000) break;
            Map<String, Object> lastMap = queryList.get(queryList.size() - 1);
            beforeFid = (Long)lastMap.get("fid");
            ++currentCount;
        }
    }

    private void delCalBizData(List<Map<String, Object>> queryList) {
        String delSql = "delete from t_hsas_calbizdatarel where fid = ?";
        ArrayList<Object[]> delList = new ArrayList<Object[]>(queryList.size());
        for (Map<String, Object> map : queryList) {
            long fid = (Long)map.get("fid");
            Object[] obj = new Object[]{fid};
            delList.add(obj);
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)delSql, delList);
    }

    private void insertCalBizData(List<Map<String, Object>> queryList, Map<Long, java.util.Date> calTaskInfoMap) {
        String insertSql = "insert into t_hsas_calnonbizdatarel(fid,fbizdataid,fcaltasknumber,fcalperiodid,fcalpersonid,fbizitemid,fcaltaskid,fpayrolldate,fcreatorid,fcreatetime,fmodifierid,fmodifytime) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(queryList.size());
        for (Map<String, Object> map : queryList) {
            long fid = (Long)map.get("fid");
            long fbizdataid = (Long)map.get("fbizdataid");
            String fcaltasknumber = (String)map.get("fcaltasknumber");
            long fcalperiodid = (Long)map.get("fcalperiodid");
            long fcalpersonid = (Long)map.get("fcalpersonid");
            long fbizitemid = (Long)map.get("fbizitemid");
            long fcaltaskid = (Long)map.get("fcaltaskid");
            java.util.Date fpayrolldate = calTaskInfoMap.get(fcaltaskid);
            long fcreatorid = (Long)map.get("fcreatorid");
            java.util.Date fcreatetime = (java.util.Date)map.get("fcreatetime");
            long fmodifierid = (Long)map.get("fmodifierid");
            java.util.Date fmodifytime = (java.util.Date)map.get("fmodifytime");
            Object[] obj = new Object[]{fid, fbizdataid, fcaltasknumber, fcalperiodid, fcalpersonid, fbizitemid, fcaltaskid, fpayrolldate, fcreatorid, fcreatetime, fmodifierid, fmodifytime};
            insertList.add(obj);
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, insertList);
    }

    private List<Map<String, Object>> queryData(StringBuilder querysb) {
        List queryList = (List)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)querysb.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    long fid = rs.getLong(1);
                    long fbizdataid = rs.getLong(2);
                    String fcaltasknumber = rs.getString(3);
                    long fcalperiodid = rs.getLong(4);
                    long fcalpersonid = rs.getLong(5);
                    long fbizitemid = rs.getLong(6);
                    long fcaltaskid = rs.getLong(7);
                    long fcreatorid = rs.getLong(8);
                    Date fcreatetime = rs.getDate(9);
                    long fmodifierid = rs.getLong(10);
                    Date fmodifytime = rs.getDate(11);
                    HashMap<String, Object> retMap = new HashMap<String, Object>(15);
                    retMap.put("fid", fid);
                    retMap.put("fbizdataid", fbizdataid);
                    retMap.put("fcaltasknumber", fcaltasknumber);
                    retMap.put("fcalperiodid", fcalperiodid);
                    retMap.put("fcalpersonid", fcalpersonid);
                    retMap.put("fbizitemid", fbizitemid);
                    retMap.put("fcaltaskid", fcaltaskid);
                    retMap.put("fcreatorid", fcreatorid);
                    retMap.put("fcreatetime", fcreatetime);
                    retMap.put("fmodifierid", fmodifierid);
                    retMap.put("fmodifytime", fmodifytime);
                    retList.add(retMap);
                }
                return retList;
            }
        });
        return queryList;
    }
}

