/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class BizDataRecordUpgradeTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataRecordUpgradeTask.class);
    private static final String BIZDATA_RECORED_USAGECOUNT = "bizdatarecord_usagecountupdate_hsas";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("BizDataRecordUpgradeTask start");
        this.dealBizDataRecordData();
        this.disableTask();
        logger.info("BizDataRecordUpgradeTask end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dealBizDataRecordData() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_upgraderecord");
        QFilter qFilter = new QFilter("number", "=", (Object)BIZDATA_RECORED_USAGECOUNT);
        DynamicObject upgradeData = helper.queryOne("id,lastdataid,upgradetime,issuccess", new QFilter[]{qFilter});
        long lastFid = 0L;
        Date endDate = null;
        if (upgradeData != null) {
            lastFid = upgradeData.getLong("lastdataid");
            endDate = upgradeData.getDate("upgradetime");
        }
        boolean isSuccess = true;
        try {
            while (true) {
                StringBuilder querySql = new StringBuilder();
                querySql.append("select top 1000 fid,fbsed from t_hsas_bizdatarecord where fid > ");
                querySql.append(lastFid);
                Object[] paramArr = new Object[]{};
                if (endDate != null) {
                    querySql.append("  and fcreatetime <= ? ");
                    paramArr = new Object[]{endDate};
                }
                querySql.append("  order by fid asc ");
                HashSet<Date> bsedSet = new HashSet<Date>(16);
                logger.info("querySql : {}", (Object)querySql.toString());
                List<Long> bizDateRecordIdList = this.queryData(querySql, bsedSet, paramArr);
                if (bizDateRecordIdList.size() == 0) {
                    logger.info("bizDateRecordIdList is empty");
                    return;
                }
                SWCDataServiceHelper nonDataService = new SWCDataServiceHelper("hsas_nonrecurbizdata");
                QFilter filter = new QFilter("bizdatarecord", "in", bizDateRecordIdList);
                filter.and("bsed", "in", bsedSet);
                DynamicObjectCollection nonBizDataColl = nonDataService.queryOriginalCollection("id,usagecount,bizdatarecord", new QFilter[]{filter});
                HashMap<Long, Integer> recordIdAndUseCountMap = new HashMap<Long, Integer>(16);
                for (DynamicObject obj : nonBizDataColl) {
                    Integer existUseCount = (Integer)recordIdAndUseCountMap.get(obj.getLong("bizdatarecord"));
                    if (existUseCount == null) {
                        existUseCount = 0;
                    }
                    existUseCount = existUseCount + obj.getInt("usagecount");
                    recordIdAndUseCountMap.put(obj.getLong("bizdatarecord"), existUseCount);
                }
                this.updateBizDataCount(recordIdAndUseCountMap);
                lastFid = bizDateRecordIdList.get(bizDateRecordIdList.size() - 1);
                continue;
                break;
            }
        }
        catch (Exception ex) {
            logger.error("dealBizDataRecordData error", (Throwable)ex);
            isSuccess = false;
            return;
        }
        finally {
            if (upgradeData == null) {
                upgradeData = helper.generateEmptyDynamicObject();
                upgradeData.set("number", (Object)BIZDATA_RECORED_USAGECOUNT);
                upgradeData.set("upgradetime", (Object)new Date());
                upgradeData.set("issuccess", (Object)isSuccess);
                upgradeData.set("lastdataid", (Object)lastFid);
            } else {
                upgradeData.set("issuccess", (Object)isSuccess);
                upgradeData.set("lastdataid", (Object)lastFid);
            }
            helper.saveOne(upgradeData);
        }
    }

    private void updateBizDataCount(Map<Long, Integer> recordIdAndUseCountMap) throws Exception {
        String updateSql = " update t_hsas_bizdatarecord set fusagecount = ? , fmodifytime = ?  where fid = ? ";
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(recordIdAndUseCountMap.size());
        Date modifyTime = new Date();
        for (Map.Entry<Long, Integer> entry : recordIdAndUseCountMap.entrySet()) {
            Object[] param = new Object[]{entry.getValue(), modifyTime, entry.getKey()};
            updateParamList.add(param);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, updateParamList);
        }
    }

    private List<Long> queryData(StringBuilder querysb, final Set<Date> bsedSet, Object[] paramArr) {
        List queryList = (List)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)querysb.toString(), (Object[])paramArr, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> retList = new ArrayList<Long>(1000);
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    retList.add(fid);
                    bsedSet.add(rs.getDate("fbsed"));
                }
                return retList;
            }
        });
        return queryList;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

