/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsas.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections4.MapUtils;

public class BizDataSyncTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataSyncTask.class);
    private static final String FIELD_BIZDATASTATUS = "1";
    private static final String FIELD_EXPIRYDATE = "2";
    private static final String TASK_RECUR_BIZDATA_SYNC_HPDI = "recur_bizdata_sync_hpdi";
    private static final String TASK_NONRECUR_BIZDATA_SYNC_HPDI = "nonrecur_bizdata_sync_hpdi";
    private static final String recurSqlStr = "select fid, fidentifynumber, fbizitemid, fsalaryfileid, fbsled, fauditstatus from t_hsas_recurbizdata where fid > ? and fdatasources = '3' order by fid asc";
    private static final String nonRecurSqlStr = "select fid, fidentifynumber, fbizdatarecordid, fbizitemid, fsalaryfileid, fauditstatus from t_hsas_nonrecurbizdata where fid > ? and fdatasources = '3' and fauditstatus = 'F' order by fid asc";
    private static final String SELECT_FIELDS = "id, bizdatacode, bizdatastatus, expirydate, empposorgrel, empposorgrel.adminorg, bizitemgroup, bizdatadim, billtype";
    private static final String ALGO_KEY = "BizDataSyncTask.queryBizDataSQl";
    private static final int BATCH_SIZE = 5000;
    private int queryCount = 0;
    private SWCDataServiceHelper upgradeHelper = new SWCDataServiceHelper("hsas_upgraderecord");
    private SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hpdi_bizdata");
    private SWCDataServiceHelper bizDataRecordHelper = new SWCDataServiceHelper("hpdi_bizdatarecord");
    private SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hpdi_bizdataoperatelog");
    private SWCDataServiceHelper hisHelper = new SWCDataServiceHelper("hpdi_bizdataoperatehis");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long startTime = System.currentTimeMillis();
        logger.info("... BizDataSyncTask start execution!");
        this.bizDataUpgrade(true);
        logger.info("RecurBizData upgrade finish!");
        this.bizDataUpgrade(false);
        logger.info("NonRecurBizData upgrade finish!");
        this.disableTask();
        logger.info("... BizDataSyncTask execute finish, total time spen:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void bizDataUpgrade(boolean isCycle) {
        String upgradeNum = isCycle ? TASK_RECUR_BIZDATA_SYNC_HPDI : TASK_NONRECUR_BIZDATA_SYNC_HPDI;
        ArrayList<Map<String, Object>> waitDealList = new ArrayList<Map<String, Object>>(5000);
        QFilter filter = new QFilter("number", "=", (Object)upgradeNum);
        DynamicObject upgradeRecord = this.upgradeHelper.queryOne("id, number, issuccess, lastdataid, upgradetime", new QFilter[]{filter});
        if (!SWCObjectUtils.isEmpty((Object)upgradeRecord) && upgradeRecord.getBoolean("issuccess")) {
            logger.info("BizData had been upgrade! Upgrade number: {}", (Object)upgradeNum);
            return;
        }
        Long lastDataId = SWCObjectUtils.isEmpty((Object)upgradeRecord) ? 0L : upgradeRecord.getLong("lastdataid");
        String sql = isCycle ? recurSqlStr : nonRecurSqlStr;
        try (DataSet dataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[]{lastDataId});){
            while (dataSet.hasNext()) {
                if (waitDealList.size() < 5000) {
                    Row row = dataSet.next();
                    HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
                    rowMap.put("fid", row.getLong("fid"));
                    rowMap.put("fidentifynumber", row.getString("fidentifynumber"));
                    rowMap.put("fbizitemid", row.getLong("fbizitemid"));
                    rowMap.put("fsalaryfileid", row.getLong("fsalaryfileid"));
                    rowMap.put("fauditstatus", row.getString("fauditstatus"));
                    if (isCycle) {
                        rowMap.put("fbsled", row.getDate("fbsled"));
                    } else {
                        rowMap.put("fbizdatarecordid", row.getLong("fbizdatarecordid"));
                    }
                    waitDealList.add(rowMap);
                    continue;
                }
                lastDataId = MapUtils.getLong((Map)((Map)waitDealList.get(waitDealList.size() - 1)), (Object)"fid");
                this.validateAndSaveBizData(isCycle, waitDealList);
                if (this.queryCount < 1000) continue;
                this.saveUpgradeRecord(upgradeRecord, upgradeNum, Boolean.FALSE, lastDataId);
                this.queryCount = 0;
                dataSet.close();
                dataSet = this.getDbConnecton(sql, lastDataId);
            }
            if (!CollectionUtils.isEmpty(waitDealList)) {
                lastDataId = MapUtils.getLong((Map)((Map)waitDealList.get(waitDealList.size() - 1)), (Object)"fid");
            }
            this.validateAndSaveBizData(isCycle, waitDealList);
            this.queryCount = 0;
            this.saveUpgradeRecord(upgradeRecord, upgradeNum, Boolean.TRUE, lastDataId);
        }
    }

    private DataSet getDbConnecton(String sql, Long lastDataId) {
        DataSet dataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[]{lastDataId});
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAndSaveBizData(boolean isCycle, List<Map<String, Object>> waitDealList) {
        if (CollectionUtils.isEmpty(waitDealList)) {
            return;
        }
        ArrayList<DynamicObject> operateLogs = new ArrayList<DynamicObject>(waitDealList.size());
        ArrayList<DynamicObject> operateHiss = new ArrayList<DynamicObject>(waitDealList.size());
        HashSet<String> bizDataCodes = new HashSet<String>(waitDealList.size());
        HashSet<String> hBizDataCodes = new HashSet<String>(16);
        HashMap<String, Map<String, Object>> rowMap = new HashMap<String, Map<String, Object>>(waitDealList.size());
        for (Map<String, Object> row : waitDealList) {
            String bizDataCode = MapUtils.getString(row, (Object)"fidentifynumber");
            bizDataCodes.add(bizDataCode);
            Long bizDataRecordId = MapUtils.getLong(row, (Object)"fbizdatarecordid");
            if (!isCycle && bizDataRecordId != null && bizDataRecordId > 0L) {
                hBizDataCodes.add(bizDataCode);
            }
            rowMap.putIfAbsent(bizDataCode, row);
        }
        QFilter filter1 = new QFilter("bizdatacode", "in", bizDataCodes);
        DynamicObject[] bizDataArr = this.bizDataHelper.query(SELECT_FIELDS, new QFilter[]{filter1});
        Map<Object, Object> hMap = new HashMap(16);
        Object[] bizDataRecordArr = null;
        if (!isCycle && !CollectionUtils.isEmpty(hBizDataCodes)) {
            QFilter filter2 = new QFilter("bizdatacode", "in", hBizDataCodes);
            bizDataRecordArr = this.bizDataRecordHelper.query(SELECT_FIELDS, new QFilter[]{filter2});
            hMap = Arrays.stream(bizDataRecordArr).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), dy -> dy, (k1, k2) -> k1));
        }
        QFilter bizDataCodeFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        QFilter opTypeFilter = new QFilter("operatetype", "=", (Object)BizDataOperateEnum.OPERATE_UPGRADE.getCode());
        DynamicObject[] operateLogsInDB = this.logHelper.query("bizdatacode, updatefield", new QFilter[]{bizDataCodeFilter, opTypeFilter});
        HashSet<String> existsStatusCodes = new HashSet<String>(waitDealList.size());
        HashSet<String> existsExpiryDateCodes = new HashSet<String>(waitDealList.size());
        for (DynamicObject log : operateLogsInDB) {
            if (FIELD_BIZDATASTATUS.equals(log.getString("updatefield"))) {
                existsStatusCodes.add(log.getString("bizdatacode"));
                continue;
            }
            if (!FIELD_EXPIRYDATE.equals(log.getString("updatefield"))) continue;
            existsExpiryDateCodes.add(log.getString("bizdatacode"));
        }
        for (DynamicObject dy2 : bizDataArr) {
            Date bsled;
            String bizDataCode = dy2.getString("bizdatacode");
            Map row = (Map)rowMap.get(bizDataCode);
            if (null == row) continue;
            if ("F".equals(MapUtils.getString((Map)row, (Object)"fauditstatus")) && !BizDataStatusEnum.DISABLED.getCode().equals(dy2.getString("bizdatastatus")) && !"8".equals(dy2.getString("bizdatastatus"))) {
                boolean isHorizontal;
                DynamicObject bizDataRecord = (DynamicObject)hMap.get(bizDataCode);
                boolean bl = isHorizontal = !SWCObjectUtils.isEmpty((Object)bizDataRecord);
                if (existsStatusCodes.add(bizDataCode)) {
                    operateLogs.add(this.initBizDataOperateLog(row, dy2, FIELD_BIZDATASTATUS, isHorizontal));
                }
                dy2.set("bizdatastatus", (Object)"8");
                if (isHorizontal) {
                    bizDataRecord.set("bizdatastatus", (Object)"8");
                }
            }
            if (!isCycle || !FIELD_BIZDATASTATUS.equals(dy2.getString("billtype"))) continue;
            Date date = bsled = null == row.get("fbsled") ? null : (Date)row.get("fbsled");
            if (SWCDateTimeUtils.dayEqualsWithoutTime((Date)bsled, (Date)dy2.getDate("expirydate")) || !existsExpiryDateCodes.add(bizDataCode)) continue;
            operateLogs.add(this.initBizDataOperateLog(row, dy2, FIELD_EXPIRYDATE, false));
            operateHiss.add(this.initBizDataOperateHis(row, dy2));
            dy2.set("expirydate", (Object)bsled);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.bizDataHelper.save(bizDataArr);
            if (!SWCArrayUtils.isEmpty((Object[])bizDataRecordArr)) {
                this.bizDataRecordHelper.save((DynamicObject[])bizDataRecordArr);
            }
            if (!CollectionUtils.isEmpty(operateLogs)) {
                this.logHelper.save(operateLogs.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(operateHiss)) {
                this.hisHelper.save(operateHiss.toArray(new DynamicObject[0]));
            }
            txHandle.commit();
        }
        waitDealList.clear();
        ++this.queryCount;
    }

    private void saveUpgradeRecord(DynamicObject upgradeRecord, String upgradeNum, Boolean isSuccess, Long lastDataId) {
        logger.info("... saveUpgradeRecord.lastDataId is: {}", (Object)lastDataId);
        if (SWCObjectUtils.isEmpty((Object)upgradeRecord)) {
            upgradeRecord = this.upgradeHelper.generateEmptyDynamicObject();
            upgradeRecord.set("number", (Object)upgradeNum);
        }
        upgradeRecord.set("issuccess", (Object)isSuccess);
        upgradeRecord.set("lastdataid", (Object)lastDataId);
        upgradeRecord.set("upgradetime", (Object)new Date());
        this.upgradeHelper.saveOne(upgradeRecord);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private DynamicObject initBizDataOperateLog(Map<String, Object> row, DynamicObject bizData, String updateField, boolean isHorizontal) {
        String modelType = isHorizontal ? FIELD_EXPIRYDATE : FIELD_BIZDATASTATUS;
        DynamicObject operateLog = this.logHelper.generateEmptyDynamicObject();
        operateLog.set("dataid", (Object)bizData.getLong("id"));
        operateLog.set("modeltype", (Object)modelType);
        operateLog.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateLog.set("salaryfile", (Object)MapUtils.getLong(row, (Object)"fsalaryfileid"));
        operateLog.set("adminorg", (Object)bizData.getDynamicObject("empposorgrel.adminorg"));
        operateLog.set("bizitemgroup", (Object)bizData.getDynamicObject("bizitemgroup"));
        operateLog.set("bizdatacode", (Object)MapUtils.getString(row, (Object)"fidentifynumber"));
        if (FIELD_BIZDATASTATUS.equals(modelType)) {
            operateLog.set("bizitem", (Object)MapUtils.getLong(row, (Object)"fbizitemid"));
        }
        operateLog.set("bizdatadim", (Object)bizData.getDynamicObject("bizdatadim"));
        operateLog.set("operatetype", (Object)BizDataOperateEnum.OPERATE_UPGRADE.getCode());
        operateLog.set("updatefield", (Object)updateField);
        String beforeUpdate = null;
        String afterUpdate = null;
        if (FIELD_BIZDATASTATUS.equals(updateField)) {
            beforeUpdate = BizDataStatusEnum.getDesc((String)bizData.getString("bizdatastatus"));
            afterUpdate = BizDataStatusEnum.HSAS_DISABLED.getDesc();
        } else if (FIELD_EXPIRYDATE.equals(updateField)) {
            beforeUpdate = null == bizData.getDate("expirydate") ? null : SWCDateTimeUtils.formatDate((Date)bizData.getDate("expirydate"));
            afterUpdate = null == row.get("fbsled") ? null : SWCDateTimeUtils.formatDate((Date)((Date)row.get("fbsled")));
        }
        operateLog.set("beforeupdate", (Object)beforeUpdate);
        operateLog.set("afterupdate", (Object)afterUpdate);
        operateLog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return operateLog;
    }

    private DynamicObject initBizDataOperateHis(Map<String, Object> row, DynamicObject bizData) {
        DynamicObject operateHis = this.hisHelper.generateEmptyDynamicObject();
        operateHis.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateHis.set("bizitem", (Object)MapUtils.getLong(row, (Object)"fbizitemid"));
        operateHis.set("currentbizdatacode", (Object)MapUtils.getString(row, (Object)"fidentifynumber"));
        operateHis.set("beforupdatedate", (Object)bizData.getDate("expirydate"));
        operateHis.set("afterupdatedate", row.get("fbsled"));
        operateHis.set("operatetype", (Object)BizDataOperateEnum.OPERATE_UPGRADE.getCode());
        operateHis.set("operater", (Object)RequestContext.get().getCurrUserId());
        operateHis.set("operatetime", (Object)new Date());
        operateHis.set("bizdata", (Object)bizData.getLong("id"));
        return operateHis;
    }
}

