/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class BizDataTabUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataTabUpdateTask.class);
    private static final int batchSize = 5000;
    private static final String tableName = "t_hsas_nonrecurbizdata";
    private static final String sql = "select fid, fsalaryfileid from t_hsas_nonrecurbizdata where forgid = 0 OR forgid is null";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updateBizData();
            }
        }
        catch (Exception e) {
            logger.error("BizDataTabUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        logger.info("BizDataTabUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updateBizData() {
        logger.info("start to deal bizdata \uff1a{}", (Object)tableName);
        long startTimeMillis = System.currentTimeMillis();
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryBizDataSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryBizDataSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
            this.queryBatch = 0;
            logger.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashSet<Long> salaryFileSet = new HashSet<Long>(10);
        List bizDataIds = null;
        HashMap salaryFileToBizDataMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            Long salaryFileId = row.getLong("fsalaryfileid");
            salaryFileSet.add(salaryFileId);
            bizDataIds = salaryFileToBizDataMap.getOrDefault(salaryFileId, new ArrayList());
            bizDataIds.add(id);
            salaryFileToBizDataMap.put(salaryFileId, bizDataIds);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        long endTimeMillis = System.currentTimeMillis();
        logger.info(" execute query bizdata used : {}", (Object)(endTimeMillis - startTimeMillis));
        logger.info(" salaryFileToBizDataMap is : {}", (Object)((Object)salaryFileToBizDataMap).toString());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProperties = "id, org.id, payrollregion.id, payrollgroup.id, adminorg.id, empgroup.id ";
        DynamicObject[] salaryFileColl = helper.queryOriginalArray(selectProperties, new QFilter[]{new QFilter("id", "in", salaryFileSet)});
        HashMap<Long, DynamicObject> salaryFileIdToObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject salaryFile : salaryFileColl) {
            salaryFileIdToObjMap.put(salaryFile.getLong("id"), salaryFile);
        }
        long queryFileEndTime = System.currentTimeMillis();
        logger.info(" execute query salaryFile used : {}", (Object)(queryFileEndTime - endTimeMillis));
        this.updateBizDataOfSalaryFile(tableName, salaryFileIdToObjMap, salaryFileToBizDataMap);
        logger.info(" execute update bizdata used : {}", (Object)(System.currentTimeMillis() - queryFileEndTime));
        return true;
    }

    private void updateBizDataOfSalaryFile(String tableName, Map<Long, DynamicObject> salaryFileIdToObjMap, Map<Long, List<Long>> salaryFileToBizDataMap) {
        String updateSql = "update " + tableName + " set forgid = ?, fpayrollregionid = ?, fpayrollgroupid = ?, fadminorgid = ?, fempgroupid = ? where fid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        if (salaryFileIdToObjMap != null && salaryFileIdToObjMap.size() > 0) {
            logger.info("salaryFileIdToObjMap size\uff1a{}", (Object)salaryFileIdToObjMap.size());
            for (Map.Entry<Long, DynamicObject> entry : salaryFileIdToObjMap.entrySet()) {
                Long id = entry.getKey();
                DynamicObject salaryFile = entry.getValue();
                Long orgId = salaryFile.getLong("org.id");
                Long payrollRegionId = salaryFile.getLong("payrollregion.id");
                Long payrollGroupId = salaryFile.getLong("payrollgroup.id");
                Long adminOrgId = salaryFile.getLong("adminorg.id");
                Long empGroupId = salaryFile.getLong("empgroup.id");
                List<Long> bizDataIds = salaryFileToBizDataMap.get(id);
                for (Long bizDataId : bizDataIds) {
                    Object[] obj = new Object[]{orgId, payrollRegionId, payrollGroupId, adminOrgId, empGroupId, bizDataId};
                    updateList.add(obj);
                }
            }
        } else {
            logger.info("salaryFileIdToObjMap is empty!");
            for (Map.Entry<Long, List<Long>> entry : salaryFileToBizDataMap.entrySet()) {
                List<Long> bizDataIds = entry.getValue();
                for (Long bizDataId : bizDataIds) {
                    Object[] obj = new Object[]{-1L, -1L, -1L, -1L, -1L, bizDataId};
                    updateList.add(obj);
                }
            }
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, updateList);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

