/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.cal.helper.CalTaskNewTplMsgHelper;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsas.common.enums.AfterCalEnum;
import kd.swc.hsas.common.utils.MD5Utils;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.schedule.SwcBizAbstractTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalTaskNewSheduleTask
extends SwcBizAbstractTask {
    public static final String PRORATION_CAL = "prorationCal";
    private static Log logger = LogFactory.getLog(CalTaskNewSheduleTask.class);
    private static final String KEY_LOG_NUMBER = "tplnumber";
    private static final String KEY_LOG_NAME = "caltasknewtpl";
    private static final String KEY_LOG_TPL_CALL_STATE = "tplcallstatus";
    private static final String KEY_LOG_TPL_CALL_STATE_SUCCESS = "1";
    private static final String KEY_LOG_TPL_CALL_STATE_FAIL = "0";
    private static final String KEY_LOG_TPL_CALL_DETAIL = "tplcalldetail";
    private static final String KEY_LOG_CALL_PERIOD = "callperiod";
    private static final String KEY_LOG_EXCUTE_TYPE = "excutetype";
    private static final String LOG_EXCUTE_TYPE_SYS = "A";
    private static final String LOG_EXCUTE_TYPE_MANUAL = "B";
    private static final String KEY_LOG_EXCUTOR = "executor";
    private static final String KEY_LOG_START_TIME = "starttime";
    private static final String KEY_LOG_END_TIME = "endtime";
    private static final String IS_INFO_MATCH = "isMatch";
    private static final String CAL_LIST_VIEW_ID = "calListViewId";
    private static final String KEY_EXPSCENE = "expscene";
    private static final String KEY_NOTIFYOBJ = "notifyobj";
    private static final String KEY_SUCCESSNOTIFYOBJ = "successnotifyobj";
    private static final String OPTION_NOT_NOTIFY = "1";
    private static final String OPTION_ONLY_TPL_CHARGE_PERSON = "2";
    private static final String OPTION_ONLY_TASK_TRACKER = "3";
    private static final String OPTION_BOTH_TWO = "4";
    private static final String CAL_TASK_TPL_ID_LOST = "cal_task_tpl_id_lost";
    private static final String CAL_TASK_DISABLE = "cal_task_disable";
    private static final String NO_CAL_TASK_TPLV = "no_cal_task_tplv";
    private static final String TPLV_DATASTATUS_ERROR = "tplv_datastatus_error";
    private static final String GRPV_DATASTATUS_ERROR = "grpv_datastatus_error";
    private static final String GRPV_DISABLE = "grpv_disable";
    private static final String NO_PAYROLLSCENE = "no_payrollscene";
    private static final String SCENE_NOT_MATCH = "scene_not_match";
    private static final String SCENEV_DATASTATUS_ERROR = "scenev_datastatus_error";
    private static final String SCENEV_DISABLE = "scenev_disable";
    private static final String NO_PERIODTYPE = "no_periodtype";
    private static final String PERIODTYPE_DATASTATUS_ERROR = "periodtype_datastatus_error";
    private static final String NO_PERIOD = "no_period";
    private static final String NO_CALRULEV = "no_calrulev";
    private static final String CALRULE_DISABLE = "calrule_disable";
    private static final String CALRULE_NO_ACTUAL_PROJ = "calrule_no_actual_proj";
    private static final String PERSON_RULE_DATASTATUS_ERROR = "person_rule_datastatus_error";
    private static final String NO_PERSON_RULEV = "no_person_rulev";
    private static final String CAL_LIST_VIEW_DISABLE = "cal_list_view_disable";
    private static final String NO_CAL_LIST_VIEWV = "no_cal_list_viewv";
    private static final String CALL_ADD_PERSON_SERVICE_FAIL = "call_add_person_service_fail";
    private static final String ADD_PERSON_SUCCESS_SYNC = "add_person_success_sync";
    private static final String NUMBER_RULE_DISABLE = "number_rule_disable";
    private static final Supplier<String> msgTitle = () -> ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u521b\u5efa\u5931\u8d25", (String)"CalTaskNewSheduleTask_0", (String)"swc-hsas-business", (Object[])new Object[0]);
    private static final Supplier<String> msgTag = () -> ResManager.loadKDString((String)"\u901a\u77e5", (String)"CalTaskNewSheduleTask_1", (String)"swc-hsas-business", (Object[])new Object[0]);
    private SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hsas_caltasknewlog");

    protected QFilter buildBizQFilter(RequestContext requestContext, Map<String, Object> map, long schCfgId) {
        QFilter qFilter = new QFilter("schconfig", "=", (Object)schCfgId);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("datastatus", "=", (Object)"1");
        return qFilter;
    }

    public void executeBiz(RequestContext requestContext, Map<String, Object> map, Object bizObjId) {
        if (bizObjId != null) {
            this.doCoreBizWork(requestContext, map, Long.parseLong(String.valueOf(bizObjId)));
        } else {
            logger.error("bizObjId is null...");
        }
    }

    private void doCoreBizWork(RequestContext requestContext, Map<String, Object> map, long calTaskTplId) {
        Date startTime = new Date(System.currentTimeMillis());
        DynamicObject tplV = this.getTplV(this.getTplBoId(calTaskTplId));
        if (tplV == null) {
            DynamicObject logDyObj = this.fillLogInfo(null, 0L, KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_CAL_TASK_TPLV, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            logger.error("calTaskTpl's history-data not exist!");
            return;
        }
        if (!"1".equals(tplV.getString("datastatus"))) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(TPLV_DATASTATUS_ERROR, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u672a\u627e\u5230\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u751f\u6548\u65e5\u671f\u5c0f\u4e8e\u7b49\u4e8e\u8c03\u5ea6\u65e5\u671f\u7684\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_19", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_TASKTPLCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        long grpId = tplV.getLong("payrollgrp.id");
        DynamicObject grpvDy = this.queryGrpv(grpId);
        boolean isObjDisable = false;
        if (grpvDy == null || (isObjDisable = !this.isObjEnable(grpId, "hsas_payrollgrp"))) {
            DynamicObject logDyObj = isObjDisable ? this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(GRPV_DISABLE, startTime), startTime, requestContext, 0L) : this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(GRPV_DATASTATUS_ERROR, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u672a\u627e\u5230\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_38", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_PAYROLLGROUPCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            logger.error("payrollGrp's effect history-data is not exist!");
            return;
        }
        DynamicObject payrollSceneDy = tplV.getDynamicObject("payrollscene");
        if (payrollSceneDy == null) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_PAYROLLSCENE, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            logger.error("payrollSceneDy's data is not exist!");
            return;
        }
        Map<String, Object> result = this.isPayrollSceneMatch(payrollSceneDy, grpvDy);
        if (!((Boolean)result.get(IS_INFO_MATCH)).booleanValue()) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(SCENE_NOT_MATCH, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u8c03\u7528\u7684\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u4e0e\u5176\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u4e0a\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"CalTaskNewSheduleTask_20", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_TASKTPLCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        long payrollSceneId = payrollSceneDy.getLong("id");
        DynamicObject payrollScenevDy = this.queryPayrollSceneV(payrollSceneId);
        if (SWCObjectUtils.isEmpty((Object)payrollScenevDy) || (isObjDisable = !this.isObjEnable(payrollSceneId, "hsas_payrollscene"))) {
            DynamicObject logDyObj = isObjDisable ? this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(SCENEV_DISABLE, startTime), startTime, requestContext, 0L) : this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(SCENEV_DATASTATUS_ERROR, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            logger.error("payrollSceneDy's effect history-data is not exist!");
            String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u672a\u627e\u5230\u85aa\u8d44\u6838\u7b97\u573a\u666f\u7684\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_21", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_PAYROLLSCENECALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        DynamicObject periodTypeDy = new SWCDataServiceHelper("hsbs_calperiodtype").queryOne("status, enable, entryentity, periodname, enddate, startdate, ratedate, paydate, periodyear, perioddate, calfrequency.id", (Object)payrollScenevDy.getLong("periodtype.id"));
        if (periodTypeDy == null) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_PERIODTYPE, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            logger.error("periodTypeDy's data is not exist!");
            return;
        }
        if (!"C".equals(periodTypeDy.getString("status")) || !"1".equals(periodTypeDy.getString("enable"))) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(PERIODTYPE_DATASTATUS_ERROR, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u8c03\u7528\u7684\u671f\u95f4\u7c7b\u578b\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u201c\u53ef\u7528\u201d\u3002", (String)"CalTaskNewSheduleTask_22", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_CALPERIODCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        Date periodDate = this.getPeriodDate(tplV);
        logger.info("\u751f\u6210\u6240\u5c5e\u671f\u95f4\u65e5\u671f\uff1a{}", (Object)SerializationUtils.toJsonString((Object)periodDate));
        DynamicObject periodDy = this.getPeriod(periodTypeDy, periodDate);
        if (periodDy == null) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_PERIOD, startTime), startTime, requestContext, 0L);
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u8c03\u7528\u7684\u671f\u95f4\u7c7b\u578b\u4e0b\u4e0d\u5b58\u5728\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u8986\u76d6\u6a21\u677f\u4e0a\u7684\u201c\u751f\u6210\u6240\u5c5e\u671f\u95f4\u65e5\u671f\u201d\u7684\u671f\u95f4\u3002", (String)"CalTaskNewSheduleTask_23", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_CALPERIODCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        long calListViewId = (Long)result.get(CAL_LIST_VIEW_ID);
        Date endDate = periodDy.getDate("enddate");
        DynamicObject[] calRuleVs = this.queryCalRulevDys(payrollScenevDy, endDate);
        if (calRuleVs.length <= 0 || (isObjDisable = !this.isObjEnable(payrollScenevDy.getLong("calrule.id"), "hsas_calrule"))) {
            DynamicObject logDyObj = isObjDisable ? this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(CALRULE_DISABLE, endDate), startTime, requestContext, periodDy.getLong("id")) : this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_CALRULEV, endDate), startTime, requestContext, periodDy.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            String reasonStr = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u201c%s\u201d\u524d\u4e0d\u5b58\u5728\u6709\u6548\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_24", (String)"swc-hsas-business", (Object[])new Object[0]), HRInteDateTimeUtil.formatDate((String)"hsbs_calperiodtype", (String)"enddate", (Date)endDate));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_TASKNEWDATAFAIL, msgTitle.get(), reasonStr, msgTag.get());
            return;
        }
        if (this.isSceneContainPersonalpay(tplV, calRuleVs[0], periodDy, payrollScenevDy, startTime, requestContext)) {
            return;
        }
        DynamicObject calPersonAddCfg = payrollScenevDy.getDynamicObject("callistrule");
        if (!SWCObjectUtils.isEmpty((Object)calPersonAddCfg)) {
            if (!this.isCalPersonRuleEnable(calPersonAddCfg.getLong("id"))) {
                DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(PERSON_RULE_DATASTATUS_ERROR, startTime), startTime, requestContext, periodDy.getLong("id"));
                this.logHelper.saveOne(logDyObj);
                String reasonStrMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a%s\uff0c\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u7684\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"CalTaskNewSheduleTask_27", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
                this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_CALPERSONRULECALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
                return;
            }
            DynamicObject personRulevDy = this.queryPersonRulev(calPersonAddCfg.getLong("id"), periodDy.getDate("enddate"));
            if (personRulevDy == null) {
                DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_PERSON_RULEV, endDate), startTime, requestContext, periodDy.getLong("id"));
                this.logHelper.saveOne(logDyObj);
                String reasonStrMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a{0}\uff0c\u5728\u8c03\u7528\u7684\u671f\u95f4\u7ed3\u675f\u65e5\u671f{1}\u524d\uff0c\u6240\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_28", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"), HRInteDateTimeUtil.formatDate((String)"hsbs_calperiodtype", (String)"enddate", (Date)endDate));
                this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_CALPERSONRULECALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
                return;
            }
        }
        if (calListViewId == 0L) {
            calListViewId = payrollScenevDy.getLong("callistview.id");
        }
        if (!this.isCalListViewEnable(calListViewId)) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(CAL_LIST_VIEW_DISABLE, endDate), startTime, requestContext, periodDy.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a{0}\uff0c\u6240\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u201c\u53ef\u7528\u3002", (String)"CalTaskNewSheduleTask_26", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_CALLISTVIEWCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        Long calListViewVId = this.queryCalListViewVId(calListViewId);
        if (calListViewVId == null) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NO_CAL_LIST_VIEWV, endDate), startTime, requestContext, periodDy.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            String reasonStrMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7f16\u7801\uff1a{0}\uff0c\u6240\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_37", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"));
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_CALLISTVIEWCALLFAIL, msgTitle.get(), reasonStrMsg, msgTag.get());
            return;
        }
        String prorationCal = (String)result.get(PRORATION_CAL);
        Map<String, Object> calTaskMap = this.createCalTask(tplV, grpvDy, payrollSceneDy, payrollScenevDy, periodTypeDy, periodDy, calRuleVs[0], requestContext, calListViewVId, prorationCal);
        if (!calTaskMap.isEmpty()) {
            this.addPersonToTask(calTaskMap, tplV, periodDy, startTime, requestContext);
        }
    }

    private long getTplBoId(Long calTaskId) {
        SWCDataServiceHelper tplHisHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        DynamicObject dynamicObject = tplHisHelper.queryOne("id,boid", (Object)calTaskId);
        if (dynamicObject != null) {
            return dynamicObject.getLong("boid");
        }
        return calTaskId;
    }

    @Nullable
    private DynamicObject getPeriod(DynamicObject periodTypeDy, Date periodDate) {
        DynamicObjectCollection periodEntry = periodTypeDy.getDynamicObjectCollection("entryentity");
        DynamicObject periodDy = null;
        periodDate = this.setDateWithNoHourMinSecMilli(periodDate);
        for (DynamicObject periodTempDy : periodEntry) {
            Date endDate = periodTempDy.getDate("enddate");
            Date startDate = periodTempDy.getDate("startdate");
            if (periodDate.compareTo(startDate) < 0 || periodDate.compareTo(endDate) > 0) continue;
            periodDy = periodTempDy;
            break;
        }
        return periodDy;
    }

    private Date setDateWithNoHourMinSecMilli(Date periodDate) {
        int year = SWCDateTimeUtils.getYear((Date)periodDate);
        int month = SWCDateTimeUtils.getMonth((Date)periodDate);
        int day = SWCDateTimeUtils.getDay((Date)periodDate);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @NotNull
    private Date getPeriodDate(DynamicObject tplV) {
        Date periodDate;
        String operation = tplV.getString("operation");
        long operationDays = Long.parseLong(tplV.getString("operationdays"));
        if (LOG_EXCUTE_TYPE_SYS.equals(operation)) {
            long nowTimeMil = System.currentTimeMillis();
            periodDate = new Date(nowTimeMil += operationDays * 24L * 60L * 60L * 1000L);
        } else {
            long nowTimeMil = System.currentTimeMillis();
            periodDate = new Date(nowTimeMil -= operationDays * 24L * 60L * 60L * 1000L);
        }
        return SWCDateTimeUtils.getDayDate((Date)periodDate);
    }

    private Map<String, Object> isPayrollSceneMatch(DynamicObject payrollSceneDy, DynamicObject grpvDy) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        DynamicObjectCollection dyColl = grpvDy.getDynamicObjectCollection("payrollsceneentry");
        boolean isMatch = false;
        long calListViewId = 0L;
        String prorationCal = null;
        for (DynamicObject dyObj : dyColl) {
            if (!SWCObjectUtils.equals((Object)payrollSceneDy, (Object)dyObj.getDynamicObject("payrollscene"))) continue;
            isMatch = true;
            calListViewId = dyObj.getLong("callistview.id");
            prorationCal = dyObj.getString("prorationcal");
            break;
        }
        result.put(IS_INFO_MATCH, isMatch);
        result.put(CAL_LIST_VIEW_ID, calListViewId);
        result.put(PRORATION_CAL, prorationCal);
        return result;
    }

    private Map<String, Object> createCalTask(DynamicObject tplV, DynamicObject grpv, DynamicObject payrollSceneDy, DynamicObject payrollScenevDy, DynamicObject periodTypeDy, DynamicObject periodDy, DynamicObject calRuleV, RequestContext requestContext, long calListViewVId, String prorationCal) {
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        int serialIndexName = 1;
        String nameMd5Prefix = "";
        HashMap<String, Object> calTaskMap = new HashMap<String, Object>(16);
        long calTaskId = ORM.create().genLongId("hsas_calpayrolltask");
        DynamicObject calTaskDy = (DynamicObject)type.createInstance();
        logger.info("createCalTask fillCalTaskDy start !");
        this.fillCalTaskDy(tplV, payrollSceneDy, payrollScenevDy, grpv, periodTypeDy, periodDy, calTaskDy, requestContext, calRuleV);
        logger.info("createCalTask fillCalTaskDy end !");
        String number = null;
        try {
            number = CodeRuleHelper.getNumber((DynamicObject)calTaskDy, null);
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            if (!SWCStringUtils.isEmpty((String)message)) {
                message = message.length() >= 255 ? message.substring(0, 250) : message;
            }
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, message, new Date(), requestContext, periodDy.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            return calTaskMap;
        }
        if (SWCStringUtils.isEmpty((String)number)) {
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(NUMBER_RULE_DISABLE, new Date()), new Date(), requestContext, periodDy.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            return calTaskMap;
        }
        calTaskDy.set("number", (Object)number);
        String name = this.getCalTaskName(tplV.getString("nameprefix"), tplV.getString("namebody"), tplV.getString("namesuffix"), periodDy.getString("periodname"), payrollScenevDy.getString("calrule.name"), tplV.getString("payrollgrp.name"), payrollScenevDy.getString("name"));
        try {
            nameMd5Prefix = MD5Utils.stringToMD5((String)name);
        }
        catch (Exception e) {
            nameMd5Prefix = "";
        }
        serialIndexName = CalPayrollTaskHelper.getSerialIndex(nameMd5Prefix);
        calTaskDy.set("name", (Object)(name + serialIndexName));
        calTaskDy.set("masterid", (Object)calTaskId);
        calTaskDy.set("id", (Object)calTaskId);
        calTaskDy.set("calcount", (Object)this.getCalCount(grpv.getLong("boid"), payrollScenevDy.getLong("boid"), periodDy.getLong("id")));
        calTaskDy.set("callistviewv", (Object)calListViewVId);
        calTaskDy.set("ishandleproration", (Object)prorationCal);
        String userId = requestContext.getUserId();
        if (!this.isSysExecute(userId)) {
            try {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                OperationResult tempOpResult = new OperationServiceImpl().localInvokeOperation("donothing_addbytpl", new DynamicObject[]{calTaskDy}, option);
                List messages = tempOpResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(messages)) {
                    String message = String.join((CharSequence)",", messages);
                    if (!SWCStringUtils.isEmpty((String)message)) {
                        message = message.length() >= 255 ? message.substring(0, 250) : message;
                    }
                    DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, message, new Date(), requestContext, periodDy.getLong("id"));
                    this.logHelper.saveOne(logDyObj);
                    return calTaskMap;
                }
            }
            catch (Exception ex) {
                logger.error("CalTaskNewSheduleTask.createCalTaskr, invoke donothing_addbytpl op error:", (Throwable)ex);
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            calTaskHelper.saveOne(calTaskDy);
            if (!SWCObjectUtils.isEmpty((Object)nameMd5Prefix)) {
                CalPayrollTaskHelper.saveSerialNumber(serialIndexName, nameMd5Prefix, "hsas_calpayrolltask");
            }
        }
        calTaskMap.put("name", name + serialIndexName);
        calTaskMap.put("number", number);
        calTaskMap.put("id", calTaskId);
        return calTaskMap;
    }

    private void fillCalTaskDy(DynamicObject tplV, DynamicObject payrollSceneDy, DynamicObject payrollScenevDy, DynamicObject grpv, DynamicObject periodTypeDy, DynamicObject period, DynamicObject calTask, RequestContext requestContext, DynamicObject calRulevDy) {
        DynamicObject calPeriodObj;
        calTask.set("simplename", (Object)"");
        calTask.set("calpersoncount", (Object)0);
        calTask.set("tasktype", (Object)tplV.getString("tasktype"));
        calTask.set("handlestate", (Object)KEY_LOG_TPL_CALL_STATE_FAIL);
        calTask.set("viewdetailfield", (Object)KEY_LOG_TPL_CALL_STATE_FAIL);
        calTask.set("country", (Object)grpv.getDynamicObject("country"));
        calTask.set("payrollscene", (Object)payrollSceneDy);
        calTask.set("payrollscenev", (Object)payrollScenevDy);
        calTask.set("payrollgroup", (Object)tplV.getDynamicObject("payrollgrp"));
        calTask.set("payrollgroupv", (Object)grpv);
        calTask.set("description", (Object)"");
        calTask.set("calrule", (Object)payrollScenevDy.getDynamicObject("calrule"));
        calTask.set("calfrequency", (Object)periodTypeDy.getDynamicObject("calfrequency"));
        calTask.set("periodtype", (Object)payrollScenevDy.getDynamicObject("periodtype"));
        calTask.set("period", (Object)period);
        calTask.set("islimitadd", (Object)Boolean.FALSE);
        if (SWCStringUtils.equals((String)tplV.getString("tasktype"), (String)"1")) {
            calTask.set("islimitadd", (Object)payrollScenevDy.getBoolean("islimitadd"));
        }
        calTask.set("STARTDATE", (Object)period.getDate("startdate"));
        calTask.set("ENDDATE", (Object)period.getDate("enddate"));
        calTask.set("exratedate", (Object)period.getDate("ratedate"));
        calTask.set("paydate", (Object)period.getDate("paydate"));
        calTask.set("payrollyear", (Object)SWCDateTimeUtils.getYear((Date)period.getDate("periodyear")));
        calTask.set("payrollmonth", (Object)SWCDateTimeUtils.getMonth((Date)period.getDate("perioddate")));
        calTask.set("payrolldate", (Object)period.getDate("perioddate"));
        calTask.set("calrulev", (Object)calRulevDy);
        calTask.set("calcount", (Object)1);
        calTask.set("org", (Object)grpv.getDynamicObject("org"));
        this.copyMulBaseDataField(tplV, calTask, "tracker");
        calTask.set("aftercal", (Object)payrollScenevDy.getString("aftercal"));
        String userId = requestContext.getUserId();
        calTask.set("tasknewmethod", (Object)OPTION_ONLY_TPL_CHARGE_PERSON);
        calTask.set("tasknewtplhis", tplV.getPkValue());
        calTask.set("taskstatus", (Object)CalPayrollTaskStateEnum.CREATE.getCode());
        calTask.set("createtime", (Object)new Date());
        calTask.set("creator", (Object)0L);
        calTask.set("modifytime", null);
        calTask.set("modifier", (Object)userId);
        calTask.set("status", (Object)LOG_EXCUTE_TYPE_SYS);
        calTask.set("disabler", (Object)0L);
        calTask.set("disabledate", null);
        calTask.set("enable", (Object)"1");
        calTask.set("index", (Object)0);
        calTask.set("issyspreset", (Object)KEY_LOG_TPL_CALL_STATE_FAIL);
        calTask.set("isautoaddperson", (Object)"1");
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        logger.info("isenableatt is : {}", (Object)payrollScenevDy.getBoolean("isenableatt"));
        if (payrollScenevDy.getBoolean("isenableatt") && !SWCObjectUtils.isEmpty((Object)(calPeriodObj = payRollTaskService.getAttDateRange(payrollScenevDy, period, payrollScenevDy.getDynamicObject("periodtype"))))) {
            calTask.set("ATTSTARTDATE", (Object)calPeriodObj.getDate("STARTDATE"));
            calTask.set("ATTENDDATE", (Object)calPeriodObj.getDate("ENDDATE"));
        }
    }

    private boolean isSceneContainPersonalpay(DynamicObject tplV, DynamicObject calRuleV, DynamicObject period, DynamicObject payrollScenevDy, Date startTime, RequestContext requestContext) {
        if (payrollScenevDy.getString("aftercal").contains(AfterCalEnum.PERSONALPAY.getCode())) {
            DynamicObjectCollection calRulevItemEntry = calRuleV.getDynamicObjectCollection("calruleitementry");
            for (DynamicObject itemEntry : calRulevItemEntry) {
                if (!itemEntry.getBoolean("ispayoutitem")) continue;
                return false;
            }
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(CALRULE_NO_ACTUAL_PROJ, startTime), startTime, requestContext, period.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            String reasonStr = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u5f0f\u4e3a\u201c\u4e2a\u4f53\u53d1\u653e\u201d\u4e14\u5f15\u7528\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e2d\u4e0d\u5b58\u5728\u5b9e\u53d1\u9879\u76ee\u3002", (String)"CalTaskNewSheduleTask_25", (String)"swc-hsas-business", (Object[])new Object[0]);
            this.sendMsg(tplV, CalTaskNewTplMsgHelper.MSG_SCENE_TASKNEWDATAFAIL, msgTitle.get(), reasonStr, msgTag.get());
            return true;
        }
        return false;
    }

    private boolean isObjEnable(Long objId, String entityName) {
        SWCDataServiceHelper grpHelper = new SWCDataServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "=", (Object)objId);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        return grpHelper.isExists(qFilter.toArray());
    }

    private boolean isCalListViewEnable(Long calListViewId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_callistview");
        QFilter idFilter = new QFilter("id", "=", (Object)calListViewId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        return helper.isExists(new QFilter[]{idFilter, statusFilter, enableFilter, hisCurrFilter});
    }

    private Long queryCalListViewVId(Long calListViewId) {
        return calListViewId;
    }

    private DynamicObject queryGrpv(Long grpId) {
        SWCDataServiceHelper grpHisHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter qFilter = new QFilter("boid", "=", (Object)grpId);
        Date curDayDate = SWCDateTimeUtils.getDayDate((Date)new Date());
        qFilter.and(new QFilter("bsed", "<=", (Object)curDayDate));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        String selProps = "boid,country,currency,org,exratetable,payrollsceneentry, payrollscene, periodtype, calrule, callistview,prorationcal";
        DynamicObject[] grpvDys = grpHisHelper.query(selProps, qFilter.toArray(), "bsed desc");
        if (grpvDys.length <= 0) {
            return null;
        }
        return grpvDys[0];
    }

    private DynamicObject getTplV(Long tplBoId) {
        SWCDataServiceHelper tplHisHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        QFilter qFilter = new QFilter("boid", "=", (Object)tplBoId);
        Date curDayDate = SWCDateTimeUtils.getDayDate((Date)new Date());
        qFilter.and(new QFilter("bsed", "<=", (Object)curDayDate));
        qFilter.and(new QFilter("bsled", ">=", (Object)curDayDate));
        QFilter qFilterEffect = new QFilter("datastatus", "=", (Object)"1");
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        String props = "id,boid,datastatus,tasktype,bsed,bsled,org,number,name,chargeperson,payrollgrp,payrollscene,tracker,isrelatedperm,nameprefix,namebody,namesuffix,operation,operationdays,notifyway,notifyconfig,successnotifyobj";
        return tplHisHelper.queryOne(props, new QFilter[]{qFilter, qFilterEffect});
    }

    private DynamicObject queryPayrollSceneV(Long payrollSceneId) {
        SWCDataServiceHelper sceneHisHelper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter qFilter = new QFilter("boid", "=", (Object)payrollSceneId);
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        String selProps = "boid, aftercal, periodtype, calrule, callistrule, callistview, isenableatt, matchattperiod, islimitadd";
        return sceneHisHelper.queryOne(selProps, qFilter.toArray());
    }

    @NotNull
    private String getCalTaskName(String namePrefix, String nameBody, String nameSuffix, String periodName, String calRuleName, String payrollGrpName, String payrollSceneName) {
        StringBuilder name = new StringBuilder();
        switch (nameBody) {
            case "A": {
                name.append(namePrefix).append(periodName).append(nameSuffix);
                break;
            }
            case "B": {
                name.append(namePrefix).append(calRuleName).append(periodName).append(nameSuffix);
                break;
            }
            case "C": {
                name.append(namePrefix).append(payrollGrpName).append(periodName).append(nameSuffix);
                break;
            }
            case "D": {
                name.append(namePrefix).append(payrollSceneName).append(periodName).append(nameSuffix);
                break;
            }
            default: {
                name.append(namePrefix).append(payrollGrpName).append(periodName).append(nameSuffix);
            }
        }
        return name.toString();
    }

    private void copyMulBaseDataField(DynamicObject entry, DynamicObject calTaskDy, String mulBaseDataField) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)calTaskDy.getDataEntityType().getProperties().get((Object)mulBaseDataField);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)calTaskDy);
        DynamicObject dyObj = entry.getDynamicObject(mulBaseDataField);
        long currentUserId = 0L;
        if (dyObj != null) {
            currentUserId = dyObj.getLong("id");
        }
        DynamicObject newRow = new DynamicObject(subEntityType);
        rows.add((Object)newRow);
        DynamicObject newBasedataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType());
        basedataProp.setValue((Object)newRow, (Object)newBasedataObj);
    }

    private void sendMsg(DynamicObject tplV, String scene, String msgTitle, String msgContent, String msgTag) {
        String notifyConfig = tplV.getString("notifyconfig");
        if (SWCObjectUtils.isEmpty((Object)notifyConfig)) {
            return;
        }
        String[] notifyWays = tplV.getString("notifyway").split(",");
        List dataList = (List)SerializationUtils.fromJsonString((String)notifyConfig, List.class);
        String cfgCombox = "1";
        for (Map rowData : dataList) {
            String sceneComb = (String)rowData.get(KEY_EXPSCENE);
            if (!SWCObjectUtils.equals((Object)scene, (Object)"hsas_".concat(sceneComb))) continue;
            cfgCombox = (String)rowData.get(KEY_NOTIFYOBJ);
        }
        switch (cfgCombox) {
            case "1": {
                return;
            }
            case "2": {
                AbstractCollection receives = new ArrayList(1);
                receives.add(tplV.getLong("chargeperson.id"));
                CalTaskNewTplMsgHelper.sendMsg(scene, (List<Long>)((Object)receives), Arrays.asList(notifyWays), tplV.getLong("id"), msgTitle, msgContent, msgTag);
                return;
            }
            case "3": {
                AbstractCollection receives = new ArrayList(1);
                receives.add(tplV.getLong("tracker.id"));
                CalTaskNewTplMsgHelper.sendMsg(scene, (List<Long>)((Object)receives), Arrays.asList(notifyWays), tplV.getLong("id"), msgTitle, msgContent, msgTag);
                return;
            }
            case "4": {
                AbstractCollection receives = new HashSet(16);
                receives.add(tplV.getLong("chargeperson.id"));
                receives.add(tplV.getLong("tracker.id"));
                CalTaskNewTplMsgHelper.sendMsg(scene, new ArrayList<Long>(receives), Arrays.asList(notifyWays), tplV.getLong("id"), msgTitle, msgContent, msgTag);
                return;
            }
        }
    }

    private DynamicObject[] queryCalRulevDys(DynamicObject payrollScenevDy, Date endDate) {
        SWCDataServiceHelper calRulevHelper = new SWCDataServiceHelper("hsas_calrule");
        QFilter calRulevFilter = new QFilter("boid", "=", (Object)payrollScenevDy.getLong("calrule.id"));
        calRulevFilter.and("datastatus", "=", (Object)"1");
        Date dayDate = SWCDateTimeUtils.getDayDate((Date)endDate);
        calRulevFilter.and("bsed", "<=", (Object)dayDate);
        BaseDataHisHelper.addHisVerFilter((QFilter)calRulevFilter);
        return calRulevHelper.query("id,calruleitementry.ispayoutitem", calRulevFilter.toArray(), "bsed desc");
    }

    private void addPersonToTask(Map<String, Object> calTaskMap, DynamicObject tplV, DynamicObject periodDy, Date startTime, RequestContext requestContext) {
        long calTaskId = (Long)calTaskMap.get("id");
        String calTaskNumber = (String)calTaskMap.get("number");
        String notifyConfig = tplV.getString("notifyconfig");
        try {
            String errorCode;
            String isRelatedPerm = tplV.getString("isrelatedperm");
            String userId = requestContext.getUserId();
            if (this.isSysExecute(userId)) {
                if ("true".equals(isRelatedPerm)) {
                    long trackerId = tplV.getLong("tracker.id");
                    errorCode = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPersonByTemplateWhenCreateTask", (Object[])new Object[]{calTaskId, trackerId});
                } else {
                    errorCode = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPersonByTemplateWhenCreateTask", (Object[])new Object[]{calTaskId, 0L});
                }
            } else {
                errorCode = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPersonByTemplateWhenCreateTask", (Object[])new Object[]{calTaskId, Long.parseLong(userId)});
            }
            logger.info("RequestContext requestContext UserId = {}", (Object)userId);
            if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                throw new KDBizException(CalPersonLockEnum.getDesc((String)errorCode));
            }
        }
        catch (Exception e) {
            logger.error("task auto add person error:", (Throwable)e);
            DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), KEY_LOG_TPL_CALL_STATE_FAIL, this.getLogDetailInfo(CALL_ADD_PERSON_SERVICE_FAIL, startTime), startTime, requestContext, periodDy.getLong("id"));
            this.logHelper.saveOne(logDyObj);
            throw e;
        }
        DynamicObject logDyObj = this.fillLogInfo(tplV.getString("number"), tplV.getLong("id"), "1", this.getLogDetailInfo(ADD_PERSON_SUCCESS_SYNC, startTime), startTime, requestContext, periodDy.getLong("id"));
        this.logHelper.saveOne(logDyObj);
        this.sendSuccessMsg(tplV, notifyConfig, calTaskNumber);
    }

    private void setLogDyObjUser(RequestContext requestContext, DynamicObject logDy) {
        String userId = requestContext.getUserId();
        if (this.isSysExecute(userId)) {
            logDy.set(KEY_LOG_EXCUTE_TYPE, (Object)LOG_EXCUTE_TYPE_SYS);
            logDy.set(KEY_LOG_EXCUTOR, (Object)0L);
            logDy.set("creator", (Object)0L);
        } else {
            logDy.set(KEY_LOG_EXCUTE_TYPE, (Object)LOG_EXCUTE_TYPE_MANUAL);
            logDy.set(KEY_LOG_EXCUTOR, (Object)userId);
            logDy.set("creator", (Object)userId);
        }
    }

    private boolean isSysExecute(String userId) {
        return "100".equals(userId);
    }

    private void sendSuccessMsg(DynamicObject tplV, String notifyConfig, String calTaskNumber) {
        String successNotifyObj = tplV.getString(KEY_SUCCESSNOTIFYOBJ);
        if (SWCObjectUtils.isEmpty((Object)successNotifyObj) || SWCObjectUtils.isEmpty((Object)notifyConfig)) {
            return;
        }
        HashSet<Long> receives = new HashSet<Long>(10);
        switch (successNotifyObj) {
            case "1": {
                return;
            }
            case "2": {
                receives.add(tplV.getLong("chargeperson.id"));
                break;
            }
            case "3": {
                receives.add(tplV.getLong("tracker.id"));
                break;
            }
            case "4": {
                receives.add(tplV.getLong("chargeperson.id"));
                receives.add(tplV.getLong("tracker.id"));
                break;
            }
            default: {
                return;
            }
        }
        String msgTitle2 = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u521b\u5efa\u6210\u529f", (String)"CalTaskNewSheduleTask_29", (String)"swc-hsas-business", (Object[])new Object[0]);
        List<String> channels = Collections.singletonList(MessageChannels.MC.toString());
        String msgContent = MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u57fa\u4e8e\u6838\u7b97\u4efb\u52a1\u6a21\u677f{0}-{1}\u5df2\u6210\u529f\u521b\u5efa\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\uff0c\u7f16\u7801\u4e3a{2}\uff0c\u8bf7\u77e5\u6089\u3002\u8be6\u60c5\u53ef\u67e5\u770b\u201c\u6838\u7b97\u4efb\u52a1\u521b\u5efa\u65e5\u5fd7\u201d\u3002", (String)"CalTaskNewSheduleTask_31", (String)"swc-hsas-business", (Object[])new Object[0]), tplV.getString("number"), tplV.getString("name"), calTaskNumber);
        CalTaskNewTplMsgHelper.sendMsg("", new ArrayList<Long>(receives), channels, tplV.getLong("id"), msgTitle2, msgContent, msgTag.get());
    }

    private DynamicObject fillLogInfo(String tplNumber, long tplvId, String tplCallState, String logDetail, Date startTime, RequestContext requestContext, long periodId) {
        DynamicObject logDy = this.logHelper.generateEmptyDynamicObject();
        logDy.set(KEY_LOG_NUMBER, (Object)tplNumber);
        logDy.set(KEY_LOG_NAME, (Object)tplvId);
        logDy.set(KEY_LOG_CALL_PERIOD, (Object)periodId);
        this.setLogDyObjUser(requestContext, logDy);
        logDy.set(KEY_LOG_START_TIME, (Object)startTime);
        logDy.set("modifier", (Object)0L);
        logDy.set("modifytime", null);
        logDy.set(KEY_LOG_TPL_CALL_STATE, (Object)tplCallState);
        logDy.set(KEY_LOG_TPL_CALL_DETAIL, (Object)logDetail);
        logDy.set("description", null);
        logDy.set(KEY_LOG_END_TIME, (Object)new Date());
        logDy.set("createtime", (Object)new Date());
        return logDy;
    }

    private boolean isCalPersonRuleEnable(Long calPersonRuleId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_callistrule");
        DynamicObject dyObj = helper.queryOne("status, enable", (Object)calPersonRuleId);
        if (dyObj == null) {
            return false;
        }
        return "C".equals(dyObj.getString("status")) && "1".equals(dyObj.getString("enable"));
    }

    private DynamicObject queryPersonRulev(Long calPersonRuleId, Date periodEndDate) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_callistrule");
        QFilter qFilter = new QFilter("boid", "=", (Object)calPersonRuleId);
        Date dayDate = SWCDateTimeUtils.getDayDate((Date)periodEndDate);
        qFilter.and(new QFilter("bsed", "<=", (Object)dayDate));
        qFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        String selProps = "id";
        DynamicObject[] dyObjs = helper.query(selProps, qFilter.toArray(), "bsed desc");
        if (dyObjs == null || dyObjs.length <= 0) {
            return null;
        }
        return dyObjs[0];
    }

    private int getCalCount(long payRollGroupId, long payRollSceneId, long payPeriodId) {
        QFilter filter = PayRollTaskService.getGrpSceneAndPeriodFilter(payRollGroupId, payRollSceneId, payPeriodId, null);
        int maxCount = PayRollTaskHelper.queryTotalCalCount(filter);
        return maxCount + 1;
    }

    private String getLogDetailInfo(String reasonStr, Date endDate) {
        HashMap<String, String> infoMap = new HashMap<String, String>(16);
        infoMap.put(CAL_TASK_TPL_ID_LOST, ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u53c2\u6570\uff08calTaskTplId\uff09\u4e22\u5931\uff0c\u8bf7\u524d\u5f80\u201c\u7cfb\u7edf\u7ba1\u7406-\u8c03\u5ea6\u4f5c\u4e1a\u201d\u68c0\u67e5\u6267\u884c\u53c2\u6570\u3002", (String)"CalTaskNewSheduleTask_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(CAL_TASK_DISABLE, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u88ab\u7981\u7528\u3002", (String)"CalTaskNewSheduleTask_40", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_CAL_TASK_TPLV, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7248\u672c\u6570\u636e\u4e22\u5931\u3002", (String)"CalTaskNewSheduleTask_4", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(TPLV_DATASTATUS_ERROR, ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u751f\u6548\u65e5\u671f\u5c0f\u4e8e\u7b49\u4e8e\u8c03\u5ea6\u65e5\u671f\u7684\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_5", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(GRPV_DATASTATUS_ERROR, ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6548\u7684\u4e14\u751f\u6548\u65e5\u671f\u5c0f\u4e8e\u7b49\u4e8e\u8c03\u5ea6\u65e5\u671f\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(GRPV_DISABLE, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u88ab\u7981\u7528\u3002", (String)"CalTaskNewSheduleTask_32", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_PAYROLLSCENE, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6570\u636e\u4e22\u5931\u3002", (String)"CalTaskNewSheduleTask_7", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(SCENE_NOT_MATCH, ResManager.loadKDString((String)"\u8c03\u7528\u7684\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7248\u672c\u4e0a\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u4e0e\u5176\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u5f53\u524d\u751f\u6548\u7248\u672c\u4e0a\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u4e0d\u4e00\u81f4\u3002", (String)"CalTaskNewSheduleTask_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(SCENEV_DATASTATUS_ERROR, ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6548\u7684\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_9", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(SCENEV_DISABLE, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u88ab\u7981\u7528\u3002", (String)"CalTaskNewSheduleTask_33", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_PERIODTYPE, ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u6570\u636e\u4e22\u5931\u3002", (String)"CalTaskNewSheduleTask_10", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(PERIODTYPE_DATASTATUS_ERROR, ResManager.loadKDString((String)"\u8c03\u7528\u7684\u671f\u95f4\u7c7b\u578b\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u201c\u53ef\u7528\u201d\u3002", (String)"CalTaskNewSheduleTask_11", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_PERIOD, ResManager.loadKDString((String)"\u6839\u636e\u201c\u751f\u6210\u6240\u5c5e\u671f\u95f4\u65e5\u671f\u201d\u5339\u914d\u85aa\u8d44\u671f\u95f4\u5931\u8d25\uff1a\u5339\u914d\u65e5\u671f\u672a\u843d\u5728\u4efb\u4f55\u4e00\u4e2a\u85aa\u8d44\u671f\u95f4\u7684\u5f00\u59cb\u7ed3\u675f\u65e5\u671f\u5185\u3002", (String)"CalTaskNewSheduleTask_12", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_CALRULEV, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u201c%s\u201d\u524d\u4e0d\u5b58\u5728\u6709\u6548\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_13", (String)"swc-hsas-business", (Object[])new Object[0]), SWCInteDateTimeUtil.formateDate((Date)endDate)));
        infoMap.put(CALRULE_DISABLE, ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5df2\u7981\u7528\u3002", (String)"CalTaskNewSheduleTask_34", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(CALRULE_NO_ACTUAL_PROJ, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u5f0f\u4e3a\u201c\u4e2a\u4f53\u53d1\u653e\u201d\u4e14\u5f15\u7528\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e2d\u4e0d\u5b58\u5728\u5b9e\u53d1\u9879\u76ee\u3002", (String)"CalTaskNewSheduleTask_14", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(PERSON_RULE_DATASTATUS_ERROR, ResManager.loadKDString((String)"\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u7684\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"CalTaskNewSheduleTask_16", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_PERSON_RULEV, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728\u8c03\u7528\u7684\u671f\u95f4\u7ed3\u675f\u65e5\u671f%s\u524d\uff0c\u6240\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_17", (String)"swc-hsas-business", (Object[])new Object[0]), SWCInteDateTimeUtil.formateDate((Date)endDate)));
        infoMap.put(CAL_LIST_VIEW_DISABLE, ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u201c\u53ef\u7528\u201d\u3002", (String)"CalTaskNewSheduleTask_35", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NO_CAL_LIST_VIEWV, ResManager.loadKDString((String)"\u8c03\u7528\u7684\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u65e0\u6709\u6548\u6570\u636e\u7248\u672c\u3002", (String)"CalTaskNewSheduleTask_36", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(CALL_ADD_PERSON_SERVICE_FAIL, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff0c\u4f46\u6dfb\u52a0\u6838\u7b97\u540d\u5355\u5931\u8d25\u3002", (String)"CalTaskNewSheduleTask_39", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(ADD_PERSON_SUCCESS_SYNC, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff0c\u6838\u7b97\u540d\u5355\u6dfb\u52a0\u6210\u529f\u3002", (String)"CalTaskNewSheduleTask_18", (String)"swc-hsas-business", (Object[])new Object[0]));
        infoMap.put(NUMBER_RULE_DISABLE, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u7684\u7f16\u7801\u89c4\u5219\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u3002", (String)"CalTaskNewSheduleTask_41", (String)"swc-hsas-business", (Object[])new Object[0]));
        return (String)infoMap.get(reasonStr);
    }
}

