/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCUnifiedThreadPoolFactory;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;

public class DepempDataUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(DepempDataUpgradeTask.class);
    private static Map<String, String> formIdMap = new LinkedHashMap<String, String>();
    public static final int DEAL_SIZE = 15000;
    public static final int DEFAULT_SIZE = 5000;
    public static final int SAVE_DATA_SIZE = 500;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doUpgrade(map);
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        service.disableSchedule("2R40OCRJI4BO");
    }

    private void doUpgrade(Map<String, Object> paramMap) {
        LOGGER.info("DepempDataUpgradeTaskStart");
        formIdMap.forEach(this::syncPersonInfo);
    }

    private void syncPersonInfo(String orgEntity, String destEntity) {
        SWCDataServiceHelper desthelper = new SWCDataServiceHelper(destEntity);
        switch (destEntity) {
            case "hsas_depemp": {
                QFilter qFilter = new QFilter("laborrelrecord", "=", (Object)0);
                qFilter.or("assignno", "=", (Object)" ");
                qFilter.or("apositiontype", "=", (Object)" ");
                qFilter.or("number", "=", (Object)" ");
                qFilter.or("dutyworkroles", "=", (Object)0);
                qFilter.or("orgteam", "=", (Object)0);
                qFilter.or("otclassify", "=", (Object)0);
                qFilter.or("showname", "=", (Object)" ");
                this.syncPersonWithBoid(orgEntity, destEntity, desthelper, qFilter);
                break;
            }
            case "hsas_empposorgrelhr": {
                QFilter qFilter = new QFilter("apositiontype", "=", (Object)" ");
                qFilter.or("number", "=", (Object)" ");
                qFilter.or("adminorgvid", "=", (Object)0);
                qFilter.or(QFilter.isNull((String)"adminorgvid"));
                this.syncPersonWithBoid(orgEntity, destEntity, desthelper, qFilter);
                break;
            }
            case "hsas_managingscope": {
                QFilter qFilter = new QFilter("cmpemp", "=", (Object)0);
                qFilter.or(QFilter.isNull((String)"cmpemp"));
                this.syncPersonWithBoid(orgEntity, destEntity, desthelper, qFilter);
                break;
            }
        }
    }

    private void syncPersonWithBoid(String orgEntity, String destEntity, SWCDataServiceHelper desthelper, QFilter qFilter) {
        Long maxBoId = 0L;
        while (true) {
            QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
            hisCurrFilter.and("id", ">", (Object)maxBoId);
            DynamicObject[] orgdys = desthelper.query("id", new QFilter[]{qFilter, hisCurrFilter}, "id", 15000);
            if (orgdys == null || orgdys.length == 0) break;
            maxBoId = orgdys[orgdys.length - 1].getLong("id");
            Set<Long> entityBoIds = Arrays.stream(orgdys).map(single -> single.getLong("id")).collect(Collectors.toSet());
            this.dealSyncPersonEntity(orgEntity, destEntity, entityBoIds);
        }
        if ("hsas_empposorgrelhr".equals(destEntity)) {
            Set<Long> resBoIds = this.compareNumber();
            this.dealSyncPersonEntity(orgEntity, destEntity, resBoIds);
        }
    }

    private void dealSyncPersonEntity(String orgEntity, String destEntity, Set<Long> resBoIds) {
        LOGGER.info("DepempDataUpgradeTask...sync begin orgEntity:{}, destEntity:{}, resBoIds.size:{}", new Object[]{orgEntity, destEntity, resBoIds.size()});
        List subList = Lists.partition(new ArrayList<Long>(resBoIds), (int)5000);
        SyncPersonHelper syncPersonHelper = new SyncPersonHelper();
        ArrayList<Future> futureList = new ArrayList<Future>(subList.size());
        for (List empList : subList) {
            Future future = SWCUnifiedThreadPoolFactory.SERVICE.submit(() -> {
                List subEntityBoIds = Lists.partition((List)empList, (int)500);
                for (List currentEntityBoIds : subEntityBoIds) {
                    syncPersonHelper.syncPersonOneEntity(orgEntity, destEntity, currentEntityBoIds);
                }
                return Boolean.TRUE;
            }, SWCUnifiedTaskTypeEnum.SWC_HSAS_PERSONSYNCTHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private Set<Long> compareNumber() {
        StringBuilder sql = new StringBuilder("SELECT TOP 100000  H.FBOID boid FROM T_HSAS_EMPPOSORGRELHR H INNER JOIN T_HSAS_DEPEMP D ON H.FDEPEMPID = D.FID AND H.FISCURRENTVERSION = '1' AND D.FISCURRENTVERSION = '1' WHERE H.FNUMBER !=D.FNUMBER  ");
        DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".compareNumber"), (DBRoute)SWCConstants.SWC_ROUETE, (String)sql.toString());
        if (ds != null) {
            HashSet<Long> numberBoIds = new HashSet<Long>(16);
            while (ds.hasNext()) {
                Row row = ds.next();
                numberBoIds.add(row.getLong("boid"));
            }
            ds.close();
            return numberBoIds;
        }
        return new HashSet<Long>(0);
    }

    static {
        formIdMap.put("hrpi_depemp", "hsas_depemp");
        formIdMap.put("hrpi_empposorgrel", "hsas_empposorgrelhr");
        formIdMap.put("hrpi_managingscope", "hsas_managingscope");
    }
}

