/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class InsuranceDataTabUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InsuranceDataTabUpdateTask.class);
    private static final int batchSize = 1000;
    private static final String tableName = "t_hsas_insurancedata";
    private static final String sql = "select fid from t_hsas_insurancedata where fpersonid = 0";
    private static final String updatesql1 = "update t_hsas_insurancedata set fwithholddate = fperioddate  where fusestatus = '0' and  fwithholddate is null and fid in  ";
    private static final String updatesql2 = "update t_hsas_insurancedata i set fwithholddate = ( select  t.fpaydate  from t_hsas_calpayrolltask_a t where t.fid = i.fcaltaskid)  where i.fusestatus = '1' and  i.fwithholddate is null and i.fid in  ";
    private static final String updatesql3 = "update t_hsas_insurancedata i set fpersonid = ( select e.fpersonid from t_hsas_employee e where e.fid = i.femployeeid) where i.fpersonid = 0 and exists ( select 1 from t_hsas_employee where fid = i.femployeeid ) and i.fid in ";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updateBizData();
            }
        }
        catch (Exception e) {
            logger.error("InsuranceDataTabUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        logger.info("InsuranceDataTabUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBizData() {
        logger.info("start to deal bizdata \uff1a{}", (Object)tableName);
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryInsuranceDataSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryInsuranceDataSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
            this.queryBatch = 0;
            logger.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        ArrayList<Long> insuranceDataIds = new ArrayList<Long>(1000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            insuranceDataIds.add(id);
            if (++count < 1000) continue;
            ++this.queryBatch;
            break;
        }
        if (insuranceDataIds.size() > 0) {
            try (TXHandle txHandle = TX.requiresNew();){
                String condition = insuranceDataIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
                SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)(updatesql1 + condition), (Object[])new Object[0]);
                SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)(updatesql2 + condition), (Object[])new Object[0]);
                SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)(updatesql3 + condition), (Object[])new Object[0]);
            }
        }
        return true;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

