/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hsas.business.task.UpgradeTaskHelper;
import kd.swc.hsbp.common.constants.SWCBaseConstants;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class InsuranceDataUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InsuranceDataUpdateTask.class);
    private static final int SPLIT_SIZE = 1000;
    private static final HRBaseServiceHelper INSURANCE_DATA = HRBaseServiceHelper.create((String)"hsas_insurancedata");
    private static final String NUMBER_ITEM = "number";
    private static final String AMOUNT_ITEM = "amount";
    private static final String STORAGE_TYPE = "storagetype";
    private static final String ITEM_VALUE_IS_NULL = "isnull";
    private static final String NUMBER_ITEM_VALUE = "numvalue";
    private static final String AMOUNT_ITEM_VALUE = "amountvalue";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashSet<Date> withHoldDates = new HashSet<Date>(64);
        String selectSql = "SELECT DISTINCT FWITHHOLDDATE withholddate FROM T_HSAS_INSURANCEDATA";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"InsuranceDataUpdateTask", (DBRoute)SWCBaseConstants.DB_ROUTE_SWC, (String)selectSql, null);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Date withHoldDate = row.getDate("withholddate");
                if (withHoldDate == null) continue;
                withHoldDates.add(withHoldDate);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (withHoldDates.isEmpty()) {
            logger.info("InsuranceDataUpdateTask.execute: withHoldDates is empty.");
            UpgradeTaskHelper.disableTask(this.taskId);
            return;
        }
        Map<Long, Long> itemPropMap = this.getItemPropMap();
        if (itemPropMap.isEmpty()) {
            logger.info("InsuranceDataUpdateTask.execute: itemPropMap is empty.");
            return;
        }
        for (Date withHoldDate : withHoldDates) {
            this.updateInsuranceDataResult(withHoldDate, itemPropMap);
        }
        logger.info("InsuranceDataUpdateTask.execute: update successfully.");
        UpgradeTaskHelper.disableTask(this.taskId);
    }

    private void updateInsuranceDataResult(Date withHoldDate, Map<Long, Long> itemPropMap) {
        QFilter filter = new QFilter("withholddate", "=", (Object)withHoldDate);
        DynamicObjectCollection insuranceDataDys = INSURANCE_DATA.queryOriginalCollection("id", filter.toArray());
        if (insuranceDataDys == null || insuranceDataDys.isEmpty()) {
            return;
        }
        List insuranceDataIds = insuranceDataDys.stream().map(insuranceDataDy -> insuranceDataDy.getLong("id")).collect(Collectors.toList());
        List subInsuranceDataIdsList = SWCListUtils.split(insuranceDataIds, (int)1000);
        for (List subInsuranceDataIds : subInsuranceDataIdsList) {
            this.updateData(subInsuranceDataIds, itemPropMap);
        }
    }

    private Map<Long, Long> getItemPropMap() {
        Map resultMap = (Map)SWCMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getInsuranceItemByStatus", (Object[])new Object[]{null, 0});
        if (resultMap == null || resultMap.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> itemPropMap = new HashMap<Long, Long>(16);
        for (Map.Entry entry : resultMap.entrySet()) {
            boolean isInvalid;
            Map fieldMap = (Map)entry.getValue();
            boolean bl = isInvalid = fieldMap == null || fieldMap.isEmpty() || fieldMap.get("datatypeId") == null;
            if (isInvalid) continue;
            itemPropMap.put((Long)entry.getKey(), Long.valueOf((String)fieldMap.get("datatypeId")));
        }
        return itemPropMap;
    }

    private void updateData(List<Long> subInsuranceDataIds, Map<Long, Long> itemPropMap) {
        QFilter filter = new QFilter("id", "in", subInsuranceDataIds);
        DynamicObject[] insuranceDataDys = INSURANCE_DATA.query("id,entryentity.insuranceitem,entryentity.numvalue,entryentity.amountvalue,entryentity.isnull,entryentity.storagetype", filter.toArray());
        if (insuranceDataDys == null || insuranceDataDys.length == 0) {
            return;
        }
        HashMap<Long, HashSet<Long>> insuranceDataIdAndInvalidItemIds = new HashMap<Long, HashSet<Long>>(16);
        for (DynamicObject insuranceDataDy : insuranceDataDys) {
            DynamicObjectCollection entryEntity = insuranceDataDy.getDynamicObjectCollection("entryentity");
            HashSet<Long> invalidItemIds = new HashSet<Long>(16);
            this.handleEntityData(entryEntity, itemPropMap, invalidItemIds);
            if (invalidItemIds.isEmpty()) continue;
            insuranceDataIdAndInvalidItemIds.put(insuranceDataDy.getLong("id"), invalidItemIds);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            INSURANCE_DATA.save(insuranceDataDys);
        }
        if (!insuranceDataIdAndInvalidItemIds.isEmpty()) {
            logger.error("InsuranceDataUpdateTask.updateData error, calPersonIdAndInvalidItemIds: {}", (Object)JSONObject.toJSONString(insuranceDataIdAndInvalidItemIds));
        }
    }

    private void handleEntityData(DynamicObjectCollection entryEntity, Map<Long, Long> itemPropMap, Set<Long> invalidItemIds) {
        for (DynamicObject entity : entryEntity) {
            BigDecimal lastValue;
            String storageType;
            long insuranceItemId = entity.getLong("insuranceitem");
            Long dataTypeId = itemPropMap.get(insuranceItemId);
            if (dataTypeId == null || !HRStringUtils.isEmpty((String)(storageType = entity.getString(STORAGE_TYPE)))) continue;
            boolean isNumber = Long.valueOf(DataTypeEnum.NUMBERIC.getDbId()).equals(dataTypeId);
            boolean isAmount = Long.valueOf(DataTypeEnum.AMOUNT.getDbId()).equals(dataTypeId);
            if (!isNumber && !isAmount) {
                invalidItemIds.add(insuranceItemId);
                continue;
            }
            String lastStorageType = isNumber ? NUMBER_ITEM : AMOUNT_ITEM;
            entity.set(STORAGE_TYPE, (Object)lastStorageType);
            BigDecimal amountValue = entity.getBigDecimal(AMOUNT_ITEM_VALUE);
            BigDecimal numValue = entity.getBigDecimal(NUMBER_ITEM_VALUE);
            BigDecimal bigDecimal = amountValue.compareTo(BigDecimal.ZERO) != 0 ? amountValue : (lastValue = numValue.compareTo(BigDecimal.ZERO) != 0 ? numValue : BigDecimal.ZERO);
            if (isNumber) {
                entity.set(NUMBER_ITEM_VALUE, (Object)lastValue);
                entity.set(AMOUNT_ITEM_VALUE, (Object)BigDecimal.ZERO);
            } else {
                entity.set(AMOUNT_ITEM_VALUE, (Object)lastValue);
                entity.set(NUMBER_ITEM_VALUE, (Object)BigDecimal.ZERO);
            }
            if (lastValue.compareTo(BigDecimal.ZERO) == 0) continue;
            entity.set(ITEM_VALUE_IS_NULL, (Object)Boolean.FALSE);
        }
    }
}

