/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class PayDetailBankUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PayDetailBankUpdateTask.class);
    private static final int batchSize = 5000;
    private static final String tableName = "t_hsas_paydetail_a";
    private static final String sql = "select fid, fperbankcardid from t_hsas_paydetail_a where fperbankcardid != 0 and (fbankdepositid = 0 or fbankdepositid is null)";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updatePayDetailBankId();
            }
        }
        catch (Exception e) {
            LOG.error("PayDetailBankUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOG.info("PayDetailBankUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updatePayDetailBankId() {
        LOG.info("start to deal payDetail \uff1a{}", (Object)tableName);
        long startTimeMillis = System.currentTimeMillis();
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryPayDetailSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryPayDetailSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
            this.queryBatch = 0;
            LOG.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashSet<Long> perBankCardSet = new HashSet<Long>(16);
        HashMap bankCardToPayDetailMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            Long perBankCardId = row.getLong("fperbankcardid");
            perBankCardSet.add(perBankCardId);
            List patDetailId = bankCardToPayDetailMap.getOrDefault(perBankCardId, new ArrayList());
            patDetailId.add(id);
            bankCardToPayDetailMap.put(perBankCardId, patDetailId);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        long endTimeMillis = System.currentTimeMillis();
        LOG.info(" execute query payDetail used : {}", (Object)(endTimeMillis - startTimeMillis));
        HRBaseServiceHelper perBankCardHelper = new HRBaseServiceHelper("hrpi_perbankcard");
        String selectProperties = "id,bankdeposit.id";
        DynamicObject[] perBankCardColl = perBankCardHelper.queryOriginalArray(selectProperties, new QFilter[]{new QFilter("id", "in", perBankCardSet)});
        HashMap<Long, DynamicObject> perBankCardToObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject perBankCard : perBankCardColl) {
            perBankCardToObjMap.put(perBankCard.getLong("id"), perBankCard);
        }
        long queryPerBankCardEndTime = System.currentTimeMillis();
        LOG.info(" execute query PayDetail used : {}", (Object)(queryPerBankCardEndTime - endTimeMillis));
        this.updatePayDetailBankId(bankCardToPayDetailMap, perBankCardToObjMap);
        LOG.info(" execute update PayDetail used : {}", (Object)(System.currentTimeMillis() - queryPerBankCardEndTime));
        return true;
    }

    private void updatePayDetailBankId(Map<Long, List<Long>> bankCardToPayDetailMap, Map<Long, DynamicObject> perBankCardToObjMap) {
        String updateSql = "update t_hsas_paydetail_a set fbankdepositid = ? where fid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, List<Long>> entry : bankCardToPayDetailMap.entrySet()) {
            Object[] obj;
            Long perBankCardId = entry.getKey();
            List<Long> payDetailIds = entry.getValue();
            DynamicObject perBankCard = perBankCardToObjMap.get(perBankCardId);
            if (perBankCard == null) {
                LOG.error("person id {} not query", (Object)perBankCardId);
                for (Long payDetailId : payDetailIds) {
                    obj = new Object[]{-1L, payDetailId};
                    updateList.add(obj);
                }
                continue;
            }
            for (Long payDetailId : payDetailIds) {
                obj = new Object[]{perBankCard.getLong("bankdeposit.id"), payDetailId};
                updateList.add(obj);
            }
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, updateList);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

