/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsas.common.enums.PayDetailAbandonReasonEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayDetailUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PayDetailUpdateTask.class);
    private static Map<String, String> updateMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (TXHandle txHandle = TX.requiresNew();){
            String updateSql = "update t_hsas_paydetail set fabandonedres = ? where fabandonedres = ?";
            this.batchUpdate(updateSql);
            String updateLangSql = "update t_hsas_paydetail_l set fabandonedres = ? where fabandonedres = ?";
            this.batchUpdate(updateLangSql);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("sch_schedule");
            DynamicObject schedule = helper.queryOne("id,status", new QFilter[]{new QFilter("number", "=", (Object)"hsas_PayDetailUpdateTask_SKDP_S")});
            schedule.set("status", (Object)"0");
            helper.updateOne(schedule);
        }
    }

    private void batchUpdate(String sql) {
        for (Map.Entry<String, String> entry : updateMap.entrySet()) {
            if (SWCStringUtils.isEmpty((String)entry.getValue())) continue;
            Object[] updateParams = new Object[]{entry.getValue(), entry.getKey()};
            SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])updateParams);
        }
    }

    static {
        LocaleString mulReason1 = PayDetailAbandonReasonEnum.ABANDON_ACCOUNT_MODIFY.getLocaleStringDesc();
        LocaleString mulReason2 = PayDetailAbandonReasonEnum.ABANDON_ACCOUNT_MODIFY_UNAUDIT.getLocaleStringDesc();
        LocaleString mulReason3 = PayDetailAbandonReasonEnum.ABANDON_ACCOUNT_MODIFY_DISAPPROVE.getLocaleStringDesc();
        LocaleString newMulReason1 = PayDetailAbandonReasonEnum.ACCOUNT_MODIFY.getLocaleStringDesc();
        LocaleString newMulReason2 = PayDetailAbandonReasonEnum.ACCOUNT_MODIFY_UNAUDIT.getLocaleStringDesc();
        LocaleString newMulReason3 = PayDetailAbandonReasonEnum.ACCOUNT_MODIFY_DISAPPROVE.getLocaleStringDesc();
        updateMap = new HashMap<String, String>(9);
        updateMap.put(mulReason1.getLocaleValue_zh_CN(), newMulReason1.getLocaleValue_zh_CN());
        updateMap.put(mulReason2.getLocaleValue_zh_CN(), newMulReason2.getLocaleValue_zh_CN());
        updateMap.put(mulReason3.getLocaleValue_zh_CN(), newMulReason3.getLocaleValue_zh_CN());
        updateMap.put(mulReason1.getLocaleValue_zh_TW(), newMulReason1.getLocaleValue_zh_TW());
        updateMap.put(mulReason2.getLocaleValue_zh_TW(), newMulReason2.getLocaleValue_zh_TW());
        updateMap.put(mulReason3.getLocaleValue_zh_TW(), newMulReason3.getLocaleValue_zh_TW());
        updateMap.put(mulReason1.getLocaleValue_en(), newMulReason1.getLocaleValue_en());
        updateMap.put(mulReason2.getLocaleValue_en(), newMulReason2.getLocaleValue_en());
        updateMap.put(mulReason3.getLocaleValue_en(), newMulReason3.getLocaleValue_en());
    }
}

