/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.swc.hsas.business.cal.service.WorkCalendarLoadService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class PaySchNotifyTask
extends AbstractTask {
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private static final String APPCACHE_WORKPLAN = "payschnotifytask_workcalendar";
    private static final Log logger = LogFactory.getLog(PaySchNotifyTask.class);
    private static final long tenMinMill = 600000L;
    private static final int APPCACHE_TIMEOUT_TIME = 43200;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("PaySchNotifyTask is Started!");
        Date currentDate = SWCDateTimeUtils.getDayDate((Date)new Date());
        DynamicObject[] paySchDys = this.getPayScheduleDys(currentDate);
        if (paySchDys == null || paySchDys.length <= 0) {
            return;
        }
        Map<Long, DynamicObject> msgTplIdDyMap = this.queryMsgTplInfoMap(paySchDys);
        HashMap<Long, Long> tplIdWorkPlanIdMap = new HashMap<Long, Long>(16);
        Map<Long, List<DynamicObject>> tplIdPaySchDysMap = this.groupByTplId(paySchDys, tplIdWorkPlanIdMap);
        Map<String, List<Map<String, String>>> tplIdWorkPlansMap = this.queryWorkCalendarByTplIds(tplIdWorkPlanIdMap);
        for (Map.Entry<Long, List<DynamicObject>> entry : tplIdPaySchDysMap.entrySet()) {
            Long tplId = entry.getKey();
            List<Map<String, String>> workCalendars = tplIdWorkPlansMap.get(String.valueOf(tplId));
            List<DynamicObject> paySchDyIns = entry.getValue();
            for (DynamicObject paySchDy : paySchDyIns) {
                DynamicObjectCollection entryentity;
                DynamicObjectCollection trackerDyColl = paySchDy.getDynamicObjectCollection("tracker");
                if (trackerDyColl == null || trackerDyColl.isEmpty() || (entryentity = paySchDy.getDynamicObjectCollection("entryentity")) == null || entryentity.isEmpty()) continue;
                this.checkIsNeedSendMsg(paySchDy, entryentity, workCalendars, msgTplIdDyMap);
            }
        }
    }

    private DynamicObject[] getPayScheduleDys(Date currentDate) {
        SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
        QFilter qFilter = new QFilter("enddate", ">=", (Object)currentDate);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        String selProps = "id,org,payschtpl,payschtpl.id,payschtpl.workplan,payschtpl.workplan.id,startdate,enddate,tracker,entryentity,entryentity.isenable,entryentity.receiver,entryentity.msgtpl,entryentity.msgpushstep,entryentity.msgpushnum,entryentity.msgpushdaytype,entryentity.msgpushtime";
        DynamicObject[] dynamicObjects = null;
        try {
            dynamicObjects = paySchHelper.query(selProps, qFilter.toArray());
        }
        catch (Exception exc) {
            dynamicObjects = null;
            logger.info("try catch for BT-01304215,due to metadata rebuild error.");
        }
        return dynamicObjects;
    }

    private Map<Long, DynamicObject> queryMsgTplInfoMap(DynamicObject[] paySchDys) {
        Set<Long> needSendMsgTplIds = this.getNeedSendMsgTplIds(paySchDys);
        if (needSendMsgTplIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        SWCDataServiceHelper msgTplHelper = new SWCDataServiceHelper("msg_template");
        QFilter msgFilter = new QFilter("id", "in", needSendMsgTplIds);
        DynamicObject[] msgTplDys = msgTplHelper.queryOriginalArray("id,msgchannel,msgscene", msgFilter.toArray());
        HashMap<Long, DynamicObject> msgTplIdDyMap = new HashMap<Long, DynamicObject>(msgTplDys.length);
        for (DynamicObject msgTplDy : msgTplDys) {
            msgTplIdDyMap.put(msgTplDy.getLong("id"), msgTplDy);
        }
        return msgTplIdDyMap;
    }

    private Set<Long> getNeedSendMsgTplIds(DynamicObject[] paySchDys) {
        HashSet<Long> msgTplIds = new HashSet<Long>(10);
        if (paySchDys != null && paySchDys.length > 0) {
            for (DynamicObject paySchDy : paySchDys) {
                DynamicObjectCollection entryentity;
                DynamicObjectCollection trackerDyColl = paySchDy.getDynamicObjectCollection("tracker");
                if (trackerDyColl == null || trackerDyColl.isEmpty() || (entryentity = paySchDy.getDynamicObjectCollection("entryentity")) == null || entryentity.isEmpty()) continue;
                for (DynamicObject msgCgfDy : entryentity) {
                    boolean isEnable = msgCgfDy.getBoolean("isenable");
                    if (!isEnable) continue;
                    msgTplIds.add(msgCgfDy.getLong("msgtpl.id"));
                }
            }
        }
        return msgTplIds;
    }

    private void checkIsNeedSendMsg(DynamicObject paySchDy, DynamicObjectCollection entryentity, List<Map<String, String>> workDays, Map<Long, DynamicObject> msgTplIdDyMap) {
        logger.info("check isEnable to Send Message in checkIsNeedSendMsg method!");
        Date startDate = paySchDy.getDate("startdate");
        Date endDate = paySchDy.getDate("enddate");
        for (DynamicObject msgCgfDy : entryentity) {
            boolean isEnable = msgCgfDy.getBoolean("isenable");
            if (!isEnable) continue;
            DynamicObjectCollection receiverDyColl = msgCgfDy.getDynamicObjectCollection("receiver");
            List<Long> receviers = this.getReceviers(receiverDyColl);
            DynamicObject msgTplDy = msgTplIdDyMap.get(msgCgfDy.getLong("msgtpl.id"));
            if (msgTplDy == null) {
                logger.error("MessageTemplate's Data has Lost!");
                continue;
            }
            String notifyType = msgTplDy.getString("msgchannel");
            String msgScene = msgTplDy.getString("msgscene");
            String msgPushStep = msgCgfDy.getString("msgpushstep");
            int msgPushNum = msgCgfDy.getInt("msgpushnum");
            String msgPushDaytype = msgCgfDy.getString("msgpushdaytype");
            int msgPushTime = msgCgfDy.getInt("msgpushtime");
            Date compareDate = "1".equals(msgPushStep) ? endDate : startDate;
            Date compareDateAfter = "0".equals(msgPushDaytype) ? WorkCalendarLoadService.getWorkDate(compareDate, false, msgPushNum, workDays, false) : SWCDateTimeUtils.addDay((Date)compareDate, (long)(msgPushNum * -1));
            Date compareDateWithHMS = this.setCompareDateHMS(compareDateAfter, msgPushTime);
            if (!this.compareTwoLong(System.currentTimeMillis(), compareDateWithHMS.getTime(), 600000L)) continue;
            this.initAndSendMsg(msgScene, notifyType, receviers, paySchDy);
        }
    }

    private Date setCompareDateHMS(Date compareDateAfter, int msgPushTime) {
        int hour = msgPushTime / 3600;
        int min = msgPushTime % 3600 / 60;
        int sec = msgPushTime % 3600 % 60;
        Calendar calendar = Calendar.getInstance();
        String yyyyMMdd = this.format.format(compareDateAfter);
        String[] split = yyyyMMdd.split("-");
        calendar.set(Integer.parseInt(split[0]), Integer.parseInt(split[1]) - 1, Integer.parseInt(split[2]), hour, min, sec);
        return calendar.getTime();
    }

    private void initAndSendMsg(String msgScene, String notifyType, List<Long> receviers, DynamicObject paySchDy) {
        logger.info("Send Message Success in initAndSendMsg method!");
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setUserIds(receviers);
        msgInfo.setType("message");
        msgInfo.setEntityNumber("hsas_payschedule");
        msgInfo.setBizDataId(Long.valueOf(paySchDy.getLong("id")));
        msgInfo.setTitle(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u63d0\u9192", (String)"PaySchNotifyTask_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        String notifyStr = ResManager.loadKDString((String)"\u5373\u5c06\u5f00\u59cb", (String)"PaySchNotifyTask_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (msgScene.contains("end")) {
            notifyStr = ResManager.loadKDString((String)"\u5373\u5c06\u7ed3\u675f", (String)"PaySchNotifyTask_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        String content = MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b{0}{1}", (String)"PaySchNotifyTask_1", (String)"swc-hsas-business", (Object[])new Object[0]), paySchDy.getString("name"), notifyStr);
        msgInfo.setContent(content);
        msgInfo.setTag(ResManager.loadKDString((String)"\u63d0\u9192", (String)"PaySchNotifyTask_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        msgInfo.setTplScene(msgScene);
        msgInfo.setNotifyType(notifyType + "," + MessageChannels.MC.getNumber());
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        logger.info("PaySchNotifyTask is End!");
    }

    private List<Long> getReceviers(DynamicObjectCollection receiverDyColl) {
        ArrayList<Long> receviers = new ArrayList<Long>(receiverDyColl.size());
        for (DynamicObject receiverDy : receiverDyColl) {
            receviers.add(receiverDy.getLong("fbasedataid_id"));
        }
        return receviers;
    }

    private Map<Long, List<DynamicObject>> groupByTplId(DynamicObject[] paySchDys, Map<Long, Long> tplIdWorkPlanIdMap) {
        if (paySchDys == null || paySchDys.length <= 0) {
            return new HashMap<Long, List<DynamicObject>>(16);
        }
        HashMap<Long, List<DynamicObject>> tplIdPaySchDysMap = new HashMap<Long, List<DynamicObject>>(paySchDys.length);
        for (DynamicObject paySchDy : paySchDys) {
            long tplId = paySchDy.getLong("payschtpl.id");
            long workId = paySchDy.getLong("payschtpl.workplan.id");
            tplIdWorkPlanIdMap.put(tplId, workId);
            List dyObjs = tplIdPaySchDysMap.computeIfAbsent(tplId, k -> new ArrayList(10));
            dyObjs.add(paySchDy);
            tplIdPaySchDysMap.put(tplId, dyObjs);
        }
        return tplIdPaySchDysMap;
    }

    private Map<String, List<Map<String, String>>> queryWorkCalendarByTplIds(Map<Long, Long> tplIdWorkPlanIdMap) {
        ISWCAppCache appCache = SWCAppCache.get((String)APPCACHE_WORKPLAN);
        Map paramMap = (Map)appCache.get(APPCACHE_WORKPLAN, Map.class);
        if (paramMap != null) {
            for (Map.Entry<Long, Long> entry : tplIdWorkPlanIdMap.entrySet()) {
                List<Map<String, String>> mapList = (List<Map<String, String>>)paramMap.get(String.valueOf(entry.getKey()));
                if (mapList != null || entry.getValue() == 0L) continue;
                try {
                    mapList = WorkCalendarLoadService.loadThreeYearWorkCalendar(new Date(), entry.getValue());
                    paramMap.put(String.valueOf(entry.getKey()), mapList);
                }
                catch (Exception exc) {
                    logger.info("try catch for BT-01336870,due to metadata rebuild error.");
                }
            }
            appCache.put(APPCACHE_WORKPLAN, (Object)paramMap, 43200);
            return paramMap;
        }
        HashMap<String, List<Map<String, String>>> tplIdWorkPlansMap = new HashMap<String, List<Map<String, String>>>(tplIdWorkPlanIdMap.size());
        for (Map.Entry<Long, Long> entry : tplIdWorkPlanIdMap.entrySet()) {
            if (entry.getValue() == 0L) continue;
            try {
                List<Map<String, String>> mapList = WorkCalendarLoadService.loadThreeYearWorkCalendar(new Date(), entry.getValue());
                tplIdWorkPlansMap.put(String.valueOf(entry.getKey()), mapList);
            }
            catch (Exception exc) {
                logger.info("try catch for BT-01336870,due to metadata rebuild error.");
            }
        }
        appCache.put(APPCACHE_WORKPLAN, tplIdWorkPlansMap, 43200);
        return tplIdWorkPlansMap;
    }

    private boolean compareTwoLong(long curTime, long comPareLong, long wide) {
        if (curTime >= comPareLong) {
            return curTime - comPareLong <= wide;
        }
        return comPareLong - curTime <= wide;
    }
}

