/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class SalaryCalcStyleUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SalaryCalcStyleUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] salaryItemArray;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalcstyle");
        QFilter filter = new QFilter("issyspreset", "=", (Object)"1");
        for (DynamicObject dynamicObject : salaryItemArray = helper.query("id,status", new QFilter[]{filter})) {
            dynamicObject.set("status", (Object)"A");
        }
        helper.save(salaryItemArray);
        salaryItemArray = helper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salarycalcstyle"), new QFilter[]{filter});
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skipCheckDataPermission", "true");
        OperationResult result = opImpl.localInvokeOperation("submit", salaryItemArray, operateOption);
        for (DynamicObject salaryItem : salaryItemArray) {
            salaryItem.set("status", (Object)"C");
        }
        helper.save(salaryItemArray);
        if (result.isSuccess()) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
            scheduleManager.disableJob(taskInfo.getJobId());
            scheduleManager.disableSchedule(taskInfo.getScheduleId());
        } else {
            List list = result.getAllErrorOrValidateInfo();
            List<String> ids = list.stream().map(data -> data.getPkValue().toString()).collect(Collectors.toList());
            StringJoiner joiner = new StringJoiner("\u201d \u3001\u201c", "\u201c", "\u201d");
            ids.forEach(joiner::add);
            logger.info("error ids is :{0}", (Object)joiner.toString());
        }
    }
}

