/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;

public class WorkflowHelper {
    private static Log log = LogFactory.getLog(WorkflowHelper.class);
    private static String COMMA = ",";

    public static Map<String, String> getNextAuditors(List<String> pkIds) {
        if (pkIds != null && !pkIds.isEmpty()) {
            HashMap<String, String> auditorMap = new HashMap<String, String>(pkIds.size());
            String[] ids = new String[pkIds.size()];
            pkIds.toArray(ids);
            Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
            for (Map.Entry entry : allPro.entrySet()) {
                List node = (List)entry.getValue();
                String nodeName = "";
                StringBuilder participantName = new StringBuilder();
                StringBuilder msg = new StringBuilder();
                try {
                    for (BizProcessStatus e : node) {
                        nodeName = e.getCurrentNodeName();
                        String auditor = e.getParticipantName();
                        e.getProcessStatus();
                        if (auditor == null || "".equals(auditor.trim())) continue;
                        participantName.append(COMMA);
                        participantName.append(auditor);
                    }
                    if (!StringUtils.isBlank((CharSequence)nodeName)) {
                        msg.append(nodeName);
                        if (!StringUtils.isBlank((CharSequence)participantName)) {
                            msg.append('/');
                            msg.append(participantName.toString().replaceFirst(COMMA, ""));
                        }
                    }
                }
                catch (Exception e) {
                    log.info("ApproveBillWorkFlowListPlugin>>>get auditor error: {}", (Object)e.getMessage());
                }
                auditorMap.put(entry.getKey().toString(), msg.toString());
            }
            return auditorMap;
        }
        return null;
    }
}

