/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.calperson;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.mservice.api.calperson.ICalPersonService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CalPersonService
implements ICalPersonService {
    private static final Log logger = LogFactory.getLog(CalPersonService.class);

    public Map<String, Object> getCalStatus(List<Long> calPersonIdList) {
        logger.info("getCalStatus start");
        HashMap<String, Object> response = new HashMap<String, Object>(3);
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            response.put("data", null);
            response.put("success", Boolean.FALSE);
            response.put("message", ResManager.loadKDString((String)"\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalPersonService_0", (String)"swc-hsas-mservice", (Object[])new Object[0]));
            return response;
        }
        try {
            Map<Long, Map<String, Object>> dataMap = this.getCalStatusMap(calPersonIdList);
            response.put("data", dataMap);
            response.put("success", Boolean.TRUE);
            response.put("message", null);
            logger.info("getCalStatus end");
            return response;
        }
        catch (Exception ex) {
            logger.error("getCalStatusMap error.", (Throwable)ex);
            response.put("data", null);
            response.put("success", Boolean.FALSE);
            response.put("message", ex.getMessage());
            return response;
        }
    }

    private Map<Long, Map<String, Object>> getCalStatusMap(List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id,calstatus";
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObjectCollection calPersonList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(calPersonList.size());
        HashMap<String, Object> tempMap = null;
        for (DynamicObject calPerson : calPersonList) {
            tempMap = new HashMap<String, Object>(2);
            tempMap.put("srcDataKey", calPerson.getLong("id"));
            tempMap.put("calStatus", calPerson.getString("calstatus"));
            dataMap.put(calPerson.getLong("id"), tempMap);
        }
        return dataMap;
    }
}

