/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.hismodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSynDataStatusServicerHelper;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusEntityDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusResponseBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.IHisSynDataStatusService;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.paysubject.PaySubjectLawHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class HSASHisSynDataStatusService
implements IHisSynDataStatusService {
    public static final Log LOGGER = LogFactory.getLog(HSASHisSynDataStatusService.class);

    public void beforeSyn(List<String> list) {
    }

    public void syn(List<String> list) {
        LOGGER.info("... HSASHisSynDataStatusService#syn execute ...");
    }

    public void synByBo(HisSyncStatusParamBo hisSyncStatusParamBo) {
        LOGGER.info("... HSASHisSynDataStatusService#synByBo execute begin ...");
        HrApiResponse response = HisSynDataStatusServicerHelper.synByBo((HisSyncStatusParamBo)hisSyncStatusParamBo);
        if (null == response || !response.isSuccess()) {
            LOGGER.info("... HSASHisSynDataStatusService#synByBo response error ...");
            return;
        }
        HisSyncStatusResponseBo hisSyncStatusResponseBo = (HisSyncStatusResponseBo)response.getData();
        if (null == hisSyncStatusResponseBo) {
            LOGGER.info("... HSASHisSynDataStatusService#synByBo response data is null! ...");
            return;
        }
        List hisSyncStatusEntityDataBoList = hisSyncStatusResponseBo.getHisSyncStatusEntityDataBoList();
        for (HisSyncStatusEntityDataBo entityDataBo : hisSyncStatusEntityDataBoList) {
            if (!"hsas_salaryfile".equals(entityDataBo.getEntityNumber())) continue;
            this.calPersonCert(entityDataBo.getBoIds());
        }
        for (HisSyncStatusEntityDataBo entityDataBo : hisSyncStatusEntityDataBoList) {
            if (!"hsbs_paysubject".equals(entityDataBo.getEntityNumber())) continue;
            this.relLawEntity(entityDataBo.getBoIds());
        }
        LOGGER.info("... HSASHisSynDataStatusService#synByBo execute finish ...");
    }

    public void afterSyn(List<String> list) {
    }

    private void calPersonCert(List<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("boid", "in", boIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObject[] salaryFiles = helper.query("person.personindexid", new QFilter[]{filter});
        Set personIndexIds = Arrays.stream(salaryFiles).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        PersonCertCommonHelper.calPersonCertByIndexId(new ArrayList(personIndexIds));
    }

    private void relLawEntity(List<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
        QFilter filter = new QFilter("boid", "in", boIds);
        filter.and("datastatus", "=", (Object)"1");
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        DynamicObject[] paySubjects = helper.query("lawentity,boid,sourcevid,bsed,bsled", new QFilter[]{filter});
        try {
            PaySubjectLawHelper.relLawEntityAfterHis((DynamicObject[])paySubjects, boIds);
        }
        catch (Exception e) {
            LOGGER.info("relLawEntity error :{}", (Object)e.getMessage());
        }
    }
}

