/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsas.common.dto.CalPersonDTO;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.collections.CollectionUtils;

public class ApproveBillUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ApproveBillUpdateService.class);
    public static final int DEFAULT_SIZE = 200;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("ApproveBillUpdateService begin.");
        String queryApproveBillSQL = "SELECT DISTINCT(T1.FID) FID FROM T_HSAS_APPROVEBILL T1 LEFT JOIN T_HSAS_APPROVEBILLTPL T2 ON T1.FAPPROVEBILLTPLID = T2.FID LEFT JOIN T_HSAS_APPROVESCHENT T3 ON T2.FID = T3.FID WHERE T1.FBILLSTATUS NOT IN ('E','F') AND T3.FREFERREPORT ='3'";
        ArrayList<Long> approveBillIdList = new ArrayList<Long>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryApproveBillSQL", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryApproveBillSQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long id = row.getLong("FID");
                approveBillIdList.add(id);
            }
        }
        logger.info("approveBillIdList is: {}", (Object)JSON.toJSONString(approveBillIdList));
        UpgradeResult result = new UpgradeResult();
        String deleteApproveBillEntrySQL = "DELETE FROM T_HSAS_APPROVEBILLENT T WHERE T.FID = ?";
        List partitionIdList = Lists.partition(approveBillIdList, (int)200);
        for (List partitionIds : partitionIdList) {
            Long approveBillId;
            StringBuilder queryPayDetailSql = this.buildPayDetailSql();
            int size = partitionIds.size();
            for (int i = 1; i < size; ++i) {
                queryPayDetailSql.append(", ?");
            }
            queryPayDetailSql.append(" ) ");
            ArrayList paramList = new ArrayList(10);
            paramList.addAll(partitionIds);
            Object[] params = paramList.toArray();
            ArrayList<CalPersonDTO> calPersonList = new ArrayList<CalPersonDTO>(10);
            DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryPayDetailSql", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryPayDetailSql.toString(), (Object[])params);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long payDetailId = row.getLong(0);
                Long calTableId = row.getLong(1);
                Long calPersonId = row.getLong(2);
                approveBillId = row.getLong(3);
                CalPersonDTO calPersonDTO = this.buildCalPersonDTO(payDetailId, calTableId, calPersonId, approveBillId);
                calPersonList.add(calPersonDTO);
            }
            if (CollectionUtils.isEmpty(calPersonList)) {
                return result;
            }
            Map<Long, List<CalPersonDTO>> calPersonGroupByApproveBillIdMap = calPersonList.stream().collect(Collectors.groupingBy(CalPersonDTO::getId));
            Iterator<Map.Entry<Long, List<CalPersonDTO>>> iterator = calPersonGroupByApproveBillIdMap.entrySet().iterator();
            ArrayList<Object[]> deleteParamList = null;
            while (iterator.hasNext()) {
                Map.Entry<Long, List<CalPersonDTO>> iteratorNext = iterator.next();
                approveBillId = iteratorNext.getKey();
                List<CalPersonDTO> calPersonDTOS = iteratorNext.getValue();
                logger.info("update start, approveBillId is: {}", (Object)approveBillId);
                deleteParamList = new ArrayList<Object[]>(1);
                deleteParamList.add(new Object[]{approveBillId});
                TXHandle txHandle = TX.required();
                Throwable throwable = null;
                try {
                    try {
                        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteApproveBillEntrySQL, deleteParamList);
                        SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)this.getInsertFieldSql(), this.getInsertPayDetailFieldParam(calPersonDTOS, approveBillId));
                    }
                    catch (Throwable e) {
                        txHandle.markRollback();
                        logger.error("update failed, approveBillId = {}", (Object)approveBillId, (Object)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txHandle == null) continue;
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    txHandle.close();
                }
            }
        }
        return result;
    }

    private CalPersonDTO buildCalPersonDTO(Long payDetailId, Long calTableId, Long calPersonId, Long approveBillId) {
        CalPersonDTO calPersonDTO = new CalPersonDTO();
        calPersonDTO.setId(approveBillId);
        calPersonDTO.setCalPersonId(calPersonId);
        calPersonDTO.setCalTableId(calTableId);
        calPersonDTO.setPayDetailId(payDetailId);
        return calPersonDTO;
    }

    private StringBuilder buildPayDetailSql() {
        StringBuilder queryPayDetailSql = new StringBuilder();
        queryPayDetailSql.append("SELECT ");
        queryPayDetailSql.append("T1.FID, T1.FCALTABLEID, T2.FCALPERSONID, T2.FAPPROVEBILLID ");
        queryPayDetailSql.append("FROM T_HSAS_PAYDETAIL T1 ");
        queryPayDetailSql.append("LEFT JOIN T_HSAS_PAYDETAIL_A T2 ON T1.FID = T2.FID ");
        queryPayDetailSql.append("WHERE T1.FABANDONEDSTATUS ='0' ");
        queryPayDetailSql.append("AND T2.FAPPROVEBILLID IN (?");
        return queryPayDetailSql;
    }

    private String getInsertFieldSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(" INSERT INTO ").append("T_HSAS_APPROVEBILLENT").append(" (FENTRYID,FID,FSEQ,FAUDITSTATUS,").append("FCALTABLEID,FPAYDETAILID,FCALPERSONID ) ").append(" VALUES ").append(" (?,?,?,?,?,?,?) ");
        return sb.toString();
    }

    private List<Object[]> getInsertPayDetailFieldParam(List<CalPersonDTO> calPersonList, Long fId) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(calPersonList.size());
        long[] ids = DB.genLongIds((String)"t_hsas_approvebillent", (int)calPersonList.size());
        int index = 0;
        int num = 0;
        for (CalPersonDTO calPersonDTO : calPersonList) {
            Object[] param = new Object[]{ids[index], fId, num++, Character.valueOf(' '), calPersonDTO.getCalTableId(), calPersonDTO.getPayDetailId(), calPersonDTO.getCalPersonId()};
            ++index;
            params.add(param);
        }
        return params;
    }
}

