/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;

public class BankOfferTPLUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BankOfferTPLUpdateService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String oldHeadRow;
        Long entryId;
        logger.info("BankOfferTPLUpdateService Begin");
        String queryBankOfferExcelTitleEntrySQL = "SELECT FENTRYID,FHEADROW FROM T_HSAS_BANKOFFERETENT";
        HashMap entryIdOldHeadRowMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList paramList = Lists.newArrayListWithCapacity((int)10);
        DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryBankOfferExcelTitleEntrySql", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryBankOfferExcelTitleEntrySQL, (Object[])new Object[0]);
        Object object = null;
        try {
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                entryId = row.getLong("FENTRYID");
                oldHeadRow = row.getString("FHEADROW");
                entryIdOldHeadRowMap.put(entryId, oldHeadRow);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dateSet != null) {
                if (object != null) {
                    try {
                        dateSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dateSet.close();
                }
            }
        }
        UpgradeResult result = new UpgradeResult();
        for (Map.Entry entry : entryIdOldHeadRowMap.entrySet()) {
            entryId = (Long)entry.getKey();
            oldHeadRow = (String)entry.getValue();
            String regEx = "[^0-9]";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(oldHeadRow);
            String newHeadRow = matcher.replaceAll("").trim();
            paramList.add(new Object[]{newHeadRow, entryId});
        }
        try (TXHandle txHandle = TX.required();){
            String string = "UPDATE T_HSAS_BANKOFFERETENT SET FHEADROW = ? WHERE FENTRYID = ?";
            if (!SWCListUtils.isEmpty((List)paramList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)string, (List)paramList);
            }
        }
        return result;
    }
}

