/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class BizDataCreatorUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BizDataCreatorUpdateService.class);
    private int batchCount = 500;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String querySql = "select distinct data.fid,log.fcreatorid from t_hsas_nonrecurbizdata data inner join t_hsas_attintegsumlog log\non data.fbatchnumber = log.fbatchversionid and log.foperationtype = '1' and data.fcreatorid = 0";
        String queryTotalSql = "select count(1) as total from t_hsas_nonrecurbizdata data inner join t_hsas_attintegsumlog log\non data.fbatchnumber = log.fbatchversionid and log.foperationtype = '1' and data.fcreatorid = 0";
        String updateSql = "update t_hsas_nonrecurbizdata set fcreatorid = ? where fid=?";
        int total = 0;
        try (DataSet totalDataSet = SWCDbUtil.queryDataSet((String)"BizDataCreatorUpdateTotal", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryTotalSql, null);){
            if (totalDataSet.hasNext()) {
                total = totalDataSet.next().getInteger(0);
            }
        }
        if (total == 0) {
            return result;
        }
        logger.info("total = {}", (Object)total);
        var11_11 = null;
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"BizDataCreatorUpdate", (DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, null);){
            HashMap oneBatch = Maps.newHashMapWithExpectedSize((int)this.batchCount);
            int rowNum = 0;
            while (dataSet.hasNext()) {
                ++rowNum;
                Row next = dataSet.next();
                Long id = next.getLong("fid");
                Long creatorId = next.getLong("fcreatorid");
                if (oneBatch.size() >= this.batchCount) continue;
                oneBatch.putIfAbsent(id, creatorId);
                if ((total > this.batchCount || rowNum != total) && oneBatch.size() != this.batchCount && rowNum != total) continue;
                logger.info("onebatch update count = {}", (Object)oneBatch.size());
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, this.formatParamList(oneBatch));
                oneBatch.clear();
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        return result;
    }

    private List<Object[]> formatParamList(HashMap<Long, Long> oneBatch) {
        ArrayList params = Lists.newArrayListWithExpectedSize((int)oneBatch.size());
        for (Map.Entry<Long, Long> entry : oneBatch.entrySet()) {
            params.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        return params;
    }
}

