/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CalRuleUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CalRuleUpdateService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashSet<Long> formulaBaseIdList = new HashSet<Long>(16);
        Map<Long, List<Long>> calRuleEntryMap = this.queryCalRuleEntryData(formulaBaseIdList);
        Map<Long, List<Long>> calItemGroupEntryMap = this.queryCalItemGroupEntryData(formulaBaseIdList);
        Map<Long, Long> formulaMap = this.queryFormulaData(formulaBaseIdList);
        UpgradeResult result = new UpgradeResult();
        if (formulaMap.size() == 0) {
            return result;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(calRuleEntryMap);
        logger.info("calRule data ==>{}", (Object)msg);
        msg.setLength(0);
        msg.append(calItemGroupEntryMap);
        logger.info("calItemGroup data ==>{}", (Object)msg);
        List<Object[]> calRuleParamList = this.getUpdataParamLst(calRuleEntryMap, formulaMap);
        List<Object[]> calGroupParamList = this.getUpdataParamLst(calItemGroupEntryMap, formulaMap);
        try (TXHandle txHandle = TX.required();){
            String calRuleSql = "UPDATE T_HSAS_CALRULEITEMENTRY SET FFORMULAID = ? WHERE FENTRYID = ?";
            String calGroupSql = "UPDATE T_HSAS_CALITEMGROUPENTRY SET FFORMULAID = ? WHERE FENTRYID = ?";
            if (!SWCListUtils.isEmpty(calRuleParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)calRuleSql, calRuleParamList);
            }
            if (!SWCListUtils.isEmpty(calGroupParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)calGroupSql, calGroupParamList);
            }
        }
        return result;
    }

    private List<Object[]> getUpdataParamLst(Map<Long, List<Long>> entryMap, Map<Long, Long> formulaMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        Long formulaId = null;
        for (Map.Entry<Long, List<Long>> entry : entryMap.entrySet()) {
            formulaId = formulaMap.get(entry.getKey());
            if (null == formulaId) continue;
            for (Long temp : entry.getValue()) {
                Object[] param = new Object[]{formulaId, temp};
                paramList.add(param);
            }
        }
        return paramList;
    }

    private Map<Long, List<Long>> queryCalRuleEntryData(Set<Long> formulaBaseIdList) {
        HashMap<Long, List<Long>> calRuleEntryMap = new HashMap<Long, List<Long>>(16);
        String sql = "SELECT FENTRYID,FFORMULAID FROM T_HSAS_CALRULEITEMENTRY";
        ArrayList<Long> tempList = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryCalRuleEntryDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long formulaId = row.getLong("FFORMULAID");
                if (formulaId == 0L) continue;
                tempList = (ArrayList<Long>)calRuleEntryMap.get(formulaId);
                if (tempList == null) {
                    tempList = new ArrayList<Long>(10);
                    calRuleEntryMap.put(formulaId, tempList);
                    formulaBaseIdList.add(formulaId);
                }
                tempList.add(row.getLong("FENTRYID"));
            }
        }
        return calRuleEntryMap;
    }

    private Map<Long, List<Long>> queryCalItemGroupEntryData(Set<Long> formulaBaseIdList) {
        HashMap<Long, List<Long>> calItemGroupEntryMap = new HashMap<Long, List<Long>>(16);
        String sql = "SELECT FENTRYID,FFORMULAID FROM T_HSAS_CALITEMGROUPENTRY";
        ArrayList<Long> tempList = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryCalItemGroupEntryDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long formulaId = row.getLong("FFORMULAID");
                if (formulaId == 0L) continue;
                tempList = (ArrayList<Long>)calItemGroupEntryMap.get(formulaId);
                if (tempList == null) {
                    tempList = new ArrayList<Long>(10);
                    calItemGroupEntryMap.put(formulaId, tempList);
                    formulaBaseIdList.add(formulaId);
                }
                tempList.add(row.getLong("FENTRYID"));
            }
        }
        return calItemGroupEntryMap;
    }

    private Map<Long, Long> queryFormulaData(Set<Long> formulaBaseIdList) {
        HashMap<Long, Long> formulaMap = new HashMap<Long, Long>(16);
        if (formulaBaseIdList.size() == 0) {
            return formulaMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FFORMULABASEID FROM T_HSAS_FORMULA WHERE FISCURRENTVERSION = '1' AND FFORMULABASEID IN (");
        sqlBuilder.append(this.join(formulaBaseIdList, ",")).append(')');
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryFormulaDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                formulaMap.put(row.getLong("FFORMULABASEID"), row.getLong("FID"));
            }
        }
        return formulaMap;
    }

    private String join(Set<Long> set, String str) {
        if (null == set || set.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Long temp : set) {
            result.append(temp).append(str);
        }
        return result.substring(0, result.length() - 1);
    }
}

