/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;

public class FormulaUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FormulaUpdateService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("FormulaUpdateService begin");
        HashMap<Long, Map<String, Object>> formulaBaseMap = new HashMap<Long, Map<String, Object>>(16);
        HashSet<Long> formulaBaseIdList = new HashSet<Long>(16);
        HashMap<Long, List<Map<String, String>>> formulaBaseOtherMap = new HashMap<Long, List<Map<String, String>>>(16);
        this.getFormulaBaseData(formulaBaseMap, formulaBaseIdList, formulaBaseOtherMap);
        Map<Long, List<Long>> formulaMap = this.getFormulaData(formulaBaseIdList);
        UpgradeResult result = new UpgradeResult();
        if (formulaMap.size() == 0) {
            logger.info("no formula data to upgrade");
            return result;
        }
        CalHelper.printLog((String)"formula upgrade data ==>", formulaMap);
        ArrayList formulaIdList = new ArrayList(10);
        formulaMap.values().forEach(obj -> formulaIdList.addAll(obj));
        ArrayList<Object[]> formulaUpdateParamList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(10);
        Object[] formulaUpdateParam = null;
        Map tempFormulaBaseMap = null;
        List tempList = null;
        for (Map.Entry<Long, List<Long>> entry : formulaMap.entrySet()) {
            tempFormulaBaseMap = (Map)formulaBaseMap.get(entry.getKey());
            if (tempFormulaBaseMap == null) continue;
            tempList = (List)formulaBaseOtherMap.get(entry.getKey());
            for (Long formulaId : entry.getValue()) {
                formulaUpdateParam = new Object[]{tempFormulaBaseMap.get("FNUMBER"), tempFormulaBaseMap.get("FNAME"), tempFormulaBaseMap.get("FORGID"), tempFormulaBaseMap.get("FUSEORGID"), tempFormulaBaseMap.get("FCREATEORGID"), tempFormulaBaseMap.get("FSALARYITEMID"), tempFormulaBaseMap.get("FAREATYPE"), tempFormulaBaseMap.get("FCOUNTRYID"), tempFormulaBaseMap.get("FDESCRIPTION"), tempFormulaBaseMap.get("FCTRLSTRATEGY"), formulaId};
                formulaUpdateParamList.add(formulaUpdateParam);
                this.addInsertSqlParam(tempList, formulaId, insertParamList);
            }
        }
        this.setInsertPK(insertParamList);
        String updateSql = "UPDATE T_HSAS_FORMULA SET FNUMBER = ?,FNAME = ?,FORGID = ?,FUSEORGID = ?,FCREATEORGID = ?,FSALARYITEMID = ?,FAREATYPE = ?,FCOUNTRYID = ?,FDESCRIPTION = ?,FCTRLSTRATEGY = ? WHERE FID = ?";
        String insertSql = "INSERT INTO T_HSAS_FORMULA_L(FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION) VALUES(?,?,?,?,?)";
        String deleteFormulalSql = "DELETE FROM T_HSAS_FORMULA_L WHERE FID = ?";
        String deleteFormulaASql = "DELETE FROM T_HSAS_FORMULA_A WHERE FID = ?";
        ArrayList delParamList = new ArrayList(formulaIdList.size());
        formulaIdList.stream().forEach(obj -> delParamList.add(new Object[]{obj}));
        try (TXHandle txHandle = TX.required();){
            if (!SWCListUtils.isEmpty(delParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteFormulalSql, delParamList);
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteFormulaASql, delParamList);
            }
            if (!SWCListUtils.isEmpty(formulaUpdateParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, formulaUpdateParamList);
            }
            if (!SWCListUtils.isEmpty(insertParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, insertParamList);
            }
            logger.info("FormulaUpdateService end");
        }
        return result;
    }

    private void addInsertSqlParam(List<Map<String, String>> formulaBaseList, Long formulaId, List<Object[]> insertParamList) {
        if (formulaBaseList == null || formulaBaseList.size() == 0) {
            return;
        }
        Object[] insertParam = null;
        for (Map<String, String> base : formulaBaseList) {
            insertParam = new Object[]{Character.valueOf(' '), formulaId, base.get("FLOCALEID"), base.get("FNAME"), base.get("FDESCRIPTION")};
            insertParamList.add(insertParam);
        }
    }

    private void setInsertPK(List<Object[]> paramList) {
        if (SWCListUtils.isEmpty(paramList)) {
            return;
        }
        int size = paramList.size();
        String[] ids = DB.genStringIds((String)"T_HSAS_FORMULA_L", (int)size);
        for (int index = 0; index < size; ++index) {
            String id = ids[index];
            Object[] param = paramList.get(index);
            param[0] = id;
        }
    }

    private Map<Long, List<Long>> getFormulaData(Set<Long> formulaBaseIdList) {
        HashMap<Long, List<Long>> formulaMap = new HashMap<Long, List<Long>>(16);
        if (formulaBaseIdList.size() == 0) {
            return formulaMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FFORMULABASEID FROM T_HSAS_FORMULA WHERE FFORMULABASEID IN (");
        sqlBuilder.append(this.join(formulaBaseIdList, ",")).append(')');
        ArrayList<Long> temp = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryFormulaService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                temp = (ArrayList<Long>)formulaMap.get(row.getLong("FFORMULABASEID"));
                if (null == temp) {
                    temp = new ArrayList<Long>(10);
                    formulaMap.put(row.getLong("FFORMULABASEID"), temp);
                }
                temp.add(row.getLong("FID"));
            }
        }
        return formulaMap;
    }

    private void getFormulaBaseData(Map<Long, Map<String, Object>> formulaBaseMap, Set<Long> formulaBaseIdList, Map<Long, List<Map<String, String>>> formulaBaseOtherMap) {
        String baseSql = "SELECT FID,FNUMBER,FNAME,FSALARYITEMID,FAREATYPE,FCOUNTRYID,FCREATEORGID,FUSEORGID,FORGID,FCTRLSTRATEGY,FDESCRIPTION FROM T_HSAS_FORMULABASE";
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryFormulaBaseService", (DBRoute)SWCConstants.SWC_ROUETE, (String)baseSql, (Object[])new Object[0]);){
            HashMap<String, Object> tempMap = null;
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                tempMap = new HashMap<String, Object>(14);
                tempMap.put("FNUMBER", row.getString("FNUMBER"));
                tempMap.put("FNAME", row.getString("FNAME") == null ? " " : row.getString("FNAME"));
                tempMap.put("FCTRLSTRATEGY", row.getString("FCTRLSTRATEGY"));
                tempMap.put("FAREATYPE", row.getString("FAREATYPE"));
                tempMap.put("FDESCRIPTION", row.getString("FDESCRIPTION") == null ? " " : row.getString("FDESCRIPTION"));
                tempMap.put("FSALARYITEMID", row.getLong("FSALARYITEMID"));
                if (row.getLong("FCOUNTRYID") == null) {
                    tempMap.put("FCOUNTRYID", 0L);
                } else {
                    tempMap.put("FCOUNTRYID", row.getLong("FCOUNTRYID"));
                }
                tempMap.put("FCREATEORGID", row.getLong("FCREATEORGID"));
                tempMap.put("FUSEORGID", row.getLong("FUSEORGID"));
                tempMap.put("FORGID", row.getLong("FORGID"));
                formulaBaseMap.put(row.getLong("FID"), tempMap);
                formulaBaseIdList.add(row.getLong("FID"));
            }
        }
        if (formulaBaseIdList.size() == 0) {
            return;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FLOCALEID,FNAME,FDESCRIPTION FROM T_HSAS_FORMULABASE_L WHERE FID IN (");
        sqlBuilder.append(this.join(formulaBaseIdList, ",")).append(')');
        List<Map<String, String>> tempList = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryFormulaBaseNameService", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            HashMap<String, String> temp = null;
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                tempList = formulaBaseOtherMap.get(row.getLong("FID"));
                if (null == tempList) {
                    tempList = new ArrayList<Map<String, String>>(10);
                    formulaBaseOtherMap.put(row.getLong("FID"), tempList);
                }
                temp = new HashMap<String, String>(3);
                temp.put("FLOCALEID", row.getString("FLOCALEID"));
                temp.put("FNAME", row.getString("FNAME"));
                temp.put("FDESCRIPTION", row.getString("FDESCRIPTION") == null ? " " : row.getString("FDESCRIPTION"));
                tempList.add(temp);
            }
        }
    }

    private String join(Set<Long> set, String str) {
        if (null == set || set.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Long temp : set) {
            result.append(temp).append(str);
        }
        return result.substring(0, result.length() - 1);
    }
}

