/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.mservice.update;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResultCheckDataUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ResultCheckDataUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info("ResultCheckDataUpgradeService begin");
        HashSet<Long> calRuleIdList = new HashSet<Long>(16);
        HashMap<Long, Long> fidMap = new HashMap<Long, Long>(16);
        Map<Long, Set<Long>> existSchemeMap = this.assembleExistSchemeMap();
        Map<Long, Map<Long, Map<String, Object>>> groupInfoMap = this.assembleGroupSceneMap(existSchemeMap, calRuleIdList, fidMap);
        HashMap<Long, Map<String, Object>> ruleMap = new HashMap<Long, Map<String, Object>>(16);
        if (calRuleIdList.size() > 0) {
            this.assembleCalRuleMap(ruleMap, calRuleIdList);
        }
        List<Object[]> checkSchemeData = this.assembleCheckSchemeData(groupInfoMap);
        log.info("checkSchemeData.size:{}", (Object)checkSchemeData.size());
        List<Object[]> itemEntityData = this.assembleItemEntityData(ruleMap, fidMap);
        log.info("itemEntityData.size:{}", (Object)itemEntityData.size());
        List<Object[]> checkSchemeLData = this.assembleCheckSchemeLData(fidMap, groupInfoMap);
        String insertCheckSchemeSql = "insert into t_hsas_retcheckscheme(fid,fnumber,fname,fstatus,fpayrollgroupid ,fpayrollsceneid ,fchaingrowth ,fchangestatus ,fcreatetime,fmodifytime,fmodifierid,fenable,forgid ,fcreatorid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String insertEntrySql = "insert into T_HSAS_CHECKITEMENTRY(fentryid,fid,fseq ,fitemid,fitemname,fitemnumber,fitemtype,fworkbenchshow,fvalueequals,fvalueless) values(?,?,?,?,?,?,?,?,?,?)";
        String insertCheckSchemeLSql = "insert into t_hsas_retcheckscheme_l(fpkid,flocaleid,fid,fname,fsimplename,fdescription) values(?,?,?,?,?,?)";
        try (TXHandle txHandle = TX.required();){
            if (!SWCListUtils.isEmpty(checkSchemeData)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertCheckSchemeSql, checkSchemeData);
            }
            if (!SWCListUtils.isEmpty(itemEntityData)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertEntrySql, itemEntityData);
            }
            if (!SWCListUtils.isEmpty(checkSchemeLData)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertCheckSchemeLSql, checkSchemeLData);
            }
            log.info("ResultCheckDataUpgradeService end");
        }
        return null;
    }

    private List<Object[]> assembleCheckSchemeLData(Map<Long, Long> fidMap, Map<Long, Map<Long, Map<String, Object>>> groupInfoMap) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        if (fidMap.size() == 0) {
            return dataList;
        }
        String[] checkSchemeLIds = DB.genStringIds((String)"t_hsas_retcheckscheme_l", (int)(fidMap.size() * 2));
        int index = 0;
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : groupInfoMap.entrySet()) {
            Map<Long, Map<String, Object>> groupMap = entry.getValue();
            for (Map.Entry<Long, Map<String, Object>> sceneEntry : groupMap.entrySet()) {
                Map<String, Object> sceneMap = sceneEntry.getValue();
                Object fid = sceneMap.get("fid");
                String nameStr = sceneMap.get("groupName") + sceneMap.get("sceneName") + ResManager.loadKDString((String)"\u68c0\u6838\u65b9\u6848", (String)"ResultCheckDataUpgradeService_1", (String)"swc-hsas-mservice", (Object[])new Object[0]);
                String name = nameStr.length() < 200 ? nameStr : nameStr.substring(0, 200);
                Object[] insertParam = new Object[]{checkSchemeLIds[index++], "zh_CN", fid, name, " ", " "};
                dataList.add(insertParam);
            }
        }
        return dataList;
    }

    private List<Object[]> assembleItemEntityData(Map<Long, Map<String, Object>> ruleMap, Map<Long, Long> fidMap) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        if (ruleMap.size() == 0) {
            return dataList;
        }
        long[] checkItemEntryIds = DB.genLongIds((String)"t_hsas_checkitementry", (int)(fidMap.size() * 2));
        int index = 0;
        for (Map.Entry<Long, Long> entry : fidMap.entrySet()) {
            Object[] insertParam;
            Long fid = entry.getKey();
            Long ruleId = entry.getValue();
            Map<String, Object> map = ruleMap.get(ruleId);
            Object totalsalaryId = map.get("totalsalaryId");
            Object netsalaryId = map.get("netsalaryId");
            if (totalsalaryId != null && Long.parseLong(totalsalaryId + "") > 0L) {
                long fentryId1 = checkItemEntryIds[index++];
                insertParam = new Object[]{fentryId1, fid, 1, totalsalaryId, map.get("totalsalaryName"), map.get("totalsalaryNumber"), "SL", "1", "0", "0"};
                dataList.add(insertParam);
            }
            if (netsalaryId == null || Long.parseLong(netsalaryId + "") <= 0L) continue;
            long fentryId2 = checkItemEntryIds[index++];
            insertParam = new Object[]{fentryId2, fid, 2, netsalaryId, map.get("netsalaryName"), map.get("netsalaryNumber"), "SL", "1", "0", "0"};
            dataList.add(insertParam);
        }
        return dataList;
    }

    private List<Object[]> assembleCheckSchemeData(Map<Long, Map<Long, Map<String, Object>>> groupInfoMap) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        if (groupInfoMap.size() == 0) {
            return dataList;
        }
        Date now = new Date();
        long userId = RequestContext.get().getCurrUserId();
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : groupInfoMap.entrySet()) {
            Long groupId = entry.getKey();
            Map<Long, Map<String, Object>> groupMap = entry.getValue();
            for (Map.Entry<Long, Map<String, Object>> sceneEntry : groupMap.entrySet()) {
                Long sceneId = sceneEntry.getKey();
                Map<String, Object> sceneMap = sceneEntry.getValue();
                Object fid = sceneMap.get("fid");
                Object orgId = sceneMap.get("orgId");
                String numberStr = "" + sceneMap.get("groupNumber") + sceneMap.get("sceneNumber");
                String nameStr = sceneMap.get("groupName") + sceneMap.get("sceneName") + ResManager.loadKDString((String)"\u68c0\u6838\u65b9\u6848", (String)"ResultCheckDataUpgradeService_1", (String)"swc-hsas-mservice", (Object[])new Object[0]);
                String number = numberStr.length() < 120 ? numberStr : numberStr.substring(0, 120);
                String name = nameStr.length() < 200 ? nameStr : nameStr.substring(0, 200);
                Object[] insertParam = new Object[]{fid, number, name, "C", groupId, sceneId, "1", "0", now, now, userId, "1", orgId, userId};
                dataList.add(insertParam);
            }
        }
        return dataList;
    }

    private void assembleCalRuleMap(Map<Long, Map<String, Object>> ruleMap, Set<Long> calRuleIdList) {
        Map itemMap;
        Long ruleId;
        Row row;
        StringBuilder sqlSb1 = new StringBuilder();
        StringBuilder sqlSb2 = new StringBuilder();
        String ruleIds = StringUtils.join((Object[])calRuleIdList.toArray(), (String)",");
        sqlSb1.append("select calrule.fid ruleid, calrule.ftotalsalary totalsalaryid,item.fnumber totalsalarynumber,item.fname totalsalaryname\nfrom t_hsas_calrule calrule\nleft join t_hsbs_salaryitem item on calrule.ftotalsalary = item.fid \nwhere calrule.fid in(");
        sqlSb1.append(ruleIds).append(')');
        sqlSb2.append("select calrule.fid ruleid, calrule.fnetsalary netsalaryid,item.fnumber netsalarynumber,item.fname netsalaryname\nfrom t_hsas_calrule calrule\nleft join t_hsbs_salaryitem item on calrule.fnetsalary = item.fid \nwhere calrule.fid in(");
        sqlSb2.append(ruleIds).append(')');
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryRuleInfo", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlSb1.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                row = dateSet.next();
                ruleId = row.getLong("ruleid");
                itemMap = ruleMap.computeIfAbsent(ruleId, value -> new HashMap(16));
                itemMap.put("ruleId", ruleId);
                itemMap.put("totalsalaryNumber", row.getString("totalsalarynumber"));
                itemMap.put("totalsalaryName", row.getString("totalsalaryname"));
                itemMap.put("totalsalaryId", row.getLong("totalsalaryid"));
            }
        }
        dateSet = SWCDbUtil.queryDataSet((String)"queryRuleInfo", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlSb2.toString(), (Object[])new Object[0]);
        var7_7 = null;
        try {
            while (dateSet.hasNext()) {
                row = dateSet.next();
                ruleId = row.getLong("ruleid");
                itemMap = ruleMap.computeIfAbsent(ruleId, value -> new HashMap(16));
                itemMap.put("ruleId", ruleId);
                itemMap.put("netsalaryNumber", row.getString("netsalarynumber"));
                itemMap.put("netsalaryName", row.getString("netsalaryname"));
                itemMap.put("netsalaryId", row.getLong("netsalaryid"));
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (dateSet != null) {
                if (var7_7 != null) {
                    try {
                        dateSet.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    dateSet.close();
                }
            }
        }
    }

    private Map<Long, Set<Long>> assembleExistSchemeMap() {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
        String sql = "select fpayrollgroupid groupid,fpayrollsceneid sceneid from t_hsas_retcheckscheme";
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryExistScheme", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long groupId = row.getLong("groupid");
                Set sceneList = map.computeIfAbsent(groupId, value -> new HashSet(16));
                sceneList.add(row.getLong("sceneid"));
            }
        }
        return map;
    }

    private Map<Long, Map<Long, Map<String, Object>>> assembleGroupSceneMap(Map<Long, Set<Long>> existSchemeMap, Set<Long> calRuleIdList, Map<Long, Long> fidMap) {
        HashMap<Long, Map<Long, Map<String, Object>>> dataMap = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        String sql = "select tgroup.fid groupid,tgroup.fnumber groupnumber,tgroup.fname groupname,tgroup.forgid orgid,tscene.fid sceneid,tscene.fnumber scenenumber,tscene.fname scenename,tscene.fcalruleid calruleid\nfrom t_hsas_payrollgrp tgroup\nleft join t_hsas_payrollgrpsc tgroupent on tgroup.fid = tgroupent.fid\nleft join t_hsas_payrollscene tscene on tgroupent.fpayrollsceneid  = tscene.fid\nwhere tgroup.fstatus = 'C' and tgroup.fenable ='1' and tscene.fstatus ='C' and tscene.fenable ='1' and tgroup.fiscurrentversion = '1' and tscene.fiscurrentversion = '1'";
        String countSql = "select count(1) cnt from t_hsas_payrollgrp tgroup\nleft join t_hsas_payrollgrpsc tgroupent on tgroup.fid = tgroupent.fid\nleft join t_hsas_payrollscene tscene on tgroupent.fpayrollsceneid  = tscene.fid\nwhere tgroup.fstatus = 'C' and tscene.fstatus ='C' and tgroup.fiscurrentversion = '1' and tscene.fiscurrentversion = '1'";
        Integer dataCnt = 0;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryGroupSceneData", (DBRoute)SWCConstants.SWC_ROUETE, (String)countSql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                dataCnt = row.getInteger("cnt");
            }
        }
        if (dataCnt == 0) {
            return dataMap;
        }
        long[] checkSchemeIds = DB.genLongIds((String)"t_hsas_retcheckscheme", (int)dataCnt);
        int index = 0;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryGroupSceneData", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long groupId = row.getLong("groupid");
                Long sceneId = row.getLong("sceneid");
                Long calRuleId = row.getLong("calruleid");
                Map groupMap = dataMap.computeIfAbsent(groupId, value -> new HashMap(16));
                Set<Long> existSceneSet = existSchemeMap.get(groupId);
                if (groupMap.containsKey(sceneId) || !CollectionUtils.isEmpty(existSceneSet) && existSceneSet.contains(sceneId)) continue;
                HashMap<String, Object> sceneMap = new HashMap<String, Object>(16);
                long fid = checkSchemeIds[index];
                sceneMap.put("groupId", groupId);
                sceneMap.put("groupNumber", row.getString("groupnumber"));
                sceneMap.put("groupName", row.getString("groupname"));
                sceneMap.put("orgId", row.getLong("orgid"));
                sceneMap.put("sceneId", sceneId);
                sceneMap.put("sceneNumber", row.getString("scenenumber"));
                sceneMap.put("sceneName", row.getString("scenename"));
                sceneMap.put("calRuleId", calRuleId);
                sceneMap.put("fid", fid);
                fidMap.put(fid, calRuleId);
                groupMap.put(sceneId, sceneMap);
                calRuleIdList.add(calRuleId);
                ++index;
            }
        }
        return dataMap;
    }
}

