/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.accresult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsas.business.accumulator.AccResultCheckService;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AccResultDeleteValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        HashSet<Long> accResultIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : this.dataEntities) {
            accResultIdSet.add(entity.getDataEntity().getLong("id"));
        }
        AccResultCheckService checkService = new AccResultCheckService();
        Map accDetailMap = checkService.getAccDetailMapByAccResultId(accResultIdSet);
        HashMap<Long, Map<String, Long>> personIndexMap = new HashMap<Long, Map<String, Long>>(16);
        HashMap<String, Long> tempMap = null;
        DynamicObject accResult = null;
        ArrayList<ExtendedDataEntity> succDataList = new ArrayList<ExtendedDataEntity>(10);
        List tempList = null;
        for (ExtendedDataEntity entity : this.dataEntities) {
            accResult = entity.getDataEntity();
            tempList = (List)accDetailMap.get(accResult.getLong("id"));
            if (!SWCListUtils.isEmpty((List)tempList)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f53\u524d\u7d2f\u52a0\u7ed3\u679c\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u901a\u8fc7\u85aa\u8d44\u6838\u7b97\u751f\u6210\u7684\u7d2f\u52a0\u660e\u7ec6\u7ed3\u679c\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AccResultDeleteValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            tempMap = new HashMap<String, Long>(2);
            tempMap.put("employee", accResult.getLong("employee.id"));
            tempMap.put("salaryfile", accResult.getLong("salaryfile.id"));
            personIndexMap.put(accResult.getLong("personindexid"), tempMap);
            succDataList.add(entity);
        }
        if (succDataList.size() == 0) {
            return;
        }
        this.checkAndAddSalaryCalMutexData(personIndexMap, succDataList);
    }

    private void checkAndAddSalaryCalMutexData(Map<Long, Map<String, Long>> personIndexMap, List<ExtendedDataEntity> succDataList) {
        HashMap errorDataMap = new HashMap(personIndexMap.size());
        AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
        AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorDataMap, (String)"3");
        if (errorDataMap.size() == 0) {
            return;
        }
        for (ExtendedDataEntity entity : succDataList) {
            DynamicObject tempObj = entity.getDataEntity();
            String msg = (String)errorDataMap.get(tempObj.getLong("personindexid"));
            if (!SWCStringUtils.isNotEmpty((String)msg)) continue;
            this.addErrorMessage(entity, msg);
        }
    }
}

