/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.accresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AccResultSaveValidator
extends SWCDataBaseValidator {
    private static final String CONNECTOR = "@;@";

    public void validate() {
        super.validate();
        DynamicObject obj = null;
        ArrayList<Long> accIdList = new ArrayList<Long>(10);
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        ArrayList<Long> fileIdList = new ArrayList<Long>(10);
        ArrayList<ExtendedDataEntity> checkPassList = new ArrayList<ExtendedDataEntity>(10);
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            obj = dataEntity.getDataEntity();
            boolean isCheckPass = this.checkAccResultData(dataEntity, obj);
            if (!isCheckPass) continue;
            accIdList.add(obj.getLong("acc.id"));
            personIdList.add(obj.getLong("employee.id"));
            fileIdList.add(obj.getLong("salaryfile.id"));
            checkPassList.add(dataEntity);
            personIdSet.add(obj.getLong("employee.person.id"));
        }
        Map<Long, Long> personHrMap = this.getPersonHrMap(personIdSet);
        Map<String, List<DynamicObject>> accResultMap = this.getExistAccResultMap(accIdList, personIdList, fileIdList, personHrMap);
        HashMap<Long, Map<String, Long>> personIndexMap = new HashMap<Long, Map<String, Long>>(16);
        ArrayList<ExtendedDataEntity> succDataList = new ArrayList<ExtendedDataEntity>(10);
        this.checkAccResultIsExist(checkPassList, accResultMap, personIndexMap, succDataList, personHrMap);
        if (succDataList.size() > 0) {
            this.checkAndAddSalaryCalMutexData(personIndexMap, succDataList);
        }
    }

    private Map<Long, Long> getPersonHrMap(Set<Long> personIdSet) {
        DynamicObject[] data;
        if (personIdSet.size() == 0) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> personHrMap = new HashMap<Long, Long>(personIdSet.size());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_personhr");
        for (DynamicObject temp : data = serviceHelper.queryOriginalArray("id,personindexid", new QFilter[]{new QFilter("id", "in", personIdSet)})) {
            personHrMap.put(temp.getLong("id"), temp.getLong("personindexid"));
        }
        return personHrMap;
    }

    private void checkAndAddSalaryCalMutexData(Map<Long, Map<String, Long>> personIndexMap, List<ExtendedDataEntity> succDataList) {
        HashMap errorDataMap = new HashMap(personIndexMap.size());
        AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
        AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorDataMap, (String)"3");
        if (errorDataMap.size() == 0) {
            return;
        }
        for (ExtendedDataEntity entity : succDataList) {
            DynamicObject tempObj = entity.getDataEntity();
            String msg = (String)errorDataMap.get(tempObj.getLong("personindexid"));
            if (!SWCStringUtils.isNotEmpty((String)msg)) continue;
            this.addErrorMessage(entity, msg);
        }
    }

    private void checkAccResultIsExist(List<ExtendedDataEntity> checkPassList, Map<String, List<DynamicObject>> accResultMap, Map<Long, Map<String, Long>> personIndexMap, List<ExtendedDataEntity> succDataList, Map<Long, Long> personHrMap) {
        DynamicObject obj = null;
        List<DynamicObject> tempList = null;
        HashMap<String, Long> tempMap = null;
        Long personIndexId = null;
        for (ExtendedDataEntity entity : checkPassList) {
            obj = entity.getDataEntity();
            tempList = accResultMap.get(obj.getLong("employee.id") + CONNECTOR + obj.getLong("salaryfile.id") + CONNECTOR + obj.getLong("acc.id"));
            if (tempList != null && tempList.size() > 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u548c\u7d2f\u52a0\u5668\u5df2\u5b58\u5728\u76f8\u540c\u5b9e\u4f8b\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"AccResultSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            personIndexId = personHrMap.get(obj.getLong("employee.person.id"));
            if (personIndexId == null) {
                personIndexId = 0L;
            }
            obj.set("personindexid", (Object)personIndexId);
            tempMap = new HashMap<String, Long>(2);
            tempMap.put("employee", obj.getLong("employee.id"));
            tempMap.put("salaryfile", obj.getLong("salaryfile.id"));
            personIndexMap.put(personIndexId, tempMap);
            succDataList.add(entity);
        }
    }

    private Map<String, List<DynamicObject>> getExistAccResultMap(List<Long> accIdList, List<Long> personIdList, List<Long> fileIdList, Map<Long, Long> personHrMap) {
        if (accIdList.size() == 0) {
            return new HashMap<String, List<DynamicObject>>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String fields = "id,employee.id,salaryfile.id,acc.id,resultvalue";
        QFilter qFilter = new QFilter("employee.id", "in", personIdList);
        qFilter.and("personindexid", "in", personHrMap.values());
        qFilter.and("acc.id", "in", accIdList);
        qFilter.and("salaryfile.id", "in", fileIdList);
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        return result.stream().collect(Collectors.groupingBy(obj -> obj.getLong("employee.id") + CONNECTOR + obj.getLong("salaryfile.id") + CONNECTOR + obj.getLong("acc.id")));
    }

    private boolean checkAccResultData(ExtendedDataEntity dataEntity, DynamicObject obj) {
        Date startDate;
        long dataTypeId;
        BigDecimal resultValue = obj.getBigDecimal("resultvalue");
        if (resultValue == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u679c\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject accObj = obj.getDynamicObject("acc");
        String accDimension = accObj.getString("accdimension");
        if ("2".equals(accDimension)) {
            if (obj.getDynamicObject("salaryfile") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            obj.set("salaryfile", (Object)0L);
        }
        if (1020L == (dataTypeId = accObj.getLong("datatype.id"))) {
            if (obj.getDynamicObject("currency") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            obj.set("currency", (Object)0L);
        }
        if ((startDate = obj.getDate("startdate")) == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"AccResultSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return false;
        }
        String periodType = accObj.getString("periodtype");
        int startDay = accObj.getInt("startday");
        Calendar tempCal = Calendar.getInstance();
        if ("4".equals(periodType)) {
            if (!"2".equals(accObj.getString("startdatetype"))) {
                Date accStartDate = accObj.getDate("startdate");
                if (!SWCStringUtils.equals((String)SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), (String)SWCDateTimeUtils.format((Date)accStartDate, (String)"yyyy-MM-dd"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u8bf7\u4e0e\u7d2f\u52a0\u5668\u7684\u201c\u5f00\u59cb\u6708/\u5f00\u59cb\u65e5/\u5f00\u59cb\u65e5\u671f\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccResultSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        } else if ("1".equals(periodType) || "2".equals(periodType)) {
            tempCal.setTime(startDate);
            int startMonth = Integer.parseInt(accObj.getString("startmonth")) - 1;
            if (tempCal.get(2) != startMonth || tempCal.get(5) != startDay) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u8bf7\u4e0e\u7d2f\u52a0\u5668\u7684\u201c\u5f00\u59cb\u6708/\u5f00\u59cb\u65e5/\u5f00\u59cb\u65e5\u671f\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccResultSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            tempCal.setTime(startDate);
            if (tempCal.get(5) != startDay) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u201d\u8bf7\u4e0e\u7d2f\u52a0\u5668\u7684\u201c\u5f00\u59cb\u6708/\u5f00\u59cb\u65e5/\u5f00\u59cb\u65e5\u671f\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccResultSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

