/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.accumulator;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AccumulatorSubmitValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection accMemberEntry = data.getDynamicObjectCollection("accmemberentry");
            if (accMemberEntry.size() <= 0) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u4e2a\u7d2f\u52a0\u6210\u5458\u540e\u518d\u63d0\u4ea4\u3002", (String)"AccumulatorSubmitValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
            String name = data.getString("name");
            this.checkFieldaliasIllegal(dataEntity, name);
            this.checkStartDateAndEndDate(dataEntity, accMemberEntry);
            this.checkAccMemItem(dataEntity, data);
        }
    }

    private void checkStartDateAndEndDate(ExtendedDataEntity dataEntity, DynamicObjectCollection accMemberEntry) {
        for (DynamicObject entry : accMemberEntry) {
            Date startDate = entry.getDate("accmemstartdate");
            Date endDate = entry.getDate("accmemenddate");
            if (endDate == null || !startDate.after(endDate)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccumulatorSubmitValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkFieldaliasIllegal(ExtendedDataEntity dataEntity, String name) {
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"AccumulatorSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkAccMemItem(ExtendedDataEntity dataEntity, DynamicObject data) {
        DynamicObjectCollection accMemEntrys = data.getDynamicObjectCollection("accmemberentry");
        for (DynamicObject entry : accMemEntrys) {
            String memberType = entry.getString("membertype");
            if (SWCStringUtils.equals((String)"2", (String)memberType)) {
                DynamicObject bizItem = entry.getDynamicObject("bizitem");
                if (!SWCObjectUtils.isEmpty((Object)bizItem)) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject salaryItem = entry.getDynamicObject("salaryitem");
            if (!SWCObjectUtils.isEmpty((Object)salaryItem)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }
}

