/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.agencypay;

import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.agencypay.AgencyPayHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AgencyPaySaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
            DynamicObject data = entity.getDataEntity();
            DynamicObjectCollection ents = data.getDynamicObjectCollection("entryentity");
            if (ents == null || ents.isEmpty()) {
                String content = ResManager.loadKDString((String)"\u4ee3\u53d1\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgencyPaySaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, content);
                continue;
            }
            HashSet<Long> detailIds = new HashSet<Long>(ents.size());
            for (DynamicObject ent : ents) {
                detailIds.add(ent.getLong("paydetail.id"));
            }
            long billId = data.getLong("id");
            long payrollGroupId = data.getLong("payrollgrp.id");
            long orgId = data.getLong("org.id");
            QFilter filter = AgencyPayHelper.getQFilter((long)billId, detailIds, (long)payrollGroupId, (long)orgId);
            QFilter billIdFilter = new QFilter("agencypaybill.id", "=", (Object)billId);
            filter.or(billIdFilter);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            DynamicObjectCollection detailDys = helper.queryOriginalCollection("id", filter.toArray());
            HashSet<Long> enableDetailIds = new HashSet<Long>(detailDys.size());
            for (DynamicObject detailDy : detailDys) {
                enableDetailIds.add(detailDy.getLong("id"));
            }
            int index = 1;
            for (DynamicObject ent : ents) {
                if (!enableDetailIds.contains(ent.getLong("paydetail.id"))) {
                    String content = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4ee3\u53d1\u5206\u5f55\u7b2c%s\u884c\uff1a\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u7b26\u5408\u6dfb\u52a0\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u8c03\u6574\u3002", (String)"AgencyPaySaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), index);
                    this.addErrorMessage(entity, content);
                }
                ++index;
            }
        }
    }
}

