/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.agencypay;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.common.enums.PaydetailCreateErrorEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaydetailCreateBillValitor
extends AbstractValidator {
    public void setAddBillNoForContent(boolean addBillNoForContent) {
        super.setAddBillNoForContent(false);
    }

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String paystate = dataEntity.getString("paystate");
            String agencypaystate = dataEntity.getString("agencypaystate");
            String bankOfferStatus = dataEntity.getString("bankofferstatus");
            String cashintergration = dataEntity.getString("paysubjecthis.cashintergration");
            String onHoldStatus = dataEntity.getString("onholdstatus");
            boolean isNeedBankCard = dataEntity.getBoolean("ismustbankcard") ^ dataEntity.getLong("perbankcard.id") != 0L;
            boolean detailAbandonStatus = dataEntity.getBoolean("abandonedstatus");
            String salaryFileNumber = dataEntity.getString("salaryfilehis.number");
            String modifyBillStatus = dataEntity.getString("acctmodifybill.billstatus");
            if (SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())) || detailAbandonStatus) {
                this.addFatalErrorMessage(extendedDataEntity, PaydetailCreateErrorEnum.ABANDON.getDescString(salaryFileNumber));
                continue;
            }
            if (SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())) || SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()))) {
                this.addFatalErrorMessage(extendedDataEntity, PaydetailCreateErrorEnum.STOPPAY.getDescString(salaryFileNumber));
                continue;
            }
            if (!(SWCStringUtils.equals((String)paystate, (String)PayStateEnum.UNPAY.getCode()) && SWCStringUtils.equals((String)agencypaystate, (String)AgencyPayStateEnum.NOT_GENERATE.getCode()) && BankOfferEnum.getBankOfferArray().contains(bankOfferStatus) || SWCStringUtils.equals((String)paystate, (String)PayStateEnum.PAYFAIL.getCode()))) {
                this.addFatalErrorMessage(extendedDataEntity, PaydetailCreateErrorEnum.NOT_UNPAY.getDescString(salaryFileNumber));
                continue;
            }
            if (SWCStringUtils.isEmpty((String)cashintergration)) {
                this.addFatalErrorMessage(extendedDataEntity, PaydetailCreateErrorEnum.NO_CASHINTERGRATION.getDescString(salaryFileNumber));
                continue;
            }
            if (isNeedBankCard) {
                this.addFatalErrorMessage(extendedDataEntity, PaydetailCreateErrorEnum.NO_BANKCARD.getDescString(salaryFileNumber));
                continue;
            }
            if (!SWCStringUtils.isNotEmpty((String)modifyBillStatus) || "E".equals(modifyBillStatus)) continue;
            this.addFatalErrorMessage(extendedDataEntity, PaydetailCreateErrorEnum.ACCT_MODIFY.getDescString(salaryFileNumber));
        }
    }
}

