/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.approvebill;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.common.enums.ApproveBillOperationEnum;

public class CalApproveBillPermValidator
extends AbstractValidator {
    public final Log LOGGER = LogFactory.getLog(CalApproveBillPermValidator.class);

    public void validate() {
        if (this.getOption().tryGetVariableValue("skipCheckDataPermission", new RefObject()) && Boolean.parseBoolean(this.getOption().getVariableValue("skipCheckDataPermission"))) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        ArrayList<Long> approveBillIds = new ArrayList<Long>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject approveBill = extendedDataEntity.getDataEntity();
            approveBillIds.add(approveBill.getLong("id"));
        }
        String operateKey = this.getOperateKey();
        ApproveBillOperationEnum approveBillOperationEnum = ApproveBillOperationEnum.getApproveBillOperationEnum((String)operateKey);
        if (approveBillOperationEnum == null) {
            this.LOGGER.error("unknown operateKey\uff1a{}", (Object)operateKey);
            return;
        }
        Map approveBillGrpPermMaps = HSASCalApproveBillHelper.validateGrpPerm((String)approveBillOperationEnum.getPermItemId(), approveBillIds);
        if (approveBillGrpPermMaps == null) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject approveBill = extendedDataEntity.getDataEntity();
            long approveBillId = approveBill.getLong("id");
            if (((Boolean)approveBillGrpPermMaps.get(approveBillId)).booleanValue()) continue;
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u60a8\u4ec5\u6709\u5ba1\u6279\u5355\u7684\u90e8\u5206\u6570\u636e\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalApproveCreateBillValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]), approveBill.getString("billno"));
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }
}

