/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.attbizdata;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.swc.hsas.business.attbizdata.AttBizDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AttBizDataDetailValidator
extends SWCDataBaseValidator {
    private static final String ATTITEMTYPE_DETAIL = "0";

    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": 
            case "submit": {
                this.saveValidator(dataEntities);
                break;
            }
        }
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> depEmpIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Long> attBizItemIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Date> attStartDateSet = new HashSet<Date>(dataEntities.length);
        HashSet<Date> attEndDateSet = new HashSet<Date>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            depEmpIdSet.add(data.getLong("depemp.id"));
            attBizItemIdSet.add(data.getLong("attbizitem.id"));
            attStartDateSet.add(data.getDate("attstartdate"));
            attEndDateSet.add(data.getDate("attenddate"));
        }
        Map variables = this.getOption().getVariables();
        if (variables.containsKey("importtype")) {
            this.importValidator(depEmpIdSet, attBizItemIdSet, attStartDateSet, attEndDateSet);
            return;
        }
        if (!this.getOption().containsVariable("isListOp") || Boolean.TRUE.toString().equals(this.getOption().getVariables().get("isListOp"))) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attbizdatadetail");
        Map existAttBizDataInfoMap = AttBizDataServiceHelper.getExistAttBizDataInfo((SWCDataServiceHelper)helper, depEmpIdSet, attBizItemIdSet, attStartDateSet, attEndDateSet);
        HashSet<String> currentAttBizDataInfoSet = new HashSet<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkOverlap(dataEntity, existAttBizDataInfoMap, currentAttBizDataInfoSet);
        }
    }

    private void importValidator(Set<Long> depEmpIdSet, Set<Long> attBizItemIdSet, Set<Date> attStartDateSet, Set<Date> attEndDateSet) {
        DynamicObjectCollection attBizItemColl = AttBizDataServiceHelper.queryAttBizItem(attBizItemIdSet, (String)ATTITEMTYPE_DETAIL);
        Set<Long> queryResultAttBizItemIdSet = attBizItemColl.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_attbizdatadetail");
        Map existAttBizDataInfoMap = AttBizDataServiceHelper.getExistAttBizDataInfo((SWCDataServiceHelper)helper, depEmpIdSet, attBizItemIdSet, attStartDateSet, attEndDateSet);
        HashSet<String> currentAttBizDataInfoSet = new HashSet<String>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject attBizItem = data.getDynamicObject("attbizitem");
            if (!this.checkAttBizItem(dataEntity, attBizItem, queryResultAttBizItemIdSet)) continue;
            this.checkOverlap(dataEntity, existAttBizDataInfoMap, currentAttBizDataInfoSet);
        }
    }

    private boolean checkAttBizItem(ExtendedDataEntity dataEntity, DynamicObject attBizItem, Set<Long> queryResultAttBizItemIdSet) {
        Long bizItemId = attBizItem.getLong("id");
        if (!queryResultAttBizItemIdSet.contains(bizItemId)) {
            String errorMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee.\u7f16\u7801\u201d\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AttBizDataValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkOverlap(ExtendedDataEntity dataEntity, Map<String, String> existAttBizDataInfoMap, Set<String> currentAttBizDataInfoSet) {
        DynamicObject data = dataEntity.getDataEntity();
        String attBizDataKey = AttBizDataServiceHelper.getAttBizDataKey((Date)data.getDate("attstartdate"), (Date)data.getDate("attenddate"), (Long)data.getLong("depemp.id"), (Long)data.getLong("attbizitem.id"));
        boolean checkResult = true;
        if (existAttBizDataInfoMap.containsKey(attBizDataKey)) {
            String identifynumber = data.getString("identifynumber");
            if (SWCStringUtils.isEmpty((String)identifynumber)) {
                String errorMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u8003\u52e4\u6570\u636e\uff0c\u8bf7\u5220\u9664/\u5e9f\u5f03\u540e\u518d\u65b0\u589e\uff0c\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7\uff1a{0}\u3002", (String)"AttBizDataValidator_20", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, existAttBizDataInfoMap.get(attBizDataKey));
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                checkResult = false;
            }
        } else if (currentAttBizDataInfoSet.contains(attBizDataKey)) {
            String errorMsg = ResManager.loadKDString((String)"\u6e90\u6587\u4ef6\u4e2d\u5b58\u5728\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AttBizDataValidator_21", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            checkResult = false;
        } else {
            currentAttBizDataInfoSet.add(attBizDataKey);
        }
        return checkResult;
    }
}

