/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.attbizdata;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.attbizdata.AttBizDataListHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AttBizDataValidator
extends SWCDataBaseValidator {
    private static final Log log = LogFactory.getLog(AttBizDataValidator.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    public void validate() {
        long currentTime = System.currentTimeMillis();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        log.info("AttBizDataValidator batch size is:{}", (Object)dataEntities.length);
        switch (operateKey) {
            case "save": 
            case "submit": {
                long startTime = System.currentTimeMillis();
                this.saveValidator(dataEntities);
                log.info("AttBizDataValidator saveValidator total use time:{}", (Object)(System.currentTimeMillis() - startTime));
                break;
            }
            case "unaudit": {
                this.checkUnAuditData(dataEntities);
                break;
            }
        }
        log.info("AttBizDataValidator total use time:{}", (Object)(System.currentTimeMillis() - currentTime));
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        Map variables = this.getOption().getVariables();
        if (variables.containsKey("importtype")) {
            this.importValidator(dataEntities);
            return;
        }
        if (!this.getOption().containsVariable("isListOp") || Boolean.TRUE.toString().equals(this.getOption().getVariables().get("isListOp"))) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String attBizItemName;
            String personName;
            DynamicObject data = dataEntity.getDataEntity();
            if (!this.checkSavaValue(dataEntity, data, personName = data.getString("depemp.person.name"), attBizItemName = data.getString("attbizitem.name"))) continue;
            this.checkAttDate(dataEntity, personName, attBizItemName);
        }
    }

    private boolean checkSavaValue(ExtendedDataEntity dataEntity, DynamicObject data, String personName, String attBizItemName) {
        DynamicObject attBizItem = data.getDynamicObject("attbizitem");
        if (SWCObjectUtils.isEmpty((Object)attBizItem)) {
            return true;
        }
        long dataTypeId = attBizItem.getLong("datatype.id");
        if (dataTypeId == 1030L) {
            String value = data.getString("inputtextvalue");
            if (!this.checkTextValue(dataEntity, value, personName, attBizItem)) {
                return false;
            }
        } else if (dataTypeId == 1010L) {
            BigDecimal value = data.getBigDecimal("inputdecimalvalue");
            if (!this.checkMaxValAndMinVal(dataEntity, personName, attBizItem, attBizItemName, value)) {
                return false;
            }
        } else if (dataTypeId == 1050L) {
            Date value = data.getDate("inputdatevalue");
            if (!this.checkDateValue(dataEntity, personName, attBizItem, value)) {
                return false;
            }
        } else if (dataTypeId == 1020L) {
            BigDecimal value = data.getBigDecimal("inputdecimalvalue");
            if (!this.checkMaxValAndMinVal(dataEntity, personName, attBizItem, attBizItemName, value)) {
                return false;
            }
            if (!this.checkCurrency(dataEntity, personName, data, attBizItem, attBizItemName)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkCurrency(ExtendedDataEntity dataEntity, String personName, DynamicObject data, DynamicObject attBizItem, String attBizItemName) {
        boolean isMatch;
        DynamicObject usedCurrency = data.getDynamicObject("currency");
        if (usedCurrency == null) {
            String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u6570\u636e\u7c7b\u578b\u4e3a\u91d1\u989d\uff0c\u5fc5\u987b\u586b\u5199\u5e01\u79cd.\u8d27\u5e01\u4ee3\u7801\u3002", (String)"AttBizDataValidator_24", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        DynamicObjectCollection currencys = attBizItem.getDynamicObjectCollection("currency");
        HashMap<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(currencys.size());
        for (DynamicObject currency : currencys) {
            currencyMap.put(currency.getDynamicObject("fbasedataid").getLong("id"), currency);
        }
        if (currencys.size() > 0 && !(isMatch = currencyMap.containsKey(usedCurrency.getLong("id")))) {
            String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u5e01\u79cd\u5fc5\u987b\u6839\u636e\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u4e2d\u53ef\u8f93\u5165\u5e01\u79cd\u8fdb\u884c\u9009\u62e9\u3002", (String)"AttBizDataValidator_25", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkAmountAccuracy(ExtendedDataEntity dataEntity, String personName, DynamicObject data, BigDecimal value) {
        DynamicObject usedCurrency = data.getDynamicObject("currency");
        int amtprecision = usedCurrency.getInt("amtprecision");
        int scale = value.scale();
        if (scale > amtprecision) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u503c\u9700\u5728\u6570\u636e\u7cbe\u5ea6\u8981\u6c42\u201c{1}\u4f4d\u5c0f\u6570\u201d\u5185\u3002", (String)"AttBizDataValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, amtprecision);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkMaxValAndMinVal(ExtendedDataEntity dataEntity, String personName, DynamicObject attBizItem, String attBizItemName, BigDecimal value) {
        boolean checkResult;
        BigDecimal minValue = attBizItem.getBigDecimal("minvalue");
        BigDecimal maxValue = attBizItem.getBigDecimal("maxvalue");
        Boolean isMinValNull = attBizItem.getBoolean("isminvalnull");
        boolean isMaxValNull = attBizItem.getBoolean("ismaxvalnull");
        if (value == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u503c\u201d\u7684\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8981\u6c42\u6574\u6570\u90e8\u5206\u987b\u5c0f\u4e8e\u7b49\u4e8e13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u987b\u5c0f\u4e8e\u7b49\u4e8e10\u4f4d\u3002", (String)"AttBizDataValidator_22", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u5728\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u6700\u5c0f\u503c\u8303\u56f4\u5185\u3002", (String)"AttBizDataValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (isMinValNull.booleanValue() && isMaxValNull) {
            checkResult = true;
        } else if (isMinValNull.booleanValue()) {
            checkResult = maxValue.compareTo(value) >= 0;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2264\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u503c\u3002", (String)"AttBizDataValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else if (isMaxValNull) {
            checkResult = minValue.compareTo(value) <= 0;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2265\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5c0f\u503c\u3002", (String)"AttBizDataValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else {
            boolean bl = checkResult = minValue.compareTo(value) <= 0 && maxValue.compareTo(value) >= 0;
        }
        if (!checkResult) {
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkDecimalAccuracy(ExtendedDataEntity dataEntity, String personName, DynamicObject attBizItem, BigDecimal value) {
        int scalelimit = attBizItem.getInt("scalelimit");
        int scale = value.scale();
        if (scale > scalelimit) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u503c\u9700\u5728\u6570\u636e\u7cbe\u5ea6\u8981\u6c42\u201c{1}\u4f4d\u5c0f\u6570\u201d\u5185\u3002", (String)"AttBizDataValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, scalelimit);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkDateValue(ExtendedDataEntity dataEntity, String personName, DynamicObject attBizItem, Date value) {
        boolean checkResult;
        String attBizItemName = attBizItem.getString("name");
        Date earliestDate = attBizItem.getDate("earliestdate");
        Date lastDate = attBizItem.getDate("lastdate");
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u5728\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u7684\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"AttBizDataValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (earliestDate == null && lastDate == null) {
            checkResult = true;
        } else if (earliestDate == null) {
            checkResult = !lastDate.before(value);
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2264\u6700\u665a\u65e5\u671f\u3002", (String)"AttBizDataValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else if (lastDate == null) {
            checkResult = !earliestDate.after(value);
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2265\u6700\u65e9\u65e5\u671f\u3002", (String)"AttBizDataValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else {
            boolean bl = checkResult = !lastDate.before(value) && !earliestDate.after(value);
        }
        if (!checkResult) {
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkTextValue(ExtendedDataEntity dataEntity, String value, String personName, DynamicObject attBizItem) {
        int dataLength = attBizItem.getInt("datalength");
        if (value.length() > dataLength) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u7684\u6570\u636e\u957f\u5ea6\u3002", (String)"AttBizDataValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItem.getString("name"));
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private void importValidator(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> employeeIdSet = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            employeeIdSet.add(data.getLong("employee.id"));
        }
        Set adminOrgIdSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)this.getEntityKey(), (String)"47150e89000000ac", (String)"adminorg");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (adminOrgIdSet != null) {
            filterList.add(new QFilter("adminorg", "in", (Object)adminOrgIdSet));
        }
        ArrayList<QFilter> employeeIdFilterList = new ArrayList<QFilter>(10);
        employeeIdFilterList.add(new QFilter("employee.id", "in", employeeIdSet));
        employeeIdFilterList.add(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')));
        AttBizDataListHelper attBizDataListHelper = new AttBizDataListHelper();
        DynamicObject[] depEmps = attBizDataListHelper.getDepEmp(employeeIdFilterList, filterList);
        HashMap<Long, Map> employeeAndDepEmpMap = new HashMap<Long, Map>(16);
        for (DynamicObject dynamicObject : depEmps) {
            Long employeeId = dynamicObject.getLong("employee.id");
            Map depEmpMap = employeeAndDepEmpMap.computeIfAbsent(employeeId, key -> new LinkedHashMap(16));
            depEmpMap.put(dynamicObject.getString("number"), dynamicObject);
        }
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject depEmp;
            String errorMsg;
            DynamicObject data = dynamicObject.getDataEntity();
            DynamicObject attBizItem = data.getDynamicObject("attbizitem");
            String attBizItemName = attBizItem.getString("name");
            String depEmpNumber = data.getString("depempnumber");
            Long employeeId = data.getLong("employee.id");
            Map depEmpMap = (Map)employeeAndDepEmpMap.get(employeeId);
            if (SWCStringUtils.isEmpty((String)depEmpNumber)) {
                if (CollectionUtils.isEmpty((Map)depEmpMap)) {
                    errorMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u201c\u4eba\u5458.\u5de5\u53f7\u201d\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AttBizDataValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addMessage((ExtendedDataEntity)dynamicObject, errorMsg, ErrorLevel.FatalError);
                    continue;
                }
                depEmp = (DynamicObject)depEmpMap.values().iterator().next();
            } else {
                depEmp = (DynamicObject)depEmpMap.get(depEmpNumber);
                if (depEmp == null) {
                    errorMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u201c\u4efb\u804c\u7ecf\u5386.\u4e1a\u52a1\u7f16\u7801\u201d\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AttBizDataValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addMessage((ExtendedDataEntity)dynamicObject, errorMsg, ErrorLevel.FatalError);
                    continue;
                }
            }
            data.set("depemp", (Object)depEmp);
            data.set("person", (Object)depEmp.getDynamicObject("person"));
            data.set("adminorg", (Object)depEmp.getDynamicObject("adminorg"));
            String personName = data.getString("depemp.person.name");
            if (!this.checkAttBizItem((ExtendedDataEntity)dynamicObject, attBizItem, attBizItemName) || !this.checkImportValue((ExtendedDataEntity)dynamicObject, personName, attBizItem, attBizItemName)) continue;
            this.checkAttDate((ExtendedDataEntity)dynamicObject, personName, attBizItemName);
        }
    }

    private boolean checkAttBizItem(ExtendedDataEntity dataEntity, DynamicObject attBizItem, String attBizItemName) {
        if (!"1".equals(attBizItem.getString("classification"))) {
            String errorMsg = ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee.\u7f16\u7801\u201d\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6,\u8bf7\u8c03\u6574\u3002", (String)"AttBizDataValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkImportValue(ExtendedDataEntity dataEntity, String personName, DynamicObject attBizItem, String attBizItemName) {
        DynamicObject data = dataEntity.getDataEntity();
        String strValue = data.getString("inputtextvalue");
        if (SWCStringUtils.isEmpty((String)strValue)) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AttBizDataValidator_14", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        long dataTypeId = attBizItem.getLong("datatype.id");
        if (dataTypeId == 1030L) {
            if (!this.checkTextValue(dataEntity, strValue, personName, attBizItem)) {
                return false;
            }
        } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
            if (!this.checkBigDecimalTypeValue(dataEntity, personName, attBizItemName, strValue)) {
                return false;
            }
            BigDecimal value = null;
            try {
                value = new BigDecimal(strValue);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizDataValidator_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
            if (dataTypeId == 1020L) {
                if (!this.checkCurrency(dataEntity, personName, data, attBizItem, attBizItemName)) {
                    return false;
                }
                if (!this.checkAmountAccuracy(dataEntity, personName, data, value)) {
                    return false;
                }
            } else {
                if (!this.checkMaxValAndMinVal(dataEntity, personName, attBizItem, attBizItemName, value)) {
                    return false;
                }
                if (!this.checkDecimalAccuracy(dataEntity, personName, attBizItem, value)) {
                    return false;
                }
            }
        } else if (dataTypeId == 1050L) {
            Date value;
            try {
                if (!SWCDateTimeUtils.validDateEffecitive((String)strValue)) {
                    String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizDataValidator_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    return false;
                }
                value = SWCDateTimeUtils.parseDate((String)strValue);
                data.set("inputtextvalue", (Object)SWCDateTimeUtils.format((Date)value, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizDataValidator_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
            if (!this.checkDateValue(dataEntity, personName, attBizItem, value)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkBigDecimalTypeValue(ExtendedDataEntity dataEntity, String personName, String attBizItemName, String strValue) {
        if (strValue == null || !NUMBER_PATTERN.matcher(strValue).matches()) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizDataValidator_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        String[] split = strValue.split("\\.");
        if (split[0].length() > 13) {
            String errorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u503c\u201d\u7684\u503c\u201c{0}\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8981\u6c42\u6574\u6570\u90e8\u5206\u987b\u5c0f\u4e8e\u7b49\u4e8e13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u987b\u5c0f\u4e8e\u7b49\u4e8e10\u4f4d\u3002", (String)"AttBizDataValidator_23", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, strValue);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        if (split.length == 2 && split[1].length() > 10) {
            String errorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u503c\u201d\u7684\u503c\u201c{0}\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8981\u6c42\u6574\u6570\u90e8\u5206\u987b\u5c0f\u4e8e\u7b49\u4e8e13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u987b\u5c0f\u4e8e\u7b49\u4e8e10\u4f4d\u3002", (String)"AttBizDataValidator_23", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, strValue);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkAttDate(ExtendedDataEntity dataEntity, String personName, String attBizItemName) {
        DynamicObject data = dataEntity.getDataEntity();
        Date startDate = data.getDate("attstartdate");
        Date endDate = data.getDate("attenddate");
        if (!SWCObjectUtils.isEmpty((Object)startDate) && !SWCObjectUtils.isEmpty((Object)endDate) && startDate.after(endDate)) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u8003\u52e4\u7ed3\u675f\u65e5\u671f\u9700\u2265\u8003\u52e4\u5f00\u59cb\u65e5\u671f\u3002", (String)"AttBizDataValidator_16", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private DynamicObjectCollection getEmployee(QFilter[] filters) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hrpi_employee");
        return salaryFileHelper.queryOriginalCollection("id", filters);
    }

    private void checkUnAuditData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String auditstatus;
            int noCntUsageCount;
            int usageCount;
            int count;
            DynamicObject data = dataEntity.getDataEntity();
            String personName = data.getString("depemp.person.name");
            String attBizItemName = data.getString("attbizitem.name");
            String dataSources = data.getString("datasource");
            String bizDataCode = data.getString("identifynumber");
            if (!SWCStringUtils.equals((String)"1", (String)dataSources)) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4ec5\u53ef\u5bf9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u4e14\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"AttBizDataValidator_17", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, bizDataCode);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
            if ((count = (usageCount = data.getInt("usagecount")) + (noCntUsageCount = data.getInt("nocounttimes"))) > 0) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u4f7f\u7528\u6b21\u6570 >=1\uff08\u542b\u975e\u85aa\u8d44\u53d1\u653e\u6d88\u8d39\uff09\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"AttBizDataValidator_18", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, attBizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
            if (!"E".equals(auditstatus = data.getString("auditstatus"))) continue;
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4ec5\u53ef\u5bf9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u4e14\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"AttBizDataValidator_19", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, bizDataCode);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }
}

