/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bankaccountmodifybill;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sdk.swc.hsas.common.events.paydetail.BankAccountModifyFilterEvent;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ModifyBillSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkData(dataEntity);
        }
    }

    private void checkData(ExtendedDataEntity dataEntity) {
        DynamicObject billData = dataEntity.getDataEntity();
        DynamicObjectCollection collection = billData.getDynamicObjectCollection("entryentity");
        if (collection.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u94f6\u884c\u5361\u4fe1\u606f\u53d8\u66f4\u6570\u636e\u3002", (String)"ModifyBillSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return;
        }
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject entry = (DynamicObject)collection.get(index);
            long acctmodifyreasonId = entry.getLong("acctmodifyreason.id");
            if (acctmodifyreasonId != 0L) continue;
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u5148\u586b\u5199\u53d8\u66f4\u539f\u56e0\u3002", (String)"ModifyBillSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]), index + 1));
        }
        HashMap paydetailIdIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet paydetailIds = Sets.newHashSetWithExpectedSize((int)16);
        long billId = billData.getLong("id");
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject entry = (DynamicObject)collection.get(index);
            long paydetailId = entry.getLong("paydetail.id");
            long modifyBillId = entry.getLong("paydetail.acctmodifybill.id");
            if (modifyBillId == billId) continue;
            paydetailIdIndexMap.put(paydetailId, index);
            paydetailIds.add(paydetailId);
        }
        BankAccountModifyFilterEvent filterEvent = BankAccountModifyHelper.beforeBankAccountModifyFilterEvent();
        DynamicObject[] validPayDetails = BankAccountModifyHelper.queryValidPkIdList((Set)paydetailIds, (BankAccountModifyFilterEvent)filterEvent);
        for (DynamicObject validPayDetail : validPayDetails) {
            long paydetailId = validPayDetail.getLong("id");
            paydetailIds.remove(paydetailId);
        }
        for (Long paydetailId : paydetailIds) {
            Integer index = (Integer)paydetailIdIndexMap.get(paydetailId);
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u9009\u4e2d\u6570\u636e\u5df2\u5728\u4ed8\u6b3e\u6d41\u7a0b\u4e2d\u6216\u5df2\u8fdb\u884c\u505c\u7f13\u53d1\u6216\u5df2\u5728\u8fdb\u884c\u94f6\u884c\u5361\u53d8\u66f4\u6216\u5df2\u5e9f\u5f03\u6216\u4e0d\u9700\u8981\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u65e0\u6cd5\u53d8\u66f4\u94f6\u884c\u5361\u3002", (String)"ModifyBillSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[]{index + 1}));
        }
        String billStatus = billData.getString("billstatus");
        String bizKey = this.getOption().getVariableValue("bizKey", null);
        if (SWCStringUtils.isEmpty((String)bizKey)) {
            return;
        }
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            return;
        }
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject entry = (DynamicObject)collection.get(index);
            long perBankCardId = entry.getLong("perbankcard.id");
            long modifyPerBankCardId = entry.getLong("modifyperbankcard.id");
            if (modifyPerBankCardId == 0L) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u8bf7\u5148\u66f4\u6b63\u94f6\u884c\u5361\u4fe1\u606f\u3002", (String)"ModifyBillSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), index + 1));
            }
            if (modifyPerBankCardId != perBankCardId) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u53d8\u66f4\u540e\u94f6\u884c\u5361\u4fe1\u606f\u4e0e\u53d8\u66f4\u524d\u4e00\u81f4\uff0c\u66f4\u6b63\u7ed3\u679c\u65e0\u6548\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ModifyBillSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[]{index + 1}));
        }
    }
}

