/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.basedata;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.calrule.CalRuleCommonService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CalRuleSaveValidator
extends SWCDataBaseValidator {
    private static final String FIELD_AREATYPE_GENERAL = "1";
    private static final String FIELD_AREATYPE_ASSIGN = "2";
    private static final Set<String> MUST_FIXED_FIELD_SET = new LinkedHashSet<String>(Arrays.asList("number", "areatype", "country.id"));

    public void validate() {
        block5: {
            block4: {
                ExtendedDataEntity[] dataEntities;
                super.validate();
                CalRuleCommonService instanceForImport = CalRuleCommonService.createInstanceForImport((OperateOption)this.getOption(), (ExtendedDataEntity[])this.dataEntities);
                Map variables = this.getOption().getVariables();
                if (!"save".equals(this.getOperateKey()) && !"submit".equals(this.getOperateKey()) && !"audit".equals(this.getOperateKey()) && !"donothing_confirmchange".equals(this.getOperateKey()) && !"confirmchange".equals(this.getOperateKey())) break block4;
                HashMap<String, String> dataMap = this.querypayRollScenes();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String number;
                    if (instanceForImport != null && instanceForImport.checkFexFieldChangedWhenImport(dataEntity, MUST_FIXED_FIELD_SET)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u548c\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CalRuleSaveValidator_16", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    if (SWCStringUtils.equals((String)"submit", (String)this.getOperateKey()) && this.checkIsDraft(dataEntity, variables.containsKey("isDetail"))) continue;
                    this.checkAreaTypeAndCountry(dataEntity);
                    String areatype = dynamicObject.getString("areatype");
                    String openTaxCal = dynamicObject.getString("opentaxcal");
                    if (SWCStringUtils.isNotEmpty((String)areatype) && FIELD_AREATYPE_GENERAL.equals(areatype) && FIELD_AREATYPE_GENERAL.equals(openTaxCal)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\u65f6\uff0c\u542f\u7528\u4e2a\u7a0e\u8ba1\u7b97\u4e0d\u80fd\u4e3a\u662f\u3002", (String)"CalRuleSaveValidator_20", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection entryentityColl = (DynamicObjectCollection)dynamicObject.get("calruleitementry");
                    if (entryentityColl == null || entryentityColl.size() == 0) continue;
                    this.checkNetAndTotalSalaryItem(dataEntity, entryentityColl, dynamicObject);
                    this.checkEntryData(dataEntity, entryentityColl, dynamicObject);
                    if (!"confirmchange".equals(this.getOperateKey()) && !"save".equals(this.getOperateKey()) || !SWCStringUtils.isNotEmpty((String)((String)dataMap.get(number = dynamicObject.getString("number")))) || SWCStringUtils.equals((String)((String)dataMap.get(number)), (String)dynamicObject.getString("aftercaltype"))) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5df2\u88ab\u85aa\u8d44\u6838\u7b97\u573a\u666f\u5f15\u7528\uff0c\u201c\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u201d\u8bf7\u4e0e\u53d8\u66f4\u524d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CalRuleSaveValidator_21", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                }
                break block5;
            }
            if (!"saveasdraft".equals(this.getOperateKey())) break block5;
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkAreaTypeAndCountry(dataEntity);
            }
        }
    }

    private HashMap<String, String> querypayRollScenes() {
        DynamicObject[] query;
        DynamicObject[] queryCal;
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        HashSet<Long> pkList = new HashSet<Long>(10);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<String> billNos = new HashSet<String>(10);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            billNos.add(dataEntity.getDataEntity().getString("number"));
        }
        SWCDataServiceHelper helperCal = new SWCDataServiceHelper("hsas_calrule");
        String selectCalProperties = "boid,name,number,aftercaltype";
        QFilter pkFilterCal = new QFilter("number", "in", billNos);
        QFilter statusFilterCal = new QFilter("status", "=", (Object)"C");
        statusFilterCal.and(pkFilterCal);
        QFilter[] filtersCal = new QFilter[]{statusFilterCal};
        for (DynamicObject dynamicObject : queryCal = helperCal.query(selectCalProperties, filtersCal)) {
            pkList.add(dynamicObject.getLong("boid"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        String selectProperties = "name,number,aftercaltype,status,datastatus";
        QFilter pkFilter = new QFilter("calrule.id", "in", pkList);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(10);
        QFilter[] filters = new QFilter[]{pkFilter};
        for (DynamicObject dynamicObject : query = helper.query(selectProperties, filters)) {
            if (dynamicObject.getString("datastatus").equals("-2") && dynamicObject.getString("status").equals("C")) continue;
            dynamicObjectList.add(dynamicObject);
        }
        if (dynamicObjectList.size() > 0) {
            DynamicObject[] queryVer;
            QFilter statusFilterCalVer = new QFilter("iscurrentversion", "=", (Object)FIELD_AREATYPE_GENERAL);
            statusFilterCal.and(statusFilterCalVer);
            for (DynamicObject dynamicObject : queryVer = helperCal.query(selectCalProperties, filtersCal)) {
                String aftercaltype = dynamicObject.getString("aftercaltype");
                String number = dynamicObject.getString("number");
                dataMap.put(number, aftercaltype);
            }
        }
        return dataMap;
    }

    private void checkNetAndTotalSalaryItem(ExtendedDataEntity dataEntity, DynamicObjectCollection entryentityColl, DynamicObject calRuleObj) {
        DynamicObject calRule = dataEntity.getDataEntity();
        long totalItemId = calRule.getLong("totalsalary.id");
        long netItemId = calRule.getLong("netsalary.id");
        String afterCalType = calRule.getString("aftercaltype");
        List salaryItemIdList = entryentityColl.stream().map(obj -> obj.getLong("salaryitem.id")).collect(Collectors.toList());
        String openTaxCal = calRuleObj.getString("opentaxcal");
        if (!SWCStringUtils.equals((String)openTaxCal, (String)"0") && !SWCStringUtils.equals((String)afterCalType, (String)FIELD_AREATYPE_ASSIGN)) {
            if (!salaryItemIdList.contains(totalItemId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u7ef4\u62a4\u7684\u85aa\u916c\u9879\u76ee\u672a\u5728\u201c\u85aa\u916c\u9879\u76ee\u201d\u5217\u4e2d\u3002", (String)"CalRuleSaveValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
            if (!salaryItemIdList.contains(netItemId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6307\u5b9a\u4e3a\u51c0\u85aa\u8d44\u7684\u85aa\u916c\u9879\u76ee\u672a\u5305\u542b\u5728\u201c\u85aa\u916c\u9879\u76ee\u6784\u6210\u53ca\u8ba1\u7b97\u516c\u5f0f\u201d\u4e2d\u3002", (String)"CalRuleSaveValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
        }
        if (SWCStringUtils.equals((String)afterCalType, (String)FIELD_AREATYPE_ASSIGN)) {
            if (!salaryItemIdList.contains(totalItemId) && totalItemId > 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u7ef4\u62a4\u7684\u85aa\u916c\u9879\u76ee\u672a\u5728\u201c\u85aa\u916c\u9879\u76ee\u201d\u5217\u4e2d\u3002", (String)"CalRuleSaveValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
            if (!salaryItemIdList.contains(netItemId) && netItemId > 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6307\u5b9a\u4e3a\u51c0\u85aa\u8d44\u7684\u85aa\u916c\u9879\u76ee\u672a\u5305\u542b\u5728\u201c\u85aa\u916c\u9879\u76ee\u6784\u6210\u53ca\u8ba1\u7b97\u516c\u5f0f\u201d\u4e2d\u3002", (String)"CalRuleSaveValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkEntryData(ExtendedDataEntity dataEntity, DynamicObjectCollection entryentityColl, DynamicObject calRuleObj) {
        String areaType;
        int index = 0;
        boolean haveNoItemForPreTax = false;
        boolean haveNoItemForAfterTax = false;
        boolean havaSourceItem = false;
        boolean havaResultItem = false;
        String openTaxCal = calRuleObj.getString("opentaxcal");
        int lastPreTaxItemIndex = 0;
        ArrayList<Integer> afterTaxItemIndexList = new ArrayList<Integer>(10);
        for (DynamicObject entry : entryentityColl) {
            String dataSource;
            Date bsed;
            ++index;
            DynamicObject salaryitemObj = (DynamicObject)entry.get("salaryitem");
            if (salaryitemObj == null) continue;
            if ("0".equals(salaryitemObj.getString("calblock"))) {
                lastPreTaxItemIndex = index;
            } else {
                afterTaxItemIndexList.add(index);
            }
            long dataTypeId = entry.getLong("salaryitem.datatype.id");
            Boolean ispayoutitem = entry.getBoolean("ispayoutitem");
            if (DataTypeEnum.AMOUNT.getDbId() != dataTypeId && ispayoutitem.booleanValue()) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u3002\u53ea\u80fd\u5c06\u6570\u636e\u7c7b\u578b\u4e3a\u201c\u91d1\u989d\u201d\u7684\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e3a\u5b9e\u53d1\u9879\u76ee\u3002", (String)"CalRuleSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]), index));
                continue;
            }
            if (!this.checkProrationRuleData(entry, dataEntity, calRuleObj, index)) continue;
            String errorMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u7b26\u5408\u56fd\u5bb6/\u5730\u533a\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"CalRuleSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.checkSalaryItemArea(dataEntity, salaryitemObj, calRuleObj, index, errorMsg);
            DynamicObject formulabaseDynamicObject = (DynamicObject)entry.get("formula");
            if (null != formulabaseDynamicObject) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u7b26\u5408\u56fd\u5bb6/\u5730\u533a\u7684\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"CalRuleSaveValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.checkSalaryItemArea(dataEntity, formulabaseDynamicObject, calRuleObj, index, errorMsg);
            }
            if ((bsed = dataEntity.getDataEntity().getDate("bsed")) == null) {
                return;
            }
            Date formulaBsed = entry.getDate("formula.firstbsed");
            if (formulaBsed != null && SWCDateTimeUtils.dayBefore((Date)bsed, (Date)formulaBsed)) {
                errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u6a21\u677f\u5185\u5b58\u5728\u5c1a\u672a\u751f\u6548\u7684\u8ba1\u7b97\u516c\u5f0f\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u8ba1\u7b97\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u516c\u5f0f\u6216\u8c03\u6574\u516c\u5f0f\u7684\u6700\u521d\u751f\u6548\u65e5\u671f:\u7b2c{0}\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"CalRuleSaveValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[]{index});
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (SWCStringUtils.equals((String)salaryitemObj.getString("taxtag"), (String)FIELD_AREATYPE_GENERAL)) {
                havaSourceItem = true;
            } else if (SWCStringUtils.equals((String)salaryitemObj.getString("taxtag"), (String)FIELD_AREATYPE_ASSIGN)) {
                havaResultItem = true;
            } else if (SWCStringUtils.equals((String)salaryitemObj.getString("calblock"), (String)"0")) {
                haveNoItemForPreTax = true;
            } else {
                haveNoItemForAfterTax = true;
            }
            if (SWCStringUtils.equals((String)openTaxCal, (String)"0")) {
                String dataSource2 = entry.getString("datasource");
                if (!SWCStringUtils.equals((String)dataSource2, (String)"6")) continue;
                String salaryItemName = entry.getString("salaryitem.name");
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c{1}\uff0c\u4e2a\u7a0e\u8ba1\u7b97\u5f00\u5173\u672a\u5f00\u542f\u6570\u636e\u6765\u6e90\u8bf7\u9009\u62e9\u8ba1\u7b97\u516c\u5f0f/\u7ed3\u679c\u8986\u76d6\u3002", (String)"CalRuleSaveValidator_14", (String)"swc-hsas-opplugin", (Object[])new Object[]{index, salaryItemName});
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)openTaxCal, (String)FIELD_AREATYPE_GENERAL)) continue;
            String taxTag = salaryitemObj.getString("taxtag");
            if (SWCStringUtils.equals((String)taxTag, (String)FIELD_AREATYPE_ASSIGN)) {
                entry.set("datasource", (Object)"6");
                entry.set("allowresultcover", (Object)"0");
                continue;
            }
            if (!SWCStringUtils.equals((String)taxTag, (String)"0") && !SWCStringUtils.equals((String)taxTag, (String)FIELD_AREATYPE_GENERAL) || !SWCStringUtils.equals((String)(dataSource = entry.getString("datasource")), (String)"6")) continue;
            errorMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u8ba1\u7b97\u5f00\u5173\u5f00\u542f\u65f6\uff0c\u5f53\u85aa\u916c\u9879\u76ee\u7684\u201c\u4e2a\u7a0e\u6807\u7b7e\u201d\u4e0d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u201d\u65f6\uff0c\u4e0d\u80fd\u9009\u62e9\u201c\u6570\u636e\u6765\u6e90\u201d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u4e91\u670d\u52a1\u201d\u3002", (String)"CalRuleSaveValidator_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
        for (Integer calIndex : afterTaxItemIndexList) {
            if (lastPreTaxItemIndex <= calIndex) continue;
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u85aa\u916c\u9879\u76ee\u8ba1\u7b97\u533a\u6bb5\u4e3a\u7a0e\u540e\uff0c\u8ba1\u7b97\u987a\u5e8f\u4e0d\u53ef\u6392\u5217\u5728\u7a0e\u524d\u9879\u76ee\u4e4b\u524d\u3002", (String)"CalRuleSaveValidator_19", (String)"swc-hsas-opplugin", (Object[])new Object[0]), calIndex));
        }
        if (!(!SWCStringUtils.equals((String)openTaxCal, (String)FIELD_AREATYPE_GENERAL) || !SWCStringUtils.equals((String)(areaType = calRuleObj.getString("areatype")), (String)FIELD_AREATYPE_ASSIGN) || havaResultItem && havaSourceItem && haveNoItemForAfterTax && haveNoItemForPreTax)) {
            String msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u4e2d\uff0c\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u7a0e\u524d\u7684\u975e\u4e2a\u7a0e\u9879\u76ee\u3001\u7a0e\u524d\u7684\u4e2a\u7a0e\u6e90\u9879\u76ee\u3001\u7a0e\u540e\u7684\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u3001\u7a0e\u540e\u7684\u975e\u4e2a\u7a0e\u9879\u76ee\u3002", (String)"CalRuleSaveValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private boolean checkProrationRuleData(DynamicObject entry, ExtendedDataEntity dataEntity, DynamicObject calRuleObj, int index) {
        String isCovert = entry.getString("isconvert");
        long dataTypeId = entry.getLong("salaryitem.datatype.id");
        if ((!FIELD_AREATYPE_GENERAL.equals(entry.getString("datasource")) || dataTypeId != DataTypeEnum.AMOUNT.getDbId()) && FIELD_AREATYPE_ASSIGN.equals(isCovert)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u6570\u636e\u6765\u6e90\u4e3a\u8ba1\u7b97\u516c\u5f0f\uff0c\u4e14\u85aa\u916c\u9879\u76ee\u6570\u636e\u7c7b\u578b\u4e3a\u91d1\u989d\u6216\u6570\u503c\u65f6\uff0c\u624d\u53ef\u542f\u7528\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u3002", (String)"CalRuleSaveValidator_18", (String)"swc-hsas-opplugin", (Object[])new Object[]{index});
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        if (SWCStringUtils.equals((String)isCovert, (String)FIELD_AREATYPE_ASSIGN) && entry.getLong("customprorationrule.id") == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5206\u6bb5\u6298\u7b97\u7b56\u7565\u8bbe\u7f6e\u4e3a\u542f\u7528\u6298\u7b97\u89c4\u5219\uff0c\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalRuleSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[]{index});
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        if (SWCStringUtils.equals((String)isCovert, (String)FIELD_AREATYPE_GENERAL)) {
            entry.set("customprorationrule", null);
            return true;
        }
        DynamicObject prorationRule = entry.getDynamicObject("customprorationrule");
        if (prorationRule.getDate("firstbsed") != null && SWCDateTimeUtils.dayAfter((Date)prorationRule.getDate("firstbsed"), (Date)calRuleObj.getDate("bsed"))) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u8ba1\u7b97\u89c4\u5219\u5f53\u524d\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"CalRuleSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[]{index});
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        String errorMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u7b26\u5408\u56fd\u5bb6/\u5730\u533a\u7684\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u3002", (String)"CalRuleSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        this.checkSalaryItemArea(dataEntity, prorationRule, calRuleObj, index, errorMsg);
        return true;
    }

    private void checkAreaTypeAndCountry(ExtendedDataEntity dataEntity) {
        boolean check;
        DynamicObject obj = dataEntity.getDataEntity();
        String areatype = obj.getString("areatype");
        long countryId = obj.getLong("country.id");
        boolean bl = check = SWCStringUtils.isEmpty((String)areatype) || SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)areatype) && 0L == countryId || SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)areatype) && 0L != countryId;
        if (check) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"CalRuleSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, obj.getString("name")));
            return;
        }
    }

    private boolean checkIsDraft(ExtendedDataEntity extendedDataEntity, boolean isDetail) {
        if (!isDetail && extendedDataEntity.getDataEntity().getBoolean("isdraft")) {
            String errorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u201c{0}\u201d\u7684\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CalRuleSaveValidator_17", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, extendedDataEntity.getDataEntity().getString("name")));
            return true;
        }
        return false;
    }

    private void checkSalaryItemArea(ExtendedDataEntity dataEntity, DynamicObject entry, DynamicObject calRuleObj, int index, String errMsg) {
        String areatype = calRuleObj.getString("areatype");
        long calRuleCountryId = calRuleObj.getLong("country.id");
        if (SWCStringUtils.isEmpty((String)areatype) || SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)areatype) && 0L == calRuleCountryId || SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)areatype) && 0L != calRuleCountryId) {
            return;
        }
        String itemAreatype = entry.getString("areatype");
        long itemCountryId = entry.getLong("country.id");
        if (SWCStringUtils.isEmpty((String)itemAreatype)) {
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errMsg, index));
        }
        if (SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)areatype)) {
            if (!SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)itemAreatype)) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errMsg, index));
            }
            if (0L != itemCountryId) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errMsg, index));
            }
        } else if (SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)areatype)) {
            if (SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)itemAreatype) && itemCountryId == 0L) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errMsg, index));
            }
            if (0L != itemCountryId && itemCountryId != calRuleCountryId) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errMsg, index));
            }
            if (SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)itemAreatype) && itemCountryId != 0L) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errMsg, index));
            }
        }
    }
}

