/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.basedata;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaxSwitchOffValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "confirmchange".equals(operateKey) || "enable".equals(operateKey)) {
            String msg = ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u9700\u540c\u65f6\u5b58\u5728\u8ba1\u7b97\u533a\u6bb5\u4e3a\u201c\u7a0e\u524d\u201d\u548c\u201c\u7a0e\u540e\u201d\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"TaxSwitchOffValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                String aftercaltype = dataEntity.getDataEntity().getString("aftercaltype");
                String openTaxCal = dataEntity.getDataEntity().getString("opentaxcal");
                if (SWCStringUtils.equals((String)"2", (String)aftercaltype) && !"1".equals(openTaxCal)) continue;
                this.validateSalaryItemCalBlock(dataEntity, msg);
            }
        }
    }

    private void validateSalaryItemCalBlock(ExtendedDataEntity dataEntity, String msg) {
        int index;
        DynamicObject entity = dataEntity.getDataEntity();
        if ("1".equals(entity.getString("opentaxcal"))) {
            return;
        }
        int coverFlag = 0;
        DynamicObjectCollection salaryItems = entity.getDynamicObjectCollection("calruleitementry");
        for (index = 0; index < salaryItems.size() && (coverFlag = this.mergeCalBlock((DynamicObject)salaryItems.get(index), coverFlag)) == 0; ++index) {
        }
        for (int j = salaryItems.size() - 1; j > index; --j) {
            coverFlag = this.mergeCalBlock((DynamicObject)salaryItems.get(j), coverFlag);
            if (coverFlag != 3) continue;
            return;
        }
        this.addFatalErrorMessage(dataEntity, msg);
    }

    private int mergeCalBlock(DynamicObject salaryItem, int coverFlag) {
        String calBlock = salaryItem.getString("salaryitem.calblock");
        if ("0".equals(calBlock)) {
            coverFlag |= 1;
        } else if ("1".equals(calBlock)) {
            coverFlag |= 2;
        }
        return coverFlag;
    }
}

