/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bizdatatpl;

import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListHelper;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class BizDataPayRollGrpTransValidator
extends SWCDataBaseValidator {
    private static final Log log = LogFactory.getLog(BizDataPayRollGrpTransValidator.class);

    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "donothing_grptrans": 
            case "donothing_directtrans": 
            case "donothing_bsedtrans": {
                this.payRollGrpTransValidator(dataEntities);
                break;
            }
        }
    }

    private void payRollGrpTransValidator(ExtendedDataEntity[] dataEntities) {
        DynamicObjectCollection bizItemColl;
        String pageName = this.getEntityKey();
        boolean isNonBizPage = true;
        if (SWCStringUtils.equals((String)pageName, (String)"hsas_bizdatarecord")) {
            isNonBizPage = false;
        }
        HashSet<Long> personIdSet = new HashSet<Long>(((ExtendedDataEntity[])dataEntities).length);
        HashSet<Long> bizItemIdSet = new HashSet<Long>(((ExtendedDataEntity[])dataEntities).length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            personIdSet.add(data.getLong("salaryfile.person.id"));
            if (!isNonBizPage) continue;
            bizItemIdSet.add(data.getLong("bizitem.id"));
        }
        Map variables = this.getOption().getVariables();
        String payRollGrpIdStr = (String)variables.get("payRollGroupId");
        if (SWCStringUtils.isEmpty((String)payRollGrpIdStr)) {
            return;
        }
        Long payRollGroupId = Long.parseLong(payRollGrpIdStr);
        BizDataHelper bizDataHelper = new BizDataHelper();
        long startTime = System.currentTimeMillis();
        Map<String, Map<String, Object>> salaryFileMap = this.getSalaryFileInfo(personIdSet, payRollGroupId);
        long endTime = System.currentTimeMillis();
        log.info("BizDataPayRollGrpTransValidator getSalaryFileIdByPayRollGrpId use time:{}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        Map payRollGroupInfo = bizDataHelper.getPayRollGroupOrgId(payRollGroupId);
        endTime = System.currentTimeMillis();
        log.info("BizDataPayRollGrpTransValidator getPayRollGroupOrgId use time:{}", (Object)(endTime - startTime));
        Long payRollGroupOrgId = (Long)payRollGroupInfo.get("payRollGroupId");
        String payRollGroupOrgName = (String)payRollGroupInfo.get("payRollGroupName");
        HashMap<Long, Boolean> bizItemHasPerm = new HashMap<Long, Boolean>(((ExtendedDataEntity[])dataEntities).length);
        String bizItemGroupId = (String)variables.get("bizItemGroupId");
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        DynamicObject bizItemGroupDetailObj = null;
        if (SWCStringUtils.isNotEmpty((String)bizItemGroupId)) {
            bizItemGroupDetailObj = bizDataRecordListHelper.getBizItemInfoByBizItemGroupId(Long.parseLong(bizItemGroupId));
        }
        HashSet<Long> hasPermBizItemIdSet = new HashSet<Long>(16);
        if (bizItemGroupDetailObj != null && (bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity")) != null && bizItemColl.size() > 0) {
            for (DynamicObject bizItemEntryObj : bizItemColl) {
                DynamicObject bizItemObj = bizItemEntryObj.getDynamicObject("bizitem");
                String ctrlstrategy = bizItemObj.getString("ctrlstrategy");
                Long bizItemId = bizItemObj.getLong("id");
                if (SWCStringUtils.equals((String)ctrlstrategy, (String)"5")) {
                    hasPermBizItemIdSet.add(bizItemId);
                    continue;
                }
                bizItemIdSet.add(bizItemId);
            }
            if (bizItemIdSet.size() > 0) {
                startTime = System.currentTimeMillis();
                Set queryBizItemIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet((String)"hsbs_bizitem", (Long)payRollGroupOrgId, bizItemIdSet);
                log.info("BizDataPayRollGrpTransValidator queryBaseDataUseOrgSet use time:{}", (Object)(endTime - startTime));
                if (queryBizItemIdSet != null && queryBizItemIdSet.size() > 0) {
                    hasPermBizItemIdSet.addAll(queryBizItemIdSet);
                }
            }
        }
        String errorBizItemStr = null;
        if (!isNonBizPage) {
            errorBizItemStr = this.bizDataRecordBuCheck(hasPermBizItemIdSet, bizItemGroupDetailObj);
        }
        ArrayList<ExtendedDataEntity> firstCheckSucList = new ArrayList<ExtendedDataEntity>(((ExtendedDataEntity[])dataEntities).length);
        for (DynamicObject dataEntity : dataEntities) {
            String bizDataCode;
            boolean isSame = this.checkSamePayRollGroup((ExtendedDataEntity)dataEntity, payRollGroupId);
            if (!isSame) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u85aa\u8d44\u6838\u7b97\u7ec4\u65e0\u53d8\u5316\uff0c\u65e0\u9700\u8f6c\u79fb\u3002", (String)"BizDataPayRollGrpTransValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                String bizDataCode2 = dataEntity.getDataEntity().getString("identifynumber");
                this.addMessage((ExtendedDataEntity)dataEntity, MessageFormat.format(errorMsg, bizDataCode2), ErrorLevel.FatalError);
                continue;
            }
            boolean haveAudit = this.checkHaveAuditSalaryFile((ExtendedDataEntity)dataEntity, salaryFileMap);
            if (!haveAudit) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4eba\u5458\u5728\u6307\u5b9a\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0b\u65e0\u5df2\u5ba1\u6838\u7684\u85aa\u8d44\u6863\u6848\u3002", (String)"BizDataPayRollGrpTransValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                bizDataCode = dataEntity.getDataEntity().getString("identifynumber");
                this.addMessage((ExtendedDataEntity)dataEntity, MessageFormat.format(errorMsg, bizDataCode), ErrorLevel.FatalError);
                continue;
            }
            if (isNonBizPage) {
                boolean hasBuPerm = this.checkHasBuPerm((ExtendedDataEntity)dataEntity, payRollGroupOrgId, bizItemIdSet, bizItemHasPerm);
                if (!hasBuPerm) {
                    String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4e1a\u52a1\u9879\u76ee\u201c{1}\u201d\u5728\u8f6c\u79fb\u540e\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u3010{2}\u3011\u4e0b\u4e0d\u53ef\u7528\u3002", (String)"BizDataPayRollGrpTransValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    String bizDataCode3 = dataEntity.getDataEntity().getString("identifynumber");
                    String bizItemName = dataEntity.getDataEntity().getString("bizitem.name");
                    this.addMessage((ExtendedDataEntity)dataEntity, MessageFormat.format(errorMsg, bizDataCode3, bizItemName, payRollGroupOrgName), ErrorLevel.FatalError);
                    continue;
                }
            } else if (SWCStringUtils.isNotEmpty((String)errorBizItemStr)) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4e1a\u52a1\u9879\u76ee\u201c{1}\u201d\u5728\u8f6c\u79fb\u540e\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u3010{2}\u3011\u4e0b\u4e0d\u53ef\u7528\u3002", (String)"BizDataPayRollGrpTransValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                bizDataCode = dataEntity.getDataEntity().getString("identifynumber");
                this.addMessage((ExtendedDataEntity)dataEntity, MessageFormat.format(errorMsg, bizDataCode, errorBizItemStr, payRollGroupOrgName), ErrorLevel.FatalError);
                continue;
            }
            firstCheckSucList.add((ExtendedDataEntity)dataEntity);
        }
        if (firstCheckSucList.size() > 0 && SWCStringUtils.equals((String)pageName, (String)"hsas_recurbizdata")) {
            String bsedStr = (String)variables.get("bsed");
            if (SWCStringUtils.isEmpty((String)bsedStr)) {
                this.recurBizDataBsedCheck(firstCheckSucList, salaryFileMap, null, null);
            } else {
                String bsledStr = (String)variables.get("bsled");
                try {
                    Date bsed = SWCDateTimeUtils.parseDate((String)bsedStr);
                    if (SWCStringUtils.isEmpty((String)bsledStr)) {
                        this.recurBizDataBsedCheck(firstCheckSucList, salaryFileMap, bsed, null);
                    } else {
                        Date bsled = SWCDateTimeUtils.parseDate((String)bsledStr);
                        this.recurBizDataBsedCheck(firstCheckSucList, salaryFileMap, bsed, bsled);
                    }
                }
                catch (ParseException e) {
                    log.info("BizDataPayRollGrpTransValidator besd and bsled parse fail");
                }
            }
        }
    }

    private Map<String, Map<String, Object>> getSalaryFileInfo(Set<Long> personIdSet, Long payRollGroupId) {
        HashMap<String, Map<String, Object>> cacheSalaryFileMap = (HashMap<String, Map<String, Object>>)GlobalParam.get((String)"cacheSalaryFileMap");
        BizDataHelper bizDataHelper = new BizDataHelper();
        if (cacheSalaryFileMap == null || cacheSalaryFileMap.size() == 0) {
            cacheSalaryFileMap = new HashMap<String, Map<String, Object>>(personIdSet.size());
            Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(personIdSet, payRollGroupId);
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                cacheSalaryFileMap.putAll(salaryFileMap);
                GlobalParam.set((String)"cacheSalaryFileMap", cacheSalaryFileMap);
            }
        } else {
            HashSet<Long> needQuerySet = new HashSet<Long>(personIdSet.size());
            Set cachePersonIdSet = cacheSalaryFileMap.keySet();
            for (Long personId : personIdSet) {
                if (cachePersonIdSet.contains(String.valueOf(personId))) continue;
                needQuerySet.add(personId);
            }
            if (needQuerySet.size() == 0) {
                return cacheSalaryFileMap;
            }
            Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(needQuerySet, payRollGroupId);
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                cacheSalaryFileMap.putAll(salaryFileMap);
                GlobalParam.set((String)"cacheSalaryFileMap", cacheSalaryFileMap);
            }
        }
        return cacheSalaryFileMap;
    }

    private void recurBizDataBsedCheck(List<ExtendedDataEntity> firstCheckSucList, Map<String, Map<String, Object>> salaryFileMap, Date transBsed, Date transBsled) {
        DynamicObject bizDataObj;
        Collections.sort(firstCheckSucList, new Comparator<ExtendedDataEntity>(){

            @Override
            public int compare(ExtendedDataEntity o1, ExtendedDataEntity o2) {
                Date bsed2;
                Date bsed1 = o1.getDataEntity().getDate("bsed");
                if (bsed1.before(bsed2 = o2.getDataEntity().getDate("bsed"))) {
                    return -1;
                }
                if (bsed1.after(bsed2)) {
                    return 1;
                }
                return 0;
            }
        });
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(firstCheckSucList.size());
        HashSet<Long> bizItemIdSet = new HashSet<Long>(firstCheckSucList.size());
        for (ExtendedDataEntity dataEntity : firstCheckSucList) {
            Map<String, Object> salaryFileInfo;
            bizDataObj = dataEntity.getDataEntity();
            bizItemIdSet.add(bizDataObj.getLong("bizitem.id"));
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            if (personId == null || personId == 0L || (salaryFileInfo = salaryFileMap.get(String.valueOf(personId))) == null) continue;
            salaryFileIdSet.add((Long)salaryFileInfo.get("salaryFileId"));
        }
        for (ExtendedDataEntity dataEntity : firstCheckSucList) {
            bizDataObj = dataEntity.getDataEntity();
            Date bsed = bizDataObj.getDate("bsed");
            String identifyNum = bizDataObj.getString("identifynumber");
            if (transBsed == null || transBsed.after(bsed)) continue;
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5927\u4e8e\u539f\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizDataPayRollGrpTransValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNum), ErrorLevel.FatalError);
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        Table recurBizData = bizDataHelper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        if (recurBizData == null || recurBizData.size() == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : firstCheckSucList) {
            List errorIdentifyNumList;
            Long salaryFileId;
            List dynamicObjects;
            DynamicObject bizDataObj2 = dataEntity.getDataEntity();
            Long bizItemId = bizDataObj2.getLong("bizitem.id");
            Long personId = bizDataObj2.getLong("salaryfile.person.id");
            Map<String, Object> salaryFileInfo = salaryFileMap.get(String.valueOf(personId));
            if (salaryFileInfo == null || (dynamicObjects = (List)recurBizData.get((Object)(salaryFileId = (Long)salaryFileInfo.get("salaryFileId")), (Object)bizItemId)) == null || dynamicObjects.size() == 0) continue;
            Date bsed = bizDataObj2.getDate("bsed");
            Date bsled = bizDataObj2.getDate("bsled");
            String identifyNum = bizDataObj2.getString("identifynumber");
            if (transBsed != null) {
                bsed = transBsed;
                bsled = transBsled;
            }
            if ((errorIdentifyNumList = bizDataHelper.getUpdateBsledErrorList(bsed, bsled, dynamicObjects, identifyNum)) == null || errorIdentifyNumList.size() <= 0) continue;
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u8f6c\u79fb\u540e\u4e1a\u52a1\u6570\u636e\u751f\u5931\u6548\u65e5\u671f\u4e0e\u8be5\u6863\u6848\u5df2\u6709\u6570\u636e\u91cd\u53e0\u4e14\u4e0d\u652f\u6301\u81ea\u52a8\u5904\u7406\u3002", (String)"BizDataPayRollGrpTransValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNum), ErrorLevel.FatalError);
        }
    }

    private String bizDataRecordBuCheck(Set<Long> hasPermBizItemIdSet, DynamicObject bizItemGroupDetailObj) {
        ArrayList<String> errorStr = new ArrayList<String>(10);
        if (bizItemGroupDetailObj == null) {
            return null;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        if (bizItemColl == null || bizItemColl.size() == 0) {
            return null;
        }
        for (DynamicObject bizItemEntryObj : bizItemColl) {
            DynamicObject bizItemObj = bizItemEntryObj.getDynamicObject("bizitem");
            Long bizItemId = bizItemObj.getLong("id");
            String bizItemName = bizItemObj.getString("name");
            if (hasPermBizItemIdSet.contains(bizItemId)) continue;
            errorStr.add(bizItemName);
        }
        if (errorStr.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = errorStr.size();
        for (int index = 0; index < len; ++index) {
            sb.append((String)errorStr.get(index));
            if (index == len - 1) continue;
            sb.append('\u3001');
        }
        return sb.toString();
    }

    private boolean checkHasBuPerm(ExtendedDataEntity dataEntity, Long payRollGroupOrgId, Set<Long> bizItemIdSet, Map<Long, Boolean> bizItemHasPerm) {
        if (payRollGroupOrgId == null) {
            return false;
        }
        DynamicObject dataObj = dataEntity.getDataEntity();
        DynamicObject bizItemObj = dataObj.getDynamicObject("bizitem");
        if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
            return false;
        }
        String ctrlstrategy = bizItemObj.getString("ctrlstrategy");
        if (SWCStringUtils.equals((String)ctrlstrategy, (String)"5")) {
            return true;
        }
        Long bizItemId = bizItemObj.getLong("id");
        Boolean hasPerm = bizItemHasPerm.get(bizItemId);
        if (hasPerm != null) {
            return hasPerm;
        }
        Set queryBizItemIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet((String)"hsbs_bizitem", (Long)payRollGroupOrgId, bizItemIdSet);
        if (queryBizItemIdSet == null || queryBizItemIdSet.size() == 0) {
            bizItemHasPerm.put(bizItemId, false);
            return false;
        }
        if (!queryBizItemIdSet.contains(bizItemId)) {
            bizItemHasPerm.put(bizItemId, false);
            return false;
        }
        bizItemHasPerm.put(bizItemId, true);
        return true;
    }

    private boolean checkSamePayRollGroup(ExtendedDataEntity dataEntity, Long payRollGroupId) {
        DynamicObject dataObj = dataEntity.getDataEntity();
        Long checkPayRollGroupId = dataObj.getLong("salaryfile.payrollgroup.id");
        return checkPayRollGroupId == null || payRollGroupId == null || payRollGroupId.longValue() != checkPayRollGroupId.longValue();
    }

    private boolean checkHaveAuditSalaryFile(ExtendedDataEntity dataEntity, Map<String, Map<String, Object>> salaryFileMap) {
        if (salaryFileMap == null || salaryFileMap.size() == 0) {
            return false;
        }
        DynamicObject bizDataObj = dataEntity.getDataEntity();
        String personIdStr = bizDataObj.getString("salaryfile.person.id");
        Map<String, Object> queryMap = salaryFileMap.get(personIdStr);
        if (queryMap == null || queryMap.size() == 0) {
            return false;
        }
        String status = (String)queryMap.get("status");
        return SWCStringUtils.equals((String)status, (String)"C");
    }
}

