/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.cal;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CalTableAuditValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            long calTaskId = dataEntities[0].getDataEntity().getLong("caltask.id");
            Boolean taxCalEnableStatus = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId);
            for (Object dataEntity : dataEntities) {
                if (this.checkOnHoldStatus((ExtendedDataEntity)dataEntity)) continue;
                this.checkCalTableRecord((ExtendedDataEntity)dataEntity, taxCalEnableStatus);
            }
        }
    }

    private boolean checkOnHoldStatus(ExtendedDataEntity dataEntity) {
        if (dataEntity == null || dataEntity.getDataEntity() == null) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6821\u9a8c\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"CalTableAuditValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String onHoldStatus = dynamicObject.getString("onholdstatus");
        String salaryFileNumber = dynamicObject.getString("salaryfile.number");
        if (String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()).equals(onHoldStatus)) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u201c\u7ec8\u6b62\u53d1\u653e\u201d\uff0c\u65e0\u6cd5\u5ba1\u6838\u3002", (String)"CalTableAuditValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]), salaryFileNumber);
            this.addMessage(dataEntity, errorMsg);
            return true;
        }
        return false;
    }

    private void checkCalTableRecord(ExtendedDataEntity dataEntity, boolean taxCalEnableStatus) {
        if (dataEntity == null || dataEntity.getDataEntity() == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6821\u9a8c\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"CalTableAuditValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String calState = dynamicObject.getString("calstatus");
        String fileNumber = dynamicObject.getString("salaryfile.number");
        if (CalStateEnum.AUDIT.getCode().equals(calState)) {
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6838\uff0c\u65e0\u6cd5\u518d\u6b21\u5ba1\u6838\u3002", (String)"CalTableAuditValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addMessage(dataEntity, failMessage);
        } else if (CalStateEnum.APPROVAL.getCode().equals(calState) || CalStateEnum.APPROVALED.getCode().equals(calState)) {
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6279\uff0c\u65e0\u6cd5\u518d\u6b21\u5ba1\u6838\u3002", (String)"CalTableAuditValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addMessage(dataEntity, failMessage);
        } else if (CalStateEnum.WAIT_APPROVALED.getCode().equals(calState) || CalStateEnum.APPROVALING.getCode().equals(calState) || CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calState)) {
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u8fdb\u5165\u5de5\u4f5c\u6d41\u5ba1\u6279\uff0c\u65e0\u6cd5\u518d\u6b21\u5ba1\u6838\u3002", (String)"CalTableAuditValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addMessage(dataEntity, failMessage);
        } else if (taxCalEnableStatus) {
            if (!CalStateEnum.ALL_CALED.getCode().equals(calState) || !TaxStateEnum.PULLED.getCode().equals(dynamicObject.getString("taxstatus"))) {
                String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u72b6\u6001\u4e3a\u201c\u8ba1\u7b97\u5b8c\u6210\u201d\uff0c\u4e2a\u7a0e\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u83b7\u53d6\u201d\u7684\u6838\u7b97\u8bb0\u5f55\uff0c\u65b9\u53ef\u8fdb\u884c\u5ba1\u6838\u3002", (String)"CalTableAuditValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addMessage(dataEntity, failMessage);
                return;
            }
        } else if (!CalStateEnum.ALL_CALED.getCode().equals(calState)) {
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u72b6\u6001\u4e0d\u4e3a\u201c\u8ba1\u7b97\u5b8c\u6210\u201d\uff0c\u65e0\u6cd5\u5ba1\u6838\u3002", (String)"CalTableAuditValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addMessage(dataEntity, failMessage);
        }
    }
}

