/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.cal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.service.HSASCalListService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CalTableDeletePayDetailValidator
extends SWCDataBaseValidator {
    private static final Log log = LogFactory.getLog(CalTableDeletePayDetailValidator.class);

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (!SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            this.checkStatus((ExtendedDataEntity[])dataEntities);
        }
    }

    private void checkStatus(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, ExtendedDataEntity> calIdDataEntityMap = new HashMap<Long, ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            String failMessage;
            DynamicObject data = dataEntity2.getDataEntity();
            String payState = data.getString("paystatus");
            String fileNumber = data.getString("salaryfile.number");
            if (PayStateEnum.UNCREATE.getCode().equals(payState)) {
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u672a\u751f\u6210\u53d1\u653e\u660e\u7ec6\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity2, failMessage);
                continue;
            }
            if (PayStateEnum.PREPAREPAY.getCode().equals(payState)) {
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u8fdb\u5165\u4ed8\u6b3e\u51c6\u5907\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity2, failMessage);
                continue;
            }
            if (PayStateEnum.PAID.getCode().equals(payState)) {
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity2, failMessage);
                continue;
            }
            if (PayStateEnum.PAYING.getCode().equals(payState)) {
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u4ed8\u6b3e\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity2, failMessage);
                continue;
            }
            if (PayStateEnum.PAYFAIL.getCode().equals(payState)) {
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6863\u6848\u201c%s\u201d\u7684\u53d1\u653e\u660e\u7ec6\u4ed8\u6b3e\u5931\u8d25\u5e76\u5904\u4e8e\u5f85\u91cd\u4ed8\u72b6\u6001\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity2, failMessage);
                continue;
            }
            String salarySlipStatus = data.getString("salarystatus");
            if (ReleaseStateEnum.RELEASED.getCode().equals(salarySlipStatus)) {
                String failMessage2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002\u8bf7\u5148\u56de\u6536\u5de5\u8d44\u6761\u3002", (String)"CalTableDeletePayDetailValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity2, failMessage2);
                continue;
            }
            if (!PayStateEnum.UNPAY.getCode().equals(payState)) continue;
            Long id = data.getLong("id");
            calIdDataEntityMap.put(id, dataEntity2);
        }
        if (calIdDataEntityMap.isEmpty()) {
            return;
        }
        HashMap<Long, Long> calPersonTableMap = new HashMap<Long, Long>(calIdDataEntityMap.size());
        calIdDataEntityMap.forEach((calPersonId, dataEntity) -> calPersonTableMap.put((Long)calPersonId, dataEntity.getDataEntity().getLong("calresultid")));
        HSASCalListService calService = new HSASCalListService();
        Set calPersonIds = calService.acctModifyIds(new ArrayList(calIdDataEntityMap.keySet()));
        calPersonIds.forEach(calPersonTableMap::remove);
        String failMessage = ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u53d1\u8d77\u94f6\u884c\u5361\u4fe1\u606f\u53d8\u66f4\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (Long calPersonId2 : calPersonIds) {
            ExtendedDataEntity dataEntity3 = (ExtendedDataEntity)calIdDataEntityMap.get(calPersonId2);
            this.getErrorMsg(dataEntity3, failMessage);
        }
        Set calPersonBankOfferIds = calService.bankOfferInvalidedIds(new ArrayList(calIdDataEntityMap.keySet()));
        failMessage = ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u6709\u5bfc\u51fa\u62a5\u76d8\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (Long calTableId : calPersonBankOfferIds) {
            ExtendedDataEntity dataEntity4 = (ExtendedDataEntity)calIdDataEntityMap.get(calTableId);
            this.getErrorMsg(dataEntity4, failMessage);
        }
        calPersonBankOfferIds.forEach(calPersonTableMap::remove);
        this.getApproveCalTableIds(dataEntities, calPersonTableMap);
    }

    private void getErrorMsg(ExtendedDataEntity dataEntity, String failMessage) {
        if (dataEntity != null) {
            DynamicObject data = dataEntity.getDataEntity();
            String fileNumber = data.getString("salaryfile.number");
            failMessage = String.format(Locale.ROOT, failMessage, fileNumber);
            this.addErrorMessage(dataEntity, failMessage);
        }
    }

    private void getApproveCalTableIds(ExtendedDataEntity[] dataEntities, Map<Long, Long> calPersonTableMap) {
        SWCDataServiceHelper approveHelper = new SWCDataServiceHelper("hsas_approvebill");
        QFilter calTableIdFilter = new QFilter("calentryentity.caltableid", "in", calPersonTableMap.values());
        DynamicObjectCollection approveBillCol = approveHelper.queryOriginalCollection("id,billstatus,approvebilltpl.id,calentryentity.caltableid, calentryentity.paydetailid", new QFilter[]{calTableIdFilter});
        HashSet tplIdSet = new HashSet(16);
        approveBillCol.forEach(data -> tplIdSet.add(data.getLong("approvebilltpl.id")));
        Map tplIsPayDetailMap = ApproveBillService.isPayDetail(tplIdSet);
        HashSet payDetailIdSet = new HashSet(16);
        approveBillCol.forEach(data -> {
            Long tplId = data.getLong("approvebilltpl.id");
            if (tplIsPayDetailMap.getOrDefault(tplId, Boolean.FALSE).booleanValue()) {
                payDetailIdSet.add(data.getLong("calentryentity.paydetailid"));
            }
        });
        if (payDetailIdSet.isEmpty()) {
            return;
        }
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter idFilter = new QFilter("id", "in", payDetailIdSet);
        QFilter abandonedStatusFilter = new QFilter("abandonedstatus", "=", (Object)"0");
        DynamicObjectCollection payDetailCol = payDetailHelper.queryOriginalCollection("id,caltableid, calpersonid", new QFilter[]{idFilter, abandonedStatusFilter});
        Set calPersonPayDetailSet = payDetailCol.stream().map(payDetail -> payDetail.getLong("calpersonid")).collect(Collectors.toSet());
        for (ExtendedDataEntity extendedData : dataEntities) {
            DynamicObject data2 = extendedData.getDataEntity();
            Long id = data2.getLong("id");
            if (!calPersonPayDetailSet.contains(id)) continue;
            String fileNumber = data2.getString("salaryfile.number");
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5173\u8054\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u5728\u5ba1\u6279\u5355\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalTableDeletePayDetailValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addErrorMessage(extendedData, errorMsg);
        }
    }
}

