/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.cal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.service.HSASCalListService;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalTableDisApproveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CalTableDisApproveValidator.class);
    private static final String FILEVNUMBER = "salaryfilev.number";

    public void validate() {
        long startTime = System.currentTimeMillis();
        ExtendedDataEntity[] entities = this.getDataEntities();
        List calPersonIds = Arrays.stream(entities).map(e -> e.getDataEntity().getLong("id")).collect(Collectors.toList());
        HSASCalListService calService = new HSASCalListService();
        Set bankOfferExportedIds = calService.getBankOfferExportedIds(calPersonIds);
        log.info("{}\u53cd\u5ba1\u6279\u65f6\u6821\u9a8c\u5668\u67e5\u8be2\u94f6\u884c\u62a5\u76d8\u8017\u65f6\uff1a{}", (Object)RequestContext.get().getTraceId(), (Object)(System.currentTimeMillis() - startTime));
        for (ExtendedDataEntity entity : entities) {
            String errorMsg;
            DynamicObject dynamicObject = entity.getDataEntity();
            if (String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()).equals(dynamicObject.getString("onholdstatus"))) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u4e3a\u7ec8\u6b62\u53d1\u653e\u72b6\u6001\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)dynamicObject.getString("calstatus"), (String)String.valueOf(CalStateEnum.APPROVAL.getCode()))) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u7684\u201c\u6838\u7b97\u72b6\u6001\u201d\u4e0d\u4e3a\u76f4\u63a5\u5ba1\u6279\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (SWCStringUtils.equals((String)ReleaseStateEnum.RELEASEING.getCode(), (String)dynamicObject.getString("salarystatus"))) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u6b63\u5728\u8fdb\u884c\u5de5\u8d44\u6761\u53d1\u5e03\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (SWCStringUtils.equals((String)ReleaseStateEnum.RELEASED.getCode(), (String)dynamicObject.getString("salarystatus"))) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (SWCStringUtils.equals((String)dynamicObject.getString("paystatus"), (String)PayStateEnum.PAYFAIL.getCode())) continue;
            if (SWCStringUtils.equals((String)dynamicObject.getString("paystatus"), (String)PayStateEnum.PAYING.getCode())) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u7684\u5bf9\u5e94\u660e\u7ec6\u5df2\u5728\u4ed8\u6b3e\u4e2d\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (SWCStringUtils.equals((String)dynamicObject.getString("paystatus"), (String)PayStateEnum.PAID.getCode())) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u7684\u5bf9\u5e94\u660e\u7ec6\u5df2\u4ed8\u6b3e\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)dynamicObject.getString("paystatus"), (String)PayStateEnum.PREPAREPAY.getCode()) || String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(dynamicObject.getString("onholdstatus")) && !bankOfferExportedIds.contains(dynamicObject.getLong("id"))) continue;
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u7684\u5bf9\u5e94\u660e\u7ec6\u5df2\u8fdb\u5165\u4ed8\u6b3e\u51c6\u5907\uff0c\u65e0\u6cd5\u76f4\u63a5\u53cd\u5ba1\u6279\u3002", (String)"CalTableDisApproveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]), dynamicObject.getString(FILEVNUMBER));
            this.addErrorMessage(entity, errorMsg);
        }
        log.info("{}\u53cd\u5ba1\u6279\u65f6\u6821\u9a8c\u5668\u8017\u65f6\uff1a{}", (Object)RequestContext.get().getTraceId(), (Object)(System.currentTimeMillis() - startTime));
    }
}

