/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.cal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cal.helper.PaySalarySlipHelper;
import kd.swc.hsas.common.enums.ReleaseSalarySlipEnum;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.lang3.StringUtils;

public class CalTableUnAuditValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            HashSet<Long> calPayRollTaskIds = new HashSet<Long>(16);
            for (Object dataEntity : dataEntities) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                calPayRollTaskIds.add(dynamicObject.getLong("caltask.id"));
            }
            this.checkCalTablesAudit((ExtendedDataEntity[])dataEntities, new ArrayList<Long>(calPayRollTaskIds));
        }
    }

    public void checkCalTablesAudit(ExtendedDataEntity[] dataEntities, List<Long> calPayRollTaskIds) {
        Map releaseSalarySlip = PaySalarySlipHelper.getReleaseSalarySlip(new ArrayList<Long>(calPayRollTaskIds));
        DynamicObject[] allotDetailArr = this.getAllotDetailArr();
        Map<Long, List<DynamicObject>> calPersonIdRefAllotDetailMap = this.getCalPersonIdRefAllotDetailMap(allotDetailArr);
        HashSet<Long> allotBillIdSet = new HashSet<Long>(allotDetailArr.length);
        for (DynamicObject allotDetail : allotDetailArr) {
            Long allotBillId = allotDetail.getLong("allotbill");
            String allotBillStatus = allotDetail.getString("allotbillstatus");
            if (!"B".equals(allotBillStatus)) continue;
            allotBillIdSet.add(allotBillId);
        }
        Map<Long, DynamicObject> allotBillMap = this.queryAllotBillMapByAllotBillSet(allotBillIdSet);
        ArrayList<Long> allotCalPersonIdList = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (this.checkOnHoldStatus(dataEntity)) continue;
            this.checkCalTableRecord(dataEntity, calPersonIdRefAllotDetailMap, allotBillMap, allotCalPersonIdList, releaseSalarySlip);
        }
        this.getOption().setVariableValue("allotCalPersonIdList", StringUtils.join(allotCalPersonIdList, (String)","));
    }

    private DynamicObject[] getAllotDetailArr() {
        if (!CostHelper.isEnableCost()) {
            return new DynamicObject[0];
        }
        ArrayList<Long> idList = new ArrayList<Long>(this.dataEntities.length);
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            idList.add(dataEntity.getDataEntity().getLong("id"));
            calTaskIdList.add(dataEntity.getDataEntity().getLong("caltask.id"));
        }
        return this.queryAllotDetailArrByCalTablePkIds(idList, calTaskIdList);
    }

    private boolean checkOnHoldStatus(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String onholdstatus = dynamicObject.getString("onholdstatus");
        if (String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()).equals(onholdstatus)) {
            String fileNumber = dynamicObject.getString("salaryfile.number");
            String failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u4e3a\u7ec8\u6b62\u53d1\u653e\u72b6\u6001\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addErrorMessage(dataEntity, failMessage);
            return true;
        }
        return false;
    }

    private void checkCalTableRecord(ExtendedDataEntity dataEntity, Map<Long, List<DynamicObject>> allotDetailMap, Map<Long, DynamicObject> allotBillMap, List<Long> allotCalPersonIdList, Map<Long, ReleaseSalarySlipEnum> releaseSalarySlip) {
        String failMessage;
        if (dataEntity == null || dataEntity.getDataEntity() == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6821\u9a8c\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"CalTableAuditValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String fileNumber = dynamicObject.getString("salaryfile.number");
        long calTaskId = dynamicObject.getLong("caltask.id");
        ReleaseSalarySlipEnum releaseSalarySlipEnum = releaseSalarySlip.get(calTaskId);
        if (ReleaseSalarySlipEnum.AUDIT == releaseSalarySlipEnum) {
            if (SWCStringUtils.equals((String)ReleaseStateEnum.RELEASED.getCode(), (String)dynamicObject.getString("salarystatus"))) {
                String failMessage2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity, failMessage2);
                return;
            }
            if (SWCStringUtils.equals((String)ReleaseStateEnum.RELEASEING.getCode(), (String)dynamicObject.getString("salarystatus"))) {
                String failMessage3 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u6b63\u5728\u8fdb\u884c\u5de5\u8d44\u6761\u53d1\u5e03\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity, failMessage3);
                return;
            }
        }
        String onHoldStatus = dynamicObject.getString("onholdstatus");
        String calState = dynamicObject.getString("calstatus");
        String payState = dynamicObject.getString("paystatus");
        String bizdatagenstatus = dynamicObject.getString("bizdatagenstatus");
        boolean checkFlag = false;
        if (SWCStringUtils.equals((String)bizdatagenstatus, (String)"2")) {
            checkFlag = true;
            failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u751f\u6210\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u751f\u6210\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addErrorMessage(dataEntity, failMessage);
        }
        if (!PayStateEnum.UNCREATE.getCode().equals(payState) && !PayStateEnum.UNPAY.getCode().equals(payState)) {
            checkFlag = true;
            failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u7ed3\u679c\u5df2\u8fdb\u5165\u4ed8\u6b3e\u9636\u6bb5\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CalTableApproveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
            this.addErrorMessage(dataEntity, failMessage);
        }
        if (!(CalStateEnum.AUDIT.getCode().equals(calState) || CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calState) || String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(onHoldStatus) && CalStateEnum.APPROVALED.getCode().equals(calState))) {
            if (CalStateEnum.APPROVAL.getCode().equals(calState) || CalStateEnum.APPROVALED.getCode().equals(calState)) {
                checkFlag = true;
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6279\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity, failMessage);
            } else if (CalStateEnum.WAIT_APPROVALED.getCode().equals(calState)) {
                checkFlag = true;
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5df2\u7ecf\u5f85\u5ba1\u6279\uff0c\u65e0\u6cd5\u518d\u6b21\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity, failMessage);
            } else if (CalStateEnum.APPROVALING.getCode().equals(calState)) {
                checkFlag = true;
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u8bb0\u5f55\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u518d\u6b21\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity, failMessage);
            } else {
                checkFlag = true;
                failMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u6838\u7b97\u7ed3\u679c\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]), fileNumber);
                this.addErrorMessage(dataEntity, failMessage);
            }
        }
        String allotStatus = dynamicObject.getString("allotstatus");
        if (checkFlag || CollectionUtils.isEmpty(allotDetailMap) || "A".equals(allotStatus)) {
            return;
        }
        Long calPersonId = dynamicObject.getLong("id");
        List<DynamicObject> allotDetailList = allotDetailMap.get(calPersonId);
        if (allotDetailList == null || allotDetailList.isEmpty()) {
            return;
        }
        int allotDetailListSize = allotDetailList.size();
        HashSet<Long> allotBillIdSet = new HashSet<Long>(allotDetailListSize);
        ArrayList<Long> toDeleteAllotDetailIdList = new ArrayList<Long>(allotDetailListSize);
        for (DynamicObject obj : allotDetailList) {
            Long allotDetailId = obj.getLong("id");
            String allotBillStatus = obj.getString("allotbillstatus");
            Long allotBillId = obj.getLong("allotbill");
            if ("B".equals(allotBillStatus)) {
                allotBillIdSet.add(allotBillId);
                continue;
            }
            toDeleteAllotDetailIdList.add(allotDetailId);
        }
        if (toDeleteAllotDetailIdList.size() == allotDetailListSize) {
            allotCalPersonIdList.add(calPersonId);
        }
        if (!allotBillIdSet.isEmpty()) {
            String salaryNumber = dynamicObject.getString("salaryfile.number");
            String personName = dynamicObject.getString("salaryfile.person.name");
            this.fillAllotDetailErrorMsg(allotBillIdSet, personName, salaryNumber, allotBillMap, dataEntity);
        }
    }

    private void fillAllotDetailErrorMsg(Set<Long> allotBillIdSet, String personName, String salaryNumber, Map<Long, DynamicObject> allotBillMap, ExtendedDataEntity dataEntity) {
        if (!CollectionUtils.isEmpty(allotBillMap)) {
            String billMessage = "";
            for (Long allotBillId : allotBillIdSet) {
                DynamicObject allotBill = allotBillMap.get(allotBillId);
                if (allotBill == null) continue;
                String financingStatus = allotBill.getString("financingstatus");
                String billNo = allotBill.getString("billno");
                billMessage = "B".equals(financingStatus) ? ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a\u6210\u672c\u5206\u914d\u5355\u5df2\u63d0\u4ea4\u8d22\u52a1\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u53cd\u5ba1\u6838\u3002\u5efa\u8bae\uff1a\u5c06\u5206\u914d\u5355\u201c{2}\u201d\u64a4\u9500\u63d0\u4ea4\u8d22\u52a1\u5e76\u5220\u9664\u540e\u518d\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[]{personName, salaryNumber, billNo}) : ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a\u6210\u672c\u5206\u914d\u5355\u5df2\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u53cd\u5ba1\u6838\u3002\u5efa\u8bae\uff1a\u5c06\u5206\u914d\u5355\u201c{2}\u201d\u5220\u9664\u540e\u518d\u53cd\u5ba1\u6838\u3002", (String)"CalTableUnAuditValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[]{personName, salaryNumber, billNo});
                this.addErrorMessage(dataEntity, billMessage);
            }
        }
    }

    private DynamicObject[] queryAllotDetailArrByCalTablePkIds(List<Long> calTablePkIds, List<Long> calTaskIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter calTaskIdFilter = new QFilter("caltask.id", "in", calTaskIdList);
        calTaskIdFilter.and(new QFilter("caltableid", "in", calTablePkIds));
        DynamicObject[] allotDetailArr = helper.queryOriginalArray("id,caltableid,allotbillstatus,allotbill", new QFilter[]{calTaskIdFilter});
        return allotDetailArr;
    }

    private Map<Long, List<DynamicObject>> getCalPersonIdRefAllotDetailMap(DynamicObject[] allotDetailArr) {
        if (allotDetailArr == null || allotDetailArr.length == 0) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        HashMap<Long, List<DynamicObject>> calPersonIdRefAllotDetailMap = new HashMap<Long, List<DynamicObject>>(allotDetailArr.length);
        for (DynamicObject dynamicObject : allotDetailArr) {
            Long calPersonId = dynamicObject.getLong("caltableid");
            ArrayList<DynamicObject> allotDetailList = (ArrayList<DynamicObject>)calPersonIdRefAllotDetailMap.get(calPersonId);
            if (allotDetailList == null) {
                allotDetailList = new ArrayList<DynamicObject>();
                calPersonIdRefAllotDetailMap.put(calPersonId, allotDetailList);
            }
            allotDetailList.add(dynamicObject);
        }
        return calPersonIdRefAllotDetailMap;
    }

    private Map<Long, DynamicObject> queryAllotBillMapByAllotBillSet(Set<Long> allotBillSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotbill");
        QFilter billNoFilter = new QFilter("id", "in", allotBillSet);
        DynamicObject[] allotBillArr = helper.query("billno,financingstatus,finaccountstatus", new QFilter[]{billNoFilter});
        HashMap<Long, DynamicObject> allotBillMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject allotBillObj : allotBillArr) {
            Long allotBillId = allotBillObj.getLong("id");
            if (allotBillMap.containsKey(allotBillId)) continue;
            allotBillMap.put(allotBillId, allotBillObj);
        }
        return allotBillMap;
    }
}

