/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.callist;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CalListRuleSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        SWCDataServiceHelper fieldHelper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        QFilter filter = new QFilter("isusedbyrule", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection configs = fieldHelper.queryOriginalCollection("name,number,type,isusedbyrule,perruleobj.number,perruleobj.name", new QFilter[]{filter});
        Set fieldNumbers = configs.stream().map(config -> config.getString("perruleobj.number") + '.' + config.getString("number")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            ArrayList<String> errFields = new ArrayList<String>(10);
            String dara = dataEntity.getDataEntity().getString("rulecontent");
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)dara, RuleConditionInfo.class);
            List conditionList = ruleConditionInfo.getConditionList();
            for (ConditionInfo conditionInfo : conditionList) {
                if (fieldNumbers.contains(conditionInfo.getParam())) continue;
                errFields.add(conditionInfo.getDisplayParam());
            }
            if (errFields.size() <= 0) continue;
            String msg = "";
            if (errFields.size() > 3) {
                msg = String.join((CharSequence)"\u3001", errFields.subList(0, 3));
                msg = msg + "...";
            } else {
                msg = String.join((CharSequence)"\u3001", errFields);
            }
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u5728\u201c\u6838\u7b97\u540d\u5355\u5b57\u6bb5\u914d\u7f6e\u201d\u4e2d\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u53ef\u7528\u4e8e\u6838\u7b97\u540d\u5355\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CalListRuleSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), msg));
        }
    }
}

