/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.formula;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.formula.FormulaParseService;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaFormatHelper;
import kd.swc.hsas.business.formula.helper.FormulaSplitHelper;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class FormulaSubmitValidator
extends SWCDataBaseValidator {
    private static final Log logger = LogFactory.getLog(FormulaSubmitValidator.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map variables = this.getOption().getVariables();
        String isSubmit = (String)variables.get("submit");
        String appCacheKey = (String)variables.get("formulaOpVar");
        HashSet<String> subKeySet = new HashSet<String>(16);
        DynamicObject formula = null;
        for (ExtendedDataEntity entity : dataEntities) {
            formula = entity.getDataEntity();
            if (SWCStringUtils.isEmpty((String)formula.getString("originalexp"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u516c\u5f0f\u201c%s\u201d\u672a\u914d\u7f6e\u516c\u5f0f\u5185\u5bb9\u3002", (String)"FormulaSubmitValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[]{formula.getString("name")}));
                continue;
            }
            if (!formula.getBoolean("isdraft") || !SWCStringUtils.equals((String)Boolean.TRUE.toString(), (String)isSubmit)) continue;
            this.parseFormula(entity, appCacheKey, subKeySet);
        }
        if (subKeySet.size() > 0) {
            this.getOption().setVariableValue("subKeySet", SerializationUtils.toJsonString(subKeySet));
        }
    }

    private boolean parseFormula(ExtendedDataEntity entity, String appCacheKey, Set<String> subKeySet) {
        String subKey;
        DynamicObject formula = entity.getDataEntity();
        boolean isCheckPass = true;
        String useType = formula.getString("usetype");
        if ("1".equals(useType)) {
            subKey = "formulaForProration";
        } else {
            String calBlock = formula.getString("salaryitem.calblock");
            long countryId = formula.getLong("country.id");
            subKey = String.format(Locale.ROOT, "formulaitem_%s_%s", calBlock, countryId);
        }
        subKeySet.add(subKey);
        try {
            Map dataMap = FormulaDataServiceHelper.getAllItemDataForSubmit((DynamicObject)formula, (String)appCacheKey, (String)subKey);
            FormulaParseService formulaParse = new FormulaParseService();
            FormulaInfo formulaInfo = formulaParse.parseFormula(formula, dataMap);
            FormulaSplitHelper formulaSplitHelper = new FormulaSplitHelper();
            List nodes = formulaSplitHelper.getOriginalNodesWithComment(formulaInfo.getOriginalCode());
            String originalExp = FormulaFormatHelper.formatFormula((List)nodes);
            nodes = formulaSplitHelper.getOriginalNodesWithComment(formulaInfo.getUniqueKeyCode());
            String uniqueKeyExp = FormulaFormatHelper.formatFormula((List)nodes);
            formula.set("executeexp", (Object)formulaInfo.getExecuteCode());
            formula.set("uniquecodeexp", (Object)uniqueKeyExp);
            formula.set("originalexp", (Object)originalExp);
            formula.set("isdraft", (Object)Boolean.FALSE);
            formula.set("dependonfunc", (Object)SWCListUtils.join((Set)formulaInfo.getFcUniqueCodeSet(), (String)","));
            formula.set("dependonsitem", (Object)SWCListUtils.join((Set)formulaInfo.getSlUniqueCodeSet(), (String)","));
            formula.set("dependonbsitem", (Object)SWCListUtils.join((Set)formulaInfo.getBsUniqueCodeSet(), (String)","));
            formula.set("dependonspitem", (Object)SWCListUtils.join((Set)formulaInfo.getSpUniqueCodeSet(), (String)","));
            formula.set("dependondatagrade", (Object)SWCListUtils.join((Set)formulaInfo.getDmUniqueCodeSet(), (String)","));
            formula.set("dependonacc", (Object)SWCListUtils.join((Set)formulaInfo.getAcUniqueCodeSet(), (String)","));
            formula.set("dependonftitem", (Object)SWCListUtils.join((Set)formulaInfo.getFtUniqueCodeSet(), (String)","));
            formula.set("bsitemprop", (Object)SWCListUtils.join((Set)formulaInfo.getBspUniqueCodeSet(), (String)","));
        }
        catch (Exception ex) {
            logger.error("parseFormula error", (Throwable)ex);
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u516c\u5f0f\u4fdd\u5b58\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u5c06\u516c\u5f0f\u4f53\u8c03\u6574\u51c6\u786e\u540e\u91cd\u8bd5\u3002", (String)"FormulaSubmitValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            isCheckPass = false;
        }
        return isCheckPass;
    }
}

