/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.guide;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CalPayrollTaskSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
            List<String> orderFieldList = Arrays.asList("payrollgroup.id", "payrollgroupv.id", "payrollscene.id", "calrule.id", "periodtype.id", "callistrule.id");
            OperateOption operateOption = this.getOption();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject calPeriodObj;
                DynamicObject payrollSceneVInfo;
                DynamicObject taskDyObj = dataEntity.getDataEntity();
                String taskStatus = taskDyObj.getString("taskstatus");
                if (!CalPayrollTaskStateEnum.CREATE.getCode().equals(taskStatus) && !CalPayrollTaskStateEnum.UNCAL.getCode().equals(taskStatus)) continue;
                Map fieldErrMsgWhenSaveMap = PayRollTaskService.getFieldErrMsgWhenSaveMap((boolean)false);
                if (operateOption.tryGetVariableValue("allmodify", new RefObject((Object)Boolean.FALSE.toString()))) {
                    if (!payRollTaskService.verifyCalRuleV(taskDyObj, taskDyObj.getDate("ENDDATE"))) continue;
                    operateOption.setVariableValue("isSaveErrorMark", "calrulev");
                    String errMsg = (String)fieldErrMsgWhenSaveMap.get("partmodify");
                    if (errMsg == null) continue;
                    this.addFatalErrorMessage(dataEntity, errMsg);
                    continue;
                }
                Map errFieldMap = payRollTaskService.checkFieldsBeforeSaveDataAndGetErrMap(dataEntity.getDataEntity(), orderFieldList);
                if (errFieldMap.get("SaveErrorField") != null) {
                    operateOption.setVariableValue("isSaveErrorMark", (String)errFieldMap.get("isSaveErrorMark"));
                    String errMsg = (String)fieldErrMsgWhenSaveMap.get(errFieldMap.get("SaveErrorField"));
                    if (errMsg != null) {
                        this.addFatalErrorMessage(dataEntity, errMsg);
                    }
                }
                if (!(payrollSceneVInfo = taskDyObj.getDynamicObject("payrollscenev")).getBoolean("isenableatt") || !SWCObjectUtils.isEmpty((Object)(calPeriodObj = payRollTaskService.getAttDateRange(payrollSceneVInfo, taskDyObj.getDynamicObject("period"), payrollSceneVInfo.getDynamicObject("periodtype"))))) continue;
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u671f\u95f4\u65e0\u53ef\u7528\u7684\u201c\u4e0a\u4e2a\u671f\u95f4\u201d\u6216\u201c\u4e0a\u4e0a\u4e2a\u671f\u95f4\u201d\uff0c\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u751f\u6210\u5931\u8d25\u3002", (String)"CalPayrollTaskSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, errorMsg);
            }
        }
    }
}

