/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.importtask;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class ImportTaskValidator
extends SWCDataBaseValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey)) {
            this.checkNumber();
        } else if (SWCStringUtils.equals((String)"delete", (String)operateKey)) {
            this.checkDelete();
        }
    }

    private void checkNumber() {
        List codeRuleInfoList = (List)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"ICodeRuleService", (String)"getAllCodeRuleByEntity", (Object[])new Object[]{"hsas_importtask"});
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (!CollectionUtils.isEmpty((Collection)codeRuleInfoList)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u3002\n", (String)"ImportTaskValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void checkDelete() {
        List<Long> dataIdList = Arrays.stream(this.dataEntities).map(dataEntitie -> dataEntitie.getDataEntity().getLong("id")).collect(Collectors.toList());
        Set<Long> usedDataIdSet = this.getUsedIdSet("hsas_temporarydata", dataIdList);
        String error = ResManager.loadKDString((String)"\u8be5\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u4e2d\u5b58\u5728\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002\n", (String)"ImportTaskValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long id = dataEntity.getDataEntity().getLong("id");
            if (!usedDataIdSet.contains(id)) continue;
            this.addMessage(dataEntity, error, ErrorLevel.FatalError);
        }
    }

    private Set<Long> getUsedIdSet(String entityId, List<Long> dataIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityId);
        DynamicObjectCollection objs = helper.queryOriginalCollection("importtask.id", new QFilter[]{new QFilter("importtask.id", "in", dataIdList)});
        HashSet<Long> dataIdSet = new HashSet<Long>(objs.size());
        for (DynamicObject obj : objs) {
            dataIdSet.add(obj.getLong("importtask.id"));
        }
        return dataIdSet;
    }
}

