/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.onhold;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class OnHoldBillStopPayValidator
extends SWCDataBaseValidator {
    private static final String SWC_HSAS_OPPLUGIN = "swc-hsas-opplugin";
    private static final String SIMPLE_NAME = OnHoldBillStopPayValidator.class.getSimpleName();
    private static final List<String> ONHOLDSTATUS_UNALLOWEDSTOPPAY = Arrays.asList(OnHoldStatusEnum.STATUS_SAVE.getCode() + "", OnHoldStatusEnum.STATUS_RELEASE.getCode() + "", OnHoldStatusEnum.STATUS_STOPPAY.getCode() + "", OnHoldStatusEnum.STATUS_TOPAY.getCode() + "");

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, ExtendedDataEntity> onHoldIdToEntityMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject temObj = dataEntity.getDataEntity();
            onHoldIdToEntityMap.put(temObj.getLong("id"), dataEntity);
        }
        this.checkOnHoldStopPay(onHoldIdToEntityMap);
    }

    private void checkOnHoldStopPay(Map<Long, ExtendedDataEntity> onHoldIdToEntityMap) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("id", "in", onHoldIdToEntityMap.keySet());
        for (DynamicObject dynamicObject : dynamicObjects = helper.query("id,status,caltask.number,person,salaryfile.number", new QFilter[]{qFilter})) {
            String onHoldStatus = dynamicObject.getString("status");
            if (ONHOLDSTATUS_UNALLOWEDSTOPPAY.indexOf(onHoldStatus) < 0) continue;
            String personName = dynamicObject.getString("person.person.name");
            String personNum = dynamicObject.getString("person.empnumber");
            String calTaskNum = dynamicObject.getString("caltask.number");
            String salaryFileNum = dynamicObject.getString("salaryfile.number");
            int status = Integer.parseInt(onHoldStatus);
            String msg = null;
            switch (status) {
                case 0: {
                    if (SWCStringUtils.equals(null, (String)calTaskNum)) {
                        msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848({2})\u4e3a{3}\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\uff0c\u8bf7\u5148\u8fdb\u884c\u505c\u7f13\u53d1\u518d\u7ec8\u6b62\u53d1\u653e\u3002", (String)(SIMPLE_NAME + "_0"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, salaryFileNum, OnHoldStatusEnum.STATUS_SAVE.getDesc());
                        break;
                    }
                    msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u6838\u7b97\u4efb\u52a1({2})\u4e3a{3}\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\uff0c\u8bf7\u5148\u8fdb\u884c\u505c\u7f13\u53d1\u518d\u7ec8\u6b62\u53d1\u653e\u3002", (String)(SIMPLE_NAME + "_1"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, calTaskNum, OnHoldStatusEnum.STATUS_SAVE.getDesc());
                    break;
                }
                case 1: {
                    if (SWCStringUtils.equals(null, (String)calTaskNum)) {
                        msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848({2}){3}\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_2"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, salaryFileNum, OnHoldStatusEnum.STATUS_RELEASE.getDesc());
                        break;
                    }
                    msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u6838\u7b97\u4efb\u52a1({2}){3}\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_3"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, calTaskNum, OnHoldStatusEnum.STATUS_RELEASE.getDesc());
                    break;
                }
                case 4: {
                    if (SWCStringUtils.equals(null, (String)calTaskNum)) {
                        msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848({2})\u5df2{3}\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_4"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, salaryFileNum, OnHoldStatusEnum.STATUS_STOPPAY.getDesc());
                        break;
                    }
                    msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u6838\u7b97\u4efb\u52a1({2})\u5df2{3}\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_5"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, calTaskNum, OnHoldStatusEnum.STATUS_STOPPAY.getDesc());
                    break;
                }
                case 3: {
                    msg = SWCStringUtils.equals(null, (String)calTaskNum) ? MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848({2}){3}\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_2"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, salaryFileNum, OnHoldStatusEnum.STATUS_TOPAY.getDesc()) : MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u6838\u7b97\u4efb\u52a1({2}){3}\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u64cd\u4f5c\u3002", (String)(SIMPLE_NAME + "_3"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, calTaskNum, OnHoldStatusEnum.STATUS_TOPAY.getDesc());
                }
            }
            this.addFatalErrorMessage(onHoldIdToEntityMap.get(dynamicObject.getLong("id")), msg);
        }
    }
}

