/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.onhold;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class OnHoldBillSubmitValidator
extends SWCDataBaseValidator {
    private static final String SWC_HSAS_OPPLUGIN = "swc-hsas-opplugin";
    private static final String SIMPLE_NAME = OnHoldBillSubmitValidator.class.getSimpleName();
    private static final List<String> ONHOLDBILL_ONHOLDSTATUS_BLACK = Arrays.asList(OnHoldStatusEnum.STATUS_ONHOLD.getCode() + "", OnHoldStatusEnum.STATUS_STOPPAY.getCode() + "", OnHoldStatusEnum.STATUS_TOPAY.getCode() + "");
    private static final List<String> ONHOLDBILL_PAYSTATE_BLACK = Arrays.asList(PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode());

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, Long> validCalTableIdToOnHoldIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, ExtendedDataEntity> onHoldIdToEntityMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject tempObj = dataEntity.getDataEntity();
            onHoldIdToEntityMap.put(tempObj.getLong("id"), dataEntity);
        }
        this.checkOnHoldSubmit(onHoldIdToEntityMap, validCalTableIdToOnHoldIdMap);
        if (!validCalTableIdToOnHoldIdMap.isEmpty()) {
            this.checkCalTableSubmit(onHoldIdToEntityMap, validCalTableIdToOnHoldIdMap);
        }
        this.checkSalaryFileOnHoldStatus(dataEntities);
    }

    private void checkSalaryFileOnHoldStatus(ExtendedDataEntity[] dataEntities) {
        List<Object> cacheSalaryFileList;
        ArrayList<ExtendedDataEntity> salaryFileOnHoldList = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long calTaskId = dynamicObject.getLong("caltask.id");
            if (calTaskId != null && calTaskId != 0L) continue;
            salaryFileOnHoldList.add(dataEntity);
        }
        if (salaryFileOnHoldList.size() == 0) {
            return;
        }
        HashMap<Long, ArrayList<ExtendedDataEntity>> cacheSalaryFileMap = new HashMap<Long, ArrayList<ExtendedDataEntity>>(salaryFileOnHoldList.size());
        for (ExtendedDataEntity dataEntity : salaryFileOnHoldList) {
            DynamicObject salaryFileOnHoldObj = dataEntity.getDataEntity();
            Long l = salaryFileOnHoldObj.getLong("salaryfile.id");
            if (l == null || l == 0L) continue;
            cacheSalaryFileList = (ArrayList<ExtendedDataEntity>)cacheSalaryFileMap.get(l);
            if (cacheSalaryFileList == null) {
                cacheSalaryFileList = new ArrayList<ExtendedDataEntity>(10);
            }
            cacheSalaryFileList.add(dataEntity);
            cacheSalaryFileMap.put(l, (ArrayList<ExtendedDataEntity>)cacheSalaryFileList);
        }
        HashSet salaryFileIdSet = new HashSet(cacheSalaryFileMap.size());
        HashSet<Long> onHoldIdSet = new HashSet<Long>(cacheSalaryFileMap.size());
        for (Map.Entry entry : cacheSalaryFileMap.entrySet()) {
            DynamicObject salaryFileOnHoldObj;
            cacheSalaryFileList = (List)entry.getValue();
            if (cacheSalaryFileList.size() > 1) {
                for (ExtendedDataEntity dataEntity : cacheSalaryFileList) {
                    salaryFileOnHoldObj = dataEntity.getDataEntity();
                    String personName = salaryFileOnHoldObj.getString("person.person.name");
                    String personNumber = salaryFileOnHoldObj.getString("person.person.number");
                    String salaryFileNumber = salaryFileOnHoldObj.getString("salaryfile.number");
                    String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1}):\u4eba\u5458\u85aa\u8d44\u6863\u6848{2}\u53ea\u80fd\u5b58\u5728\u4e00\u884c\u505c\u7f13\u53d1\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u89e3\u85aa\u201d\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5bf9\u591a\u6761\u6570\u636e\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)(SIMPLE_NAME + "_4"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNumber, salaryFileNumber);
                    this.addFatalErrorMessage(dataEntity, errorMsg);
                }
                continue;
            }
            for (ExtendedDataEntity dataEntity : cacheSalaryFileList) {
                salaryFileOnHoldObj = dataEntity.getDataEntity();
                String onHoldStatus = salaryFileOnHoldObj.getString("status");
                if (!SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.STATUS_SAVE.getCode())) && !SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()))) continue;
                salaryFileIdSet.add(entry.getKey());
                onHoldIdSet.add(salaryFileOnHoldObj.getLong("id"));
            }
        }
        if (salaryFileIdSet.size() == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        qFilter.and("id", "not in", onHoldIdSet);
        qFilter.and("status", "in", (Object)new String[]{String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_SAVE.getCode())});
        qFilter.and("caltask.id", "=", (Object)0);
        DynamicObjectCollection onHoldColl = helper.queryOriginalCollection("id,salaryfile.id", new QFilter[]{qFilter});
        if (onHoldColl == null || onHoldColl.size() == 0) {
            return;
        }
        HashSet<Long> querySalaryFileIdSet = new HashSet<Long>(onHoldColl.size());
        for (DynamicObject onHoldObj : onHoldColl) {
            Long salaryFileId = onHoldObj.getLong("salaryfile.id");
            if (salaryFileId == null || salaryFileId == 0L) continue;
            querySalaryFileIdSet.add(salaryFileId);
        }
        for (Long salaryFileId : querySalaryFileIdSet) {
            List onHoldList = (List)cacheSalaryFileMap.get(salaryFileId);
            if (onHoldList == null || onHoldList.size() == 0) continue;
            for (ExtendedDataEntity dataEntity : onHoldList) {
                DynamicObject salaryFileOnHoldObj = dataEntity.getDataEntity();
                String personName = salaryFileOnHoldObj.getString("person.person.name");
                String personNumber = salaryFileOnHoldObj.getString("person.person.number");
                String salaryFileNumber = salaryFileOnHoldObj.getString("salaryfile.number");
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1}):\u4eba\u5458\u85aa\u8d44\u6863\u6848{2}\u53ea\u80fd\u5b58\u5728\u4e00\u884c\u505c\u7f13\u53d1\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u89e3\u85aa\u201d\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)(SIMPLE_NAME + "_5"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNumber, salaryFileNumber);
                this.addFatalErrorMessage(dataEntity, errorMsg);
            }
        }
    }

    private void checkOnHoldSubmit(Map<Long, ExtendedDataEntity> onHoldIdToEntityMap, Map<Long, Long> validCalTableIdToOnHoldIdMap) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        for (DynamicObject dynamicObject : dynamicObjects = helper.query("id,status,caltableid,person,salaryfile.number", new QFilter[]{new QFilter("id", "in", onHoldIdToEntityMap.keySet())})) {
            String onHoldStatus = dynamicObject.getString("status");
            if (ONHOLDBILL_ONHOLDSTATUS_BLACK.indexOf(onHoldStatus) >= 0) {
                String personName = dynamicObject.getString("person.person.name");
                String personNum = dynamicObject.getString("person.person.number");
                String salaryFileNum = dynamicObject.getString("salaryfile.number");
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u85aa\u8d44\u6863\u6848\u7f16\u53f7{2}\u4e3a{3}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)(SIMPLE_NAME + "_0"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, personNum, salaryFileNum, OnHoldStatusEnum.getDesc((Integer)Integer.valueOf(onHoldStatus)));
                this.addFatalErrorMessage(onHoldIdToEntityMap.get(dynamicObject.getLong("id")), msg);
                continue;
            }
            if (dynamicObject.getLong("caltableid") == 0L) continue;
            validCalTableIdToOnHoldIdMap.put(dynamicObject.getLong("caltableid"), dynamicObject.getLong("id"));
        }
    }

    private void checkCalTableSubmit(Map<Long, ExtendedDataEntity> onHoldIdToEntityMap, Map<Long, Long> validCalTableIdToOnHoldIdMap) {
        SWCDataServiceHelper caltableHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,calstate,paystatus,employee,salaryfile.number,caltask.number";
        QFilter idFilter = new QFilter("id", "in", validCalTableIdToOnHoldIdMap.keySet());
        DynamicObject[] calTableArr = caltableHelper.query(selectProperties, new QFilter[]{idFilter});
        List calTableIds = Arrays.stream(calTableArr).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Set calTableSetIds = OnHoldBillHelper.validateSalaryFilePayDetail(calTableIds);
        for (DynamicObject obj2 : calTableArr) {
            String payState = obj2.getString("paystatus");
            long id = obj2.getLong("id");
            String empNumber = obj2.getString("employee.person.number");
            String personName = obj2.getString("employee.person.name");
            String taskNumber = obj2.getString("caltask.number");
            if (ONHOLDBILL_PAYSTATE_BLACK.indexOf(payState) >= 0) {
                String salaryFileNumber = obj2.getString("salaryfile.number");
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u85aa\u8d44\u6863\u6848\u7f16\u53f7({2})\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{3}{4}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)(SIMPLE_NAME + "_1"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, empNumber, salaryFileNumber, taskNumber, PayStateEnum.getDesc((String)payState));
                ExtendedDataEntity dataEntity = onHoldIdToEntityMap.get(validCalTableIdToOnHoldIdMap.get(id));
                this.addFatalErrorMessage(dataEntity, msg);
                continue;
            }
            if (!calTableSetIds.contains(String.valueOf(id))) continue;
            String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{2}\u4e2d\u7684\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u5bfc\u51fa\u62a5\u76d8\u3002\u8bf7\u786e\u8ba4\u62a5\u76d8\u6587\u4ef6\u4e2d\u660e\u7ec6\u5747\u672a\u4ed8\u6b3e\u5e76\u5df2\u5931\u6548\uff0c\u907f\u514d\u91cd\u590d\u652f\u4ed8\uff01", (String)(SIMPLE_NAME + "_2"), (String)SWC_HSAS_OPPLUGIN, (Object[])new Object[0]), personName, empNumber, taskNumber);
            ExtendedDataEntity dataEntity = onHoldIdToEntityMap.get(validCalTableIdToOnHoldIdMap.get(id));
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }
}

