/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.payrollscene;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsas.business.payrollscene.errorinfo.PayRollSceneErrorInfo;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.vo.SceneGroupVO;
import kd.swc.hsbp.common.vo.SceneRuleVO;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class PayRollSceneSaveValidator
extends SWCDataBaseValidator {
    private static final Set<String> NEED_CHECK_OP_FIELDS = Sets.newHashSet((Object[])new String[]{"changesave", "save", "submit", "donothing_confirmchange", "auditconfirmchange", "confirmchangenoaudit"});

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        OperateOption operateOption = this.getOption();
        if (!NEED_CHECK_OP_FIELDS.contains(this.getOperateKey())) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject payrollSceneInfo = dataEntity.getDataEntity();
            Map errMsgMap = PayRollSceneErrorInfo.getErrMsgMap();
            SWCPayRollSceneService swcPayRollSceneService = SWCPayRollSceneService.createInstance();
            List errFields = swcPayRollSceneService.checkFieldsAuditAndEnable(payrollSceneInfo);
            for (String errField : errFields) {
                String errMsg = (String)errMsgMap.get(errField);
                if (errMsg == null) continue;
                this.addFatalErrorMessage(dataEntity, errMsg);
            }
            if (dataEntities.length != 1 || !operateOption.tryGetVariableValue("isDetail", new RefObject((Object)Boolean.TRUE.toString()))) continue;
            String groupcontent = payrollSceneInfo.getString("groupcontent");
            List sceneGroupVOS = (List)JSON.parseObject((String)groupcontent, (TypeReference)new TypeReference<List<SceneGroupVO>>(){}, (Feature[])new Feature[0]);
            if (SWCListUtils.isEmpty((List)sceneGroupVOS)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u5206\u7ec4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u7ec4\u89c4\u5219\u3002", (String)"PayRollSceneSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return;
            }
            for (SceneGroupVO groupVO : sceneGroupVOS) {
                List rules = groupVO.getRules();
                if (SWCListUtils.isEmpty((List)rules)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u5206\u7ec4\u201c{0}\u201d\u4e2d\uff0c\u5e38\u7528\u7b5b\u9009\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6570\u636e\u3002", (String)"PayRollSceneSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[]{groupVO.getName().getLocaleValue()}));
                    continue;
                }
                for (int i = 0; i < rules.size(); ++i) {
                    SceneRuleVO rule = (SceneRuleVO)rules.get(i);
                    if (!"1".equals(rule.getAttachcondition()) || !SWCListUtils.isEmpty((List)rule.getBizItems())) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u5206\u7ec4\u201c{0}\u201d\u7684\u6838\u7b97\u540d\u5355\u7b5b\u9009\u7b2c{1}\u884c\u4e1a\u52a1\u9879\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PayRollSceneSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[]{groupVO.getName().getLocaleValue(), String.valueOf(i + 1)}));
                }
            }
        }
    }
}

