/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.payschedule;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class PayScheduleCusSaveValidator
extends SWCDataBaseValidator {
    private static final SWCDataServiceHelper HELPER = new SWCDataServiceHelper("hsas_payschedule");

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject existDy;
            DynamicObject paySchDy = extendedDataEntity.getDataEntity();
            Date endDate = paySchDy.getDate("enddate");
            Date startDate = paySchDy.getDate("startdate");
            if (endDate == null || startDate == null) continue;
            if (endDate.before(startDate)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u7684\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PayScheduleSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (currentDate.after(endDate) && !format.format(currentDate).equals(format.format(endDate))) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u521b\u5efa\u8fc7\u53bb\u65e5\u671f\u7684\u65e5\u7a0b\u3002", (String)"PayScheduleSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            long id = paySchDy.getLong("id");
            QFilter numberFilter = new QFilter("number", "=", (Object)paySchDy.getString("number"));
            ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{numberFilter});
            if (id != 0L) {
                qFilters.add(new QFilter("id", "!=", (Object)id));
            }
            if (!Objects.nonNull(existDy = HELPER.queryOne(qFilters.toArray(new QFilter[0])))) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"PayScheduleSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }
}

